/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.timepicker;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.util.Pair;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import androidx.annotation.Dimension;
import androidx.annotation.FloatRange;
import androidx.annotation.Nullable;
import androidx.annotation.Px;
import androidx.core.view.ViewCompat;
import com.google.android.material.R;
import com.google.android.material.animation.AnimationUtils;
import com.google.android.material.internal.ViewUtils;
import com.google.android.material.math.MathUtils;
import com.google.android.material.motion.MotionUtils;
import java.util.ArrayList;
import java.util.List;

class ClockHandView
extends View {
    private static final int DEFAULT_ANIMATION_DURATION = 200;
    private final int animationDuration;
    private final TimeInterpolator animationInterpolator;
    private final ValueAnimator rotationAnimator = new ValueAnimator();
    private boolean animatingOnTouchUp;
    private float downX;
    private float downY;
    private boolean isInTapRegion;
    private final int scaledTouchSlop;
    private boolean isMultiLevel;
    private final List<OnRotateListener> listeners = new ArrayList<OnRotateListener>();
    private final int selectorRadius;
    private final float centerDotRadius;
    private final Paint paint = new Paint();
    private final RectF selectorBox = new RectF();
    @Px
    private final int selectorStrokeWidth;
    private float originalDeg;
    private boolean changedDuringTouch;
    private OnActionUpListener onActionUpListener;
    private double degRad;
    private int circleRadius;
    private int currentLevel = 1;

    public ClockHandView(Context context) {
        this(context, null);
    }

    public ClockHandView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, R.attr.materialClockStyle);
    }

    public ClockHandView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.ClockHandView, defStyleAttr, R.style.Widget_MaterialComponents_TimePicker_Clock);
        this.animationDuration = MotionUtils.resolveThemeDuration(context, R.attr.motionDurationLong2, 200);
        this.animationInterpolator = MotionUtils.resolveThemeInterpolator(context, R.attr.motionEasingEmphasizedInterpolator, AnimationUtils.FAST_OUT_SLOW_IN_INTERPOLATOR);
        this.circleRadius = a.getDimensionPixelSize(R.styleable.ClockHandView_materialCircleRadius, 0);
        this.selectorRadius = a.getDimensionPixelSize(R.styleable.ClockHandView_selectorSize, 0);
        Resources res = this.getResources();
        this.selectorStrokeWidth = res.getDimensionPixelSize(R.dimen.material_clock_hand_stroke_width);
        this.centerDotRadius = res.getDimensionPixelSize(R.dimen.material_clock_hand_center_dot_radius);
        int selectorColor = a.getColor(R.styleable.ClockHandView_clockHandColor, 0);
        this.paint.setAntiAlias(true);
        this.paint.setColor(selectorColor);
        this.setHandRotation(0.0f);
        this.scaledTouchSlop = ViewConfiguration.get((Context)context).getScaledTouchSlop();
        ViewCompat.setImportantForAccessibility(this, 2);
        a.recycle();
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        if (!this.rotationAnimator.isRunning()) {
            this.setHandRotation(this.getHandRotation());
        }
    }

    public void setHandRotation(@FloatRange(from=0.0, to=360.0) float degrees) {
        this.setHandRotation(degrees, false);
    }

    public void setHandRotation(@FloatRange(from=0.0, to=360.0) float degrees, boolean animate) {
        if (this.rotationAnimator != null) {
            this.rotationAnimator.cancel();
        }
        if (!animate) {
            this.setHandRotationInternal(degrees, false);
            return;
        }
        Pair<Float, Float> animationValues = this.getValuesForAnimation(degrees);
        this.rotationAnimator.setFloatValues(new float[]{((Float)animationValues.first).floatValue(), ((Float)animationValues.second).floatValue()});
        this.rotationAnimator.setDuration((long)this.animationDuration);
        this.rotationAnimator.setInterpolator(this.animationInterpolator);
        this.rotationAnimator.addUpdateListener(animation -> {
            float animatedValue = ((Float)animation.getAnimatedValue()).floatValue();
            this.setHandRotationInternal(animatedValue, true);
        });
        this.rotationAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationCancel(Animator animation) {
                animation.end();
            }
        });
        this.rotationAnimator.start();
    }

    private Pair<Float, Float> getValuesForAnimation(float degrees) {
        float currentDegrees = this.getHandRotation();
        if (Math.abs(currentDegrees - degrees) > 180.0f) {
            if (currentDegrees > 180.0f && degrees < 180.0f) {
                degrees += 360.0f;
            }
            if (currentDegrees < 180.0f && degrees > 180.0f) {
                currentDegrees += 360.0f;
            }
        }
        return new Pair((Object)Float.valueOf(currentDegrees), (Object)Float.valueOf(degrees));
    }

    private void setHandRotationInternal(@FloatRange(from=0.0, to=360.0) float degrees, boolean animate) {
        this.originalDeg = degrees %= 360.0f;
        float angDeg = this.originalDeg - 90.0f;
        this.degRad = Math.toRadians(angDeg);
        int yCenter = this.getHeight() / 2;
        int xCenter = this.getWidth() / 2;
        int leveledCircleRadius = this.getLeveledCircleRadius(this.currentLevel);
        float selCenterX = (float)xCenter + (float)leveledCircleRadius * (float)Math.cos(this.degRad);
        float selCenterY = (float)yCenter + (float)leveledCircleRadius * (float)Math.sin(this.degRad);
        this.selectorBox.set(selCenterX - (float)this.selectorRadius, selCenterY - (float)this.selectorRadius, selCenterX + (float)this.selectorRadius, selCenterY + (float)this.selectorRadius);
        for (OnRotateListener listener2 : this.listeners) {
            listener2.onRotate(degrees, animate);
        }
        this.invalidate();
    }

    public void setAnimateOnTouchUp(boolean animating) {
        this.animatingOnTouchUp = animating;
    }

    public void addOnRotateListener(OnRotateListener listener2) {
        this.listeners.add(listener2);
    }

    public void setOnActionUpListener(OnActionUpListener listener2) {
        this.onActionUpListener = listener2;
    }

    @FloatRange(from=0.0, to=360.0)
    public float getHandRotation() {
        return this.originalDeg;
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.drawSelector(canvas);
    }

    private void drawSelector(Canvas canvas) {
        int yCenter = this.getHeight() / 2;
        int xCenter = this.getWidth() / 2;
        int leveledCircleRadius = this.getLeveledCircleRadius(this.currentLevel);
        float selCenterX = (float)xCenter + (float)leveledCircleRadius * (float)Math.cos(this.degRad);
        float selCenterY = (float)yCenter + (float)leveledCircleRadius * (float)Math.sin(this.degRad);
        this.paint.setStrokeWidth(0.0f);
        canvas.drawCircle(selCenterX, selCenterY, (float)this.selectorRadius, this.paint);
        double sin = Math.sin(this.degRad);
        double cos = Math.cos(this.degRad);
        float lineLength = leveledCircleRadius - this.selectorRadius;
        float linePointX = xCenter + (int)((double)lineLength * cos);
        float linePointY = yCenter + (int)((double)lineLength * sin);
        this.paint.setStrokeWidth((float)this.selectorStrokeWidth);
        canvas.drawLine((float)xCenter, (float)yCenter, linePointX, linePointY, this.paint);
        canvas.drawCircle((float)xCenter, (float)yCenter, this.centerDotRadius, this.paint);
    }

    public RectF getCurrentSelectorBox() {
        return this.selectorBox;
    }

    public int getSelectorRadius() {
        return this.selectorRadius;
    }

    public void setCircleRadius(@Dimension int circleRadius) {
        this.circleRadius = circleRadius;
        this.invalidate();
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public boolean onTouchEvent(MotionEvent event) {
        int action = event.getActionMasked();
        boolean forceSelection = false;
        boolean actionDown = false;
        boolean actionUp = false;
        float x = event.getX();
        float y = event.getY();
        switch (action) {
            case 0: {
                this.downX = x;
                this.downY = y;
                this.isInTapRegion = true;
                this.changedDuringTouch = false;
                actionDown = true;
                break;
            }
            case 1: 
            case 2: {
                int deltaX = (int)(x - this.downX);
                int deltaY = (int)(y - this.downY);
                int distance = deltaX * deltaX + deltaY * deltaY;
                boolean bl = this.isInTapRegion = distance > this.scaledTouchSlop;
                if (this.changedDuringTouch) {
                    forceSelection = true;
                }
                boolean bl2 = actionUp = action == 1;
                if (!this.isMultiLevel) break;
                this.adjustLevel(x, y);
                break;
            }
        }
        this.changedDuringTouch |= this.handleTouchInput(x, y, forceSelection, actionDown, actionUp);
        if (this.changedDuringTouch && actionUp && this.onActionUpListener != null) {
            this.onActionUpListener.onActionUp(this.getDegreesFromXY(x, y), this.isInTapRegion);
        }
        return true;
    }

    private void adjustLevel(float x, float y) {
        float buffer;
        int level2CircleRadius;
        int yCenter;
        int xCenter = this.getWidth() / 2;
        float selectionRadius = MathUtils.dist(xCenter, yCenter = this.getHeight() / 2, x, y);
        this.currentLevel = selectionRadius <= (float)(level2CircleRadius = this.getLeveledCircleRadius(2)) + (buffer = ViewUtils.dpToPx(this.getContext(), 12)) ? 2 : 1;
    }

    private boolean handleTouchInput(float x, float y, boolean forceSelection, boolean touchDown, boolean actionUp) {
        boolean valueChanged;
        int degrees = this.getDegreesFromXY(x, y);
        boolean bl = valueChanged = this.getHandRotation() != (float)degrees;
        if (touchDown && valueChanged) {
            return true;
        }
        if (valueChanged || forceSelection) {
            this.setHandRotation(degrees, actionUp && this.animatingOnTouchUp);
            return true;
        }
        return false;
    }

    private int getDegreesFromXY(float x, float y) {
        double dX;
        int xCenter = this.getWidth() / 2;
        int yCenter = this.getHeight() / 2;
        double dY = y - (float)yCenter;
        int degrees = (int)Math.toDegrees(Math.atan2(dY, dX = (double)(x - (float)xCenter))) + 90;
        if (degrees < 0) {
            degrees += 360;
        }
        return degrees;
    }

    int getCurrentLevel() {
        return this.currentLevel;
    }

    void setCurrentLevel(int level) {
        this.currentLevel = level;
        this.invalidate();
    }

    void setMultiLevel(boolean isMultiLevel) {
        if (this.isMultiLevel && !isMultiLevel) {
            this.currentLevel = 1;
        }
        this.isMultiLevel = isMultiLevel;
        this.invalidate();
    }

    @Dimension
    private int getLeveledCircleRadius(int level) {
        return level == 2 ? Math.round((float)this.circleRadius * 0.66f) : this.circleRadius;
    }

    public static interface OnActionUpListener {
        public void onActionUp(@FloatRange(from=0.0, to=360.0) float var1, boolean var2);
    }

    public static interface OnRotateListener {
        public void onRotate(@FloatRange(from=0.0, to=360.0) float var1, boolean var2);
    }
}

