/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.timepicker;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.view.View;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.ColorInt;
import androidx.appcompat.content.res.AppCompatResources;
import androidx.core.view.accessibility.AccessibilityNodeInfoCompat;
import com.google.android.material.R;
import com.google.android.material.button.MaterialButtonToggleGroup;
import com.google.android.material.color.MaterialColors;
import com.google.android.material.internal.TextWatcherAdapter;
import com.google.android.material.internal.ViewUtils;
import com.google.android.material.timepicker.ChipTextInputComboView;
import com.google.android.material.timepicker.ClickActionDelegate;
import com.google.android.material.timepicker.TimeModel;
import com.google.android.material.timepicker.TimePickerPresenter;
import com.google.android.material.timepicker.TimePickerTextInputKeyController;
import com.google.android.material.timepicker.TimePickerView;
import java.lang.reflect.Field;
import java.util.Locale;

class TimePickerTextInputPresenter
implements TimePickerView.OnSelectionChange,
TimePickerPresenter {
    private final LinearLayout timePickerView;
    private final TimeModel time;
    private final TextWatcher minuteTextWatcher = new TextWatcherAdapter(){

        @Override
        public void afterTextChanged(Editable s) {
            try {
                if (TextUtils.isEmpty((CharSequence)s)) {
                    TimePickerTextInputPresenter.this.time.setMinute(0);
                    return;
                }
                int minute = Integer.parseInt(s.toString());
                TimePickerTextInputPresenter.this.time.setMinute(minute);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    };
    private final TextWatcher hourTextWatcher = new TextWatcherAdapter(){

        @Override
        public void afterTextChanged(Editable s) {
            try {
                if (TextUtils.isEmpty((CharSequence)s)) {
                    TimePickerTextInputPresenter.this.time.setHour(0);
                    return;
                }
                int hour = Integer.parseInt(s.toString());
                TimePickerTextInputPresenter.this.time.setHour(hour);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    };
    private final ChipTextInputComboView minuteTextInput;
    private final ChipTextInputComboView hourTextInput;
    private final TimePickerTextInputKeyController controller;
    private final EditText hourEditText;
    private final EditText minuteEditText;
    private MaterialButtonToggleGroup toggle;

    public TimePickerTextInputPresenter(LinearLayout timePickerView, final TimeModel time) {
        this.timePickerView = timePickerView;
        this.time = time;
        Resources res = timePickerView.getResources();
        this.minuteTextInput = (ChipTextInputComboView)timePickerView.findViewById(R.id.material_minute_text_input);
        this.hourTextInput = (ChipTextInputComboView)timePickerView.findViewById(R.id.material_hour_text_input);
        TextView minuteLabel = (TextView)this.minuteTextInput.findViewById(R.id.material_label);
        TextView hourLabel = (TextView)this.hourTextInput.findViewById(R.id.material_label);
        minuteLabel.setText((CharSequence)res.getString(R.string.material_timepicker_minute));
        hourLabel.setText((CharSequence)res.getString(R.string.material_timepicker_hour));
        this.minuteTextInput.setTag(R.id.selection_type, 12);
        this.hourTextInput.setTag(R.id.selection_type, 10);
        if (time.format == 0) {
            this.setupPeriodToggle();
        }
        View.OnClickListener onClickListener = new View.OnClickListener(){

            public void onClick(View v) {
                TimePickerTextInputPresenter.this.onSelectionChanged((Integer)v.getTag(R.id.selection_type));
            }
        };
        this.hourTextInput.setOnClickListener(onClickListener);
        this.minuteTextInput.setOnClickListener(onClickListener);
        this.hourTextInput.addInputFilter(time.getHourInputValidator());
        this.minuteTextInput.addInputFilter(time.getMinuteInputValidator());
        this.hourEditText = this.hourTextInput.getTextInput().getEditText();
        this.minuteEditText = this.minuteTextInput.getTextInput().getEditText();
        if (Build.VERSION.SDK_INT < 21) {
            int primaryColor = MaterialColors.getColor((View)timePickerView, R.attr.colorPrimary);
            TimePickerTextInputPresenter.setCursorDrawableColor(this.hourEditText, primaryColor);
            TimePickerTextInputPresenter.setCursorDrawableColor(this.minuteEditText, primaryColor);
        }
        this.controller = new TimePickerTextInputKeyController(this.hourTextInput, this.minuteTextInput, time);
        this.hourTextInput.setChipDelegate(new ClickActionDelegate(timePickerView.getContext(), R.string.material_hour_selection){

            @Override
            public void onInitializeAccessibilityNodeInfo(View host, AccessibilityNodeInfoCompat info) {
                super.onInitializeAccessibilityNodeInfo(host, info);
                info.setContentDescription(host.getResources().getString(time.getHourContentDescriptionResId(), new Object[]{String.valueOf(time.getHourForDisplay())}));
            }
        });
        this.minuteTextInput.setChipDelegate(new ClickActionDelegate(timePickerView.getContext(), R.string.material_minute_selection){

            @Override
            public void onInitializeAccessibilityNodeInfo(View host, AccessibilityNodeInfoCompat info) {
                super.onInitializeAccessibilityNodeInfo(host, info);
                info.setContentDescription(host.getResources().getString(R.string.material_minute_suffix, new Object[]{String.valueOf(time.minute)}));
            }
        });
        this.initialize();
    }

    @Override
    public void initialize() {
        this.addTextWatchers();
        this.setTime(this.time);
        this.controller.bind();
    }

    private void addTextWatchers() {
        this.hourEditText.addTextChangedListener(this.hourTextWatcher);
        this.minuteEditText.addTextChangedListener(this.minuteTextWatcher);
    }

    private void removeTextWatchers() {
        this.hourEditText.removeTextChangedListener(this.hourTextWatcher);
        this.minuteEditText.removeTextChangedListener(this.minuteTextWatcher);
    }

    private void setTime(TimeModel time) {
        this.removeTextWatchers();
        Locale current = this.timePickerView.getResources().getConfiguration().locale;
        String minuteFormatted = String.format(current, "%02d", time.minute);
        String hourFormatted = String.format(current, "%02d", time.getHourForDisplay());
        this.minuteTextInput.setText(minuteFormatted);
        this.hourTextInput.setText(hourFormatted);
        this.addTextWatchers();
        this.updateSelection();
    }

    private void setupPeriodToggle() {
        this.toggle = (MaterialButtonToggleGroup)this.timePickerView.findViewById(R.id.material_clock_period_toggle);
        this.toggle.addOnButtonCheckedListener((group, checkedId, isChecked) -> {
            if (!isChecked) {
                return;
            }
            int period = checkedId == R.id.material_clock_period_pm_button ? 1 : 0;
            this.time.setPeriod(period);
        });
        this.toggle.setVisibility(0);
        this.updateSelection();
    }

    private void updateSelection() {
        if (this.toggle == null) {
            return;
        }
        this.toggle.check(this.time.period == 0 ? R.id.material_clock_period_am_button : R.id.material_clock_period_pm_button);
    }

    @Override
    public void onSelectionChanged(int selection) {
        this.time.selection = selection;
        this.minuteTextInput.setChecked(selection == 12);
        this.hourTextInput.setChecked(selection == 10);
        this.updateSelection();
    }

    @Override
    public void show() {
        this.timePickerView.setVisibility(0);
        this.onSelectionChanged(this.time.selection);
    }

    @Override
    public void hide() {
        View currentFocus = this.timePickerView.getFocusedChild();
        if (currentFocus != null) {
            ViewUtils.hideKeyboard(currentFocus, false);
        }
        this.timePickerView.setVisibility(8);
    }

    @Override
    public void invalidate() {
        this.setTime(this.time);
    }

    private static void setCursorDrawableColor(EditText view, @ColorInt int color2) {
        try {
            Context context = view.getContext();
            Field cursorDrawableResField = TextView.class.getDeclaredField("mCursorDrawableRes");
            cursorDrawableResField.setAccessible(true);
            int cursorDrawableResId = cursorDrawableResField.getInt(view);
            Field editorField = TextView.class.getDeclaredField("mEditor");
            editorField.setAccessible(true);
            Object editor = editorField.get(view);
            Class<?> clazz = editor.getClass();
            Field cursorDrawableField = clazz.getDeclaredField("mCursorDrawable");
            cursorDrawableField.setAccessible(true);
            Drawable drawable2 = AppCompatResources.getDrawable(context, cursorDrawableResId);
            drawable2.setColorFilter(color2, PorterDuff.Mode.SRC_IN);
            Drawable[] drawables = new Drawable[]{drawable2, drawable2};
            cursorDrawableField.set(editor, drawables);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void resetChecked() {
        this.minuteTextInput.setChecked(this.time.selection == 12);
        this.hourTextInput.setChecked(this.time.selection == 10);
    }

    public void clearCheck() {
        this.minuteTextInput.setChecked(false);
        this.hourTextInput.setChecked(false);
    }
}

