/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.transformation;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import androidx.annotation.CallSuper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.coordinatorlayout.widget.CoordinatorLayout;
import androidx.core.view.ViewCompat;
import com.google.android.material.expandable.ExpandableWidget;
import java.util.List;

@Deprecated
public abstract class ExpandableBehavior
extends CoordinatorLayout.Behavior<View> {
    private static final int STATE_UNINITIALIZED = 0;
    private static final int STATE_EXPANDED = 1;
    private static final int STATE_COLLAPSED = 2;
    private int currentState = 0;

    public ExpandableBehavior() {
    }

    public ExpandableBehavior(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    @Override
    public abstract boolean layoutDependsOn(CoordinatorLayout var1, View var2, View var3);

    protected abstract boolean onExpandedStateChange(View var1, View var2, boolean var3, boolean var4);

    @Override
    @CallSuper
    public boolean onLayoutChild(@NonNull CoordinatorLayout parent, final @NonNull View child, int layoutDirection) {
        ExpandableWidget dep;
        if (!ViewCompat.isLaidOut(child) && (dep = this.findExpandableWidget(parent, child)) != null && this.didStateChange(dep.isExpanded())) {
            final int expectedState = this.currentState = dep.isExpanded() ? 1 : 2;
            child.getViewTreeObserver().addOnPreDrawListener(new ViewTreeObserver.OnPreDrawListener(){

                public boolean onPreDraw() {
                    child.getViewTreeObserver().removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
                    if (ExpandableBehavior.this.currentState == expectedState) {
                        ExpandableBehavior.this.onExpandedStateChange((View)dep, child, dep.isExpanded(), false);
                    }
                    return false;
                }
            });
        }
        return false;
    }

    @Override
    @CallSuper
    public boolean onDependentViewChanged(CoordinatorLayout parent, View child, View dependency) {
        ExpandableWidget dep = (ExpandableWidget)dependency;
        boolean expanded = dep.isExpanded();
        if (this.didStateChange(expanded)) {
            this.currentState = dep.isExpanded() ? 1 : 2;
            return this.onExpandedStateChange((View)dep, child, dep.isExpanded(), true);
        }
        return false;
    }

    @Nullable
    protected ExpandableWidget findExpandableWidget(@NonNull CoordinatorLayout parent, @NonNull View child) {
        List<View> dependencies = parent.getDependencies(child);
        int size = dependencies.size();
        for (int i = 0; i < size; ++i) {
            View dependency = dependencies.get(i);
            if (!this.layoutDependsOn(parent, child, dependency)) continue;
            return (ExpandableWidget)dependency;
        }
        return null;
    }

    private boolean didStateChange(boolean expanded) {
        if (expanded) {
            return this.currentState == 0 || this.currentState == 2;
        }
        return this.currentState == 1;
    }

    @Nullable
    public static <T extends ExpandableBehavior> T from(@NonNull View view, @NonNull Class<T> klass) {
        ViewGroup.LayoutParams params = view.getLayoutParams();
        if (!(params instanceof CoordinatorLayout.LayoutParams)) {
            throw new IllegalArgumentException("The view is not a child of CoordinatorLayout");
        }
        CoordinatorLayout.Behavior behavior = ((CoordinatorLayout.LayoutParams)params).getBehavior();
        if (!(behavior instanceof ExpandableBehavior)) {
            throw new IllegalArgumentException("The view is not associated with ExpandableBehavior");
        }
        return (T)((ExpandableBehavior)klass.cast(behavior));
    }
}

