/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.transformation;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TypeEvaluator;
import android.animation.ValueAnimator;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.AttributeSet;
import android.util.Pair;
import android.util.Property;
import android.view.View;
import android.view.ViewAnimationUtils;
import android.view.ViewGroup;
import android.widget.ImageView;
import androidx.annotation.CallSuper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.coordinatorlayout.widget.CoordinatorLayout;
import androidx.core.view.ViewCompat;
import com.google.android.material.R;
import com.google.android.material.animation.AnimationUtils;
import com.google.android.material.animation.AnimatorSetCompat;
import com.google.android.material.animation.ArgbEvaluatorCompat;
import com.google.android.material.animation.ChildrenAlphaProperty;
import com.google.android.material.animation.DrawableAlphaProperty;
import com.google.android.material.animation.MotionSpec;
import com.google.android.material.animation.MotionTiming;
import com.google.android.material.animation.Positioning;
import com.google.android.material.circularreveal.CircularRevealCompat;
import com.google.android.material.circularreveal.CircularRevealHelper;
import com.google.android.material.circularreveal.CircularRevealWidget;
import com.google.android.material.floatingactionbutton.FloatingActionButton;
import com.google.android.material.math.MathUtils;
import com.google.android.material.transformation.ExpandableTransformationBehavior;
import com.google.android.material.transformation.TransformationChildCard;
import com.google.android.material.transformation.TransformationChildLayout;
import java.util.ArrayList;
import java.util.List;

@Deprecated
public abstract class FabTransformationBehavior
extends ExpandableTransformationBehavior {
    private final Rect tmpRect = new Rect();
    private final RectF tmpRectF1 = new RectF();
    private final RectF tmpRectF2 = new RectF();
    private final int[] tmpArray = new int[2];
    private float dependencyOriginalTranslationX;
    private float dependencyOriginalTranslationY;

    public FabTransformationBehavior() {
    }

    public FabTransformationBehavior(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    @Override
    @CallSuper
    public boolean layoutDependsOn(@NonNull CoordinatorLayout parent, @NonNull View child, @NonNull View dependency) {
        if (child.getVisibility() == 8) {
            throw new IllegalStateException("This behavior cannot be attached to a GONE view. Set the view to INVISIBLE instead.");
        }
        if (dependency instanceof FloatingActionButton) {
            int expandedComponentIdHint = ((FloatingActionButton)dependency).getExpandedComponentIdHint();
            return expandedComponentIdHint == 0 || expandedComponentIdHint == child.getId();
        }
        return false;
    }

    @Override
    @CallSuper
    public void onAttachedToLayoutParams(@NonNull CoordinatorLayout.LayoutParams lp) {
        if (lp.dodgeInsetEdges == 0) {
            lp.dodgeInsetEdges = 80;
        }
    }

    @Override
    @NonNull
    protected AnimatorSet onCreateExpandedStateChangeAnimation(final @NonNull View dependency, final @NonNull View child, final boolean expanded, boolean isAnimating) {
        FabTransformationSpec spec = this.onCreateMotionSpec(child.getContext(), expanded);
        if (expanded) {
            this.dependencyOriginalTranslationX = dependency.getTranslationX();
            this.dependencyOriginalTranslationY = dependency.getTranslationY();
        }
        ArrayList<Animator> animations = new ArrayList<Animator>();
        ArrayList<Animator.AnimatorListener> listeners = new ArrayList<Animator.AnimatorListener>();
        if (Build.VERSION.SDK_INT >= 21) {
            this.createElevationAnimation(dependency, child, expanded, isAnimating, spec, animations, listeners);
        }
        RectF childBounds = this.tmpRectF1;
        this.createTranslationAnimation(dependency, child, expanded, isAnimating, spec, animations, listeners, childBounds);
        float childWidth = childBounds.width();
        float childHeight = childBounds.height();
        this.createDependencyTranslationAnimation(dependency, child, expanded, spec, animations);
        this.createIconFadeAnimation(dependency, child, expanded, isAnimating, spec, animations, listeners);
        this.createExpansionAnimation(dependency, child, expanded, isAnimating, spec, childWidth, childHeight, animations, listeners);
        this.createColorAnimation(dependency, child, expanded, isAnimating, spec, animations, listeners);
        this.createChildrenFadeAnimation(dependency, child, expanded, isAnimating, spec, animations, listeners);
        AnimatorSet set = new AnimatorSet();
        AnimatorSetCompat.playTogether(set, animations);
        set.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animation) {
                if (expanded) {
                    child.setVisibility(0);
                    dependency.setAlpha(0.0f);
                    dependency.setVisibility(4);
                }
            }

            public void onAnimationEnd(Animator animation) {
                if (!expanded) {
                    child.setVisibility(4);
                    dependency.setAlpha(1.0f);
                    dependency.setVisibility(0);
                }
            }
        });
        int count2 = listeners.size();
        for (int i = 0; i < count2; ++i) {
            set.addListener((Animator.AnimatorListener)listeners.get(i));
        }
        return set;
    }

    protected abstract FabTransformationSpec onCreateMotionSpec(Context var1, boolean var2);

    @TargetApi(value=21)
    private void createElevationAnimation(View dependency, @NonNull View child, boolean expanded, boolean currentlyAnimating, @NonNull FabTransformationSpec spec, @NonNull List<Animator> animations, List<Animator.AnimatorListener> unusedListeners) {
        ObjectAnimator animator2;
        float translationZ = ViewCompat.getElevation(child) - ViewCompat.getElevation(dependency);
        if (expanded) {
            if (!currentlyAnimating) {
                child.setTranslationZ(-translationZ);
            }
            animator2 = ObjectAnimator.ofFloat((Object)child, (Property)View.TRANSLATION_Z, (float[])new float[]{0.0f});
        } else {
            animator2 = ObjectAnimator.ofFloat((Object)child, (Property)View.TRANSLATION_Z, (float[])new float[]{-translationZ});
        }
        MotionTiming timing = spec.timings.getTiming("elevation");
        timing.apply((Animator)animator2);
        animations.add((Animator)animator2);
    }

    private void createDependencyTranslationAnimation(@NonNull View dependency, @NonNull View child, boolean expanded, @NonNull FabTransformationSpec spec, @NonNull List<Animator> animations) {
        float translationX = this.calculateTranslationX(dependency, child, spec.positioning);
        float translationY = this.calculateTranslationY(dependency, child, spec.positioning);
        Pair<MotionTiming, MotionTiming> motionTiming = this.calculateMotionTiming(translationX, translationY, expanded, spec);
        MotionTiming translationXTiming = (MotionTiming)motionTiming.first;
        MotionTiming translationYTiming = (MotionTiming)motionTiming.second;
        ObjectAnimator translationXAnimator = ObjectAnimator.ofFloat((Object)dependency, (Property)View.TRANSLATION_X, (float[])new float[]{expanded ? translationX : this.dependencyOriginalTranslationX});
        ObjectAnimator translationYAnimator = ObjectAnimator.ofFloat((Object)dependency, (Property)View.TRANSLATION_Y, (float[])new float[]{expanded ? translationY : this.dependencyOriginalTranslationY});
        translationXTiming.apply((Animator)translationXAnimator);
        translationYTiming.apply((Animator)translationYAnimator);
        animations.add((Animator)translationXAnimator);
        animations.add((Animator)translationYAnimator);
    }

    private void createTranslationAnimation(@NonNull View dependency, @NonNull View child, boolean expanded, boolean currentlyAnimating, @NonNull FabTransformationSpec spec, @NonNull List<Animator> animations, List<Animator.AnimatorListener> unusedListeners, @NonNull RectF childBounds) {
        ObjectAnimator translationYAnimator;
        ObjectAnimator translationXAnimator;
        float translationX = this.calculateTranslationX(dependency, child, spec.positioning);
        float translationY = this.calculateTranslationY(dependency, child, spec.positioning);
        Pair<MotionTiming, MotionTiming> motionTiming = this.calculateMotionTiming(translationX, translationY, expanded, spec);
        MotionTiming translationXTiming = (MotionTiming)motionTiming.first;
        MotionTiming translationYTiming = (MotionTiming)motionTiming.second;
        if (expanded) {
            if (!currentlyAnimating) {
                child.setTranslationX(-translationX);
                child.setTranslationY(-translationY);
            }
            translationXAnimator = ObjectAnimator.ofFloat((Object)child, (Property)View.TRANSLATION_X, (float[])new float[]{0.0f});
            translationYAnimator = ObjectAnimator.ofFloat((Object)child, (Property)View.TRANSLATION_Y, (float[])new float[]{0.0f});
            this.calculateChildVisibleBoundsAtEndOfExpansion(child, spec, translationXTiming, translationYTiming, -translationX, -translationY, 0.0f, 0.0f, childBounds);
        } else {
            translationXAnimator = ObjectAnimator.ofFloat((Object)child, (Property)View.TRANSLATION_X, (float[])new float[]{-translationX});
            translationYAnimator = ObjectAnimator.ofFloat((Object)child, (Property)View.TRANSLATION_Y, (float[])new float[]{-translationY});
        }
        translationXTiming.apply((Animator)translationXAnimator);
        translationYTiming.apply((Animator)translationYAnimator);
        animations.add((Animator)translationXAnimator);
        animations.add((Animator)translationYAnimator);
    }

    private void createIconFadeAnimation(View dependency, final View child, boolean expanded, boolean currentlyAnimating, @NonNull FabTransformationSpec spec, @NonNull List<Animator> animations, @NonNull List<Animator.AnimatorListener> listeners) {
        ObjectAnimator animator2;
        if (!(child instanceof CircularRevealWidget) || !(dependency instanceof ImageView)) {
            return;
        }
        final CircularRevealWidget circularRevealChild = (CircularRevealWidget)child;
        ImageView dependencyImageView = (ImageView)dependency;
        final Drawable icon = dependencyImageView.getDrawable();
        if (icon == null) {
            return;
        }
        icon.mutate();
        if (expanded) {
            if (!currentlyAnimating) {
                icon.setAlpha(255);
            }
            animator2 = ObjectAnimator.ofInt((Object)icon, DrawableAlphaProperty.DRAWABLE_ALPHA_COMPAT, (int[])new int[]{0});
        } else {
            animator2 = ObjectAnimator.ofInt((Object)icon, DrawableAlphaProperty.DRAWABLE_ALPHA_COMPAT, (int[])new int[]{255});
        }
        animator2.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                child.invalidate();
            }
        });
        MotionTiming timing = spec.timings.getTiming("iconFade");
        timing.apply((Animator)animator2);
        animations.add((Animator)animator2);
        listeners.add((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animation) {
                circularRevealChild.setCircularRevealOverlayDrawable(icon);
            }

            public void onAnimationEnd(Animator animation) {
                circularRevealChild.setCircularRevealOverlayDrawable(null);
            }
        });
    }

    private void createExpansionAnimation(@NonNull View dependency, View child, boolean expanded, boolean currentlyAnimating, @NonNull FabTransformationSpec spec, float childWidth, float childHeight, @NonNull List<Animator> animations, @NonNull List<Animator.AnimatorListener> listeners) {
        Animator animator2;
        if (!(child instanceof CircularRevealWidget)) {
            return;
        }
        final CircularRevealWidget circularRevealChild = (CircularRevealWidget)child;
        float revealCenterX = this.calculateRevealCenterX(dependency, child, spec.positioning);
        float revealCenterY = this.calculateRevealCenterY(dependency, child, spec.positioning);
        ((FloatingActionButton)dependency).getContentRect(this.tmpRect);
        float dependencyRadius = (float)this.tmpRect.width() / 2.0f;
        MotionTiming timing = spec.timings.getTiming("expansion");
        if (expanded) {
            if (!currentlyAnimating) {
                circularRevealChild.setRevealInfo(new CircularRevealWidget.RevealInfo(revealCenterX, revealCenterY, dependencyRadius));
            }
            float fromRadius = currentlyAnimating ? circularRevealChild.getRevealInfo().radius : dependencyRadius;
            float toRadius = MathUtils.distanceToFurthestCorner(revealCenterX, revealCenterY, 0.0f, 0.0f, childWidth, childHeight);
            animator2 = CircularRevealCompat.createCircularReveal(circularRevealChild, revealCenterX, revealCenterY, toRadius);
            animator2.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator animation) {
                    CircularRevealWidget.RevealInfo revealInfo = circularRevealChild.getRevealInfo();
                    revealInfo.radius = Float.MAX_VALUE;
                    circularRevealChild.setRevealInfo(revealInfo);
                }
            });
            this.createPreFillRadialExpansion(child, timing.getDelay(), (int)revealCenterX, (int)revealCenterY, fromRadius, animations);
        } else {
            float fromRadius = circularRevealChild.getRevealInfo().radius;
            float toRadius = dependencyRadius;
            animator2 = CircularRevealCompat.createCircularReveal(circularRevealChild, revealCenterX, revealCenterY, toRadius);
            this.createPreFillRadialExpansion(child, timing.getDelay(), (int)revealCenterX, (int)revealCenterY, fromRadius, animations);
            this.createPostFillRadialExpansion(child, timing.getDelay(), timing.getDuration(), spec.timings.getTotalDuration(), (int)revealCenterX, (int)revealCenterY, toRadius, animations);
        }
        timing.apply(animator2);
        animations.add(animator2);
        listeners.add(CircularRevealCompat.createCircularRevealListener(circularRevealChild));
    }

    private void createColorAnimation(@NonNull View dependency, View child, boolean expanded, boolean currentlyAnimating, @NonNull FabTransformationSpec spec, @NonNull List<Animator> animations, List<Animator.AnimatorListener> unusedListeners) {
        ObjectAnimator animator2;
        if (!(child instanceof CircularRevealWidget)) {
            return;
        }
        CircularRevealWidget circularRevealChild = (CircularRevealWidget)child;
        int tint = this.getBackgroundTint(dependency);
        int transparent = tint & 0xFFFFFF;
        if (expanded) {
            if (!currentlyAnimating) {
                circularRevealChild.setCircularRevealScrimColor(tint);
            }
            animator2 = ObjectAnimator.ofInt((Object)circularRevealChild, CircularRevealWidget.CircularRevealScrimColorProperty.CIRCULAR_REVEAL_SCRIM_COLOR, (int[])new int[]{transparent});
        } else {
            animator2 = ObjectAnimator.ofInt((Object)circularRevealChild, CircularRevealWidget.CircularRevealScrimColorProperty.CIRCULAR_REVEAL_SCRIM_COLOR, (int[])new int[]{tint});
        }
        animator2.setEvaluator((TypeEvaluator)ArgbEvaluatorCompat.getInstance());
        MotionTiming timing = spec.timings.getTiming("color");
        timing.apply((Animator)animator2);
        animations.add((Animator)animator2);
    }

    private void createChildrenFadeAnimation(View unusedDependency, View child, boolean expanded, boolean currentlyAnimating, @NonNull FabTransformationSpec spec, @NonNull List<Animator> animations, List<Animator.AnimatorListener> unusedListeners) {
        ObjectAnimator animator2;
        if (!(child instanceof ViewGroup)) {
            return;
        }
        if (child instanceof CircularRevealWidget && CircularRevealHelper.STRATEGY == 0) {
            return;
        }
        ViewGroup childContentContainer = this.calculateChildContentContainer(child);
        if (childContentContainer == null) {
            return;
        }
        if (expanded) {
            if (!currentlyAnimating) {
                ChildrenAlphaProperty.CHILDREN_ALPHA.set((Object)childContentContainer, (Object)Float.valueOf(0.0f));
            }
            animator2 = ObjectAnimator.ofFloat((Object)childContentContainer, ChildrenAlphaProperty.CHILDREN_ALPHA, (float[])new float[]{1.0f});
        } else {
            animator2 = ObjectAnimator.ofFloat((Object)childContentContainer, ChildrenAlphaProperty.CHILDREN_ALPHA, (float[])new float[]{0.0f});
        }
        MotionTiming timing = spec.timings.getTiming("contentFade");
        timing.apply((Animator)animator2);
        animations.add((Animator)animator2);
    }

    @NonNull
    private Pair<MotionTiming, MotionTiming> calculateMotionTiming(float translationX, float translationY, boolean expanded, @NonNull FabTransformationSpec spec) {
        MotionTiming translationYTiming;
        MotionTiming translationXTiming;
        if (translationX == 0.0f || translationY == 0.0f) {
            translationXTiming = spec.timings.getTiming("translationXLinear");
            translationYTiming = spec.timings.getTiming("translationYLinear");
        } else if (expanded && translationY < 0.0f || !expanded && translationY > 0.0f) {
            translationXTiming = spec.timings.getTiming("translationXCurveUpwards");
            translationYTiming = spec.timings.getTiming("translationYCurveUpwards");
        } else {
            translationXTiming = spec.timings.getTiming("translationXCurveDownwards");
            translationYTiming = spec.timings.getTiming("translationYCurveDownwards");
        }
        return new Pair((Object)translationXTiming, (Object)translationYTiming);
    }

    private float calculateTranslationX(@NonNull View dependency, @NonNull View child, @NonNull Positioning positioning) {
        RectF dependencyBounds = this.tmpRectF1;
        RectF childBounds = this.tmpRectF2;
        this.calculateDependencyWindowBounds(dependency, dependencyBounds);
        this.calculateWindowBounds(child, childBounds);
        float translationX = 0.0f;
        switch (positioning.gravity & 7) {
            case 3: {
                translationX = childBounds.left - dependencyBounds.left;
                break;
            }
            case 1: {
                translationX = childBounds.centerX() - dependencyBounds.centerX();
                break;
            }
            case 5: {
                translationX = childBounds.right - dependencyBounds.right;
                break;
            }
        }
        return translationX += positioning.xAdjustment;
    }

    private float calculateTranslationY(@NonNull View dependency, @NonNull View child, @NonNull Positioning positioning) {
        RectF dependencyBounds = this.tmpRectF1;
        RectF childBounds = this.tmpRectF2;
        this.calculateDependencyWindowBounds(dependency, dependencyBounds);
        this.calculateWindowBounds(child, childBounds);
        float translationY = 0.0f;
        switch (positioning.gravity & 0x70) {
            case 48: {
                translationY = childBounds.top - dependencyBounds.top;
                break;
            }
            case 16: {
                translationY = childBounds.centerY() - dependencyBounds.centerY();
                break;
            }
            case 80: {
                translationY = childBounds.bottom - dependencyBounds.bottom;
                break;
            }
        }
        return translationY += positioning.yAdjustment;
    }

    private void calculateWindowBounds(@NonNull View view, RectF rect) {
        RectF windowBounds = rect;
        windowBounds.set(0.0f, 0.0f, (float)view.getWidth(), (float)view.getHeight());
        int[] windowLocation = this.tmpArray;
        view.getLocationInWindow(windowLocation);
        windowBounds.offsetTo((float)windowLocation[0], (float)windowLocation[1]);
        windowBounds.offset((float)((int)(-view.getTranslationX())), (float)((int)(-view.getTranslationY())));
    }

    private void calculateDependencyWindowBounds(@NonNull View view, @NonNull RectF rect) {
        this.calculateWindowBounds(view, rect);
        rect.offset(this.dependencyOriginalTranslationX, this.dependencyOriginalTranslationY);
    }

    private float calculateRevealCenterX(@NonNull View dependency, @NonNull View child, @NonNull Positioning positioning) {
        RectF dependencyBounds = this.tmpRectF1;
        RectF childBounds = this.tmpRectF2;
        this.calculateDependencyWindowBounds(dependency, dependencyBounds);
        this.calculateWindowBounds(child, childBounds);
        float translationX = this.calculateTranslationX(dependency, child, positioning);
        childBounds.offset(-translationX, 0.0f);
        return dependencyBounds.centerX() - childBounds.left;
    }

    private float calculateRevealCenterY(@NonNull View dependency, @NonNull View child, @NonNull Positioning positioning) {
        RectF dependencyBounds = this.tmpRectF1;
        RectF childBounds = this.tmpRectF2;
        this.calculateDependencyWindowBounds(dependency, dependencyBounds);
        this.calculateWindowBounds(child, childBounds);
        float translationY = this.calculateTranslationY(dependency, child, positioning);
        childBounds.offset(0.0f, -translationY);
        return dependencyBounds.centerY() - childBounds.top;
    }

    private void calculateChildVisibleBoundsAtEndOfExpansion(@NonNull View child, @NonNull FabTransformationSpec spec, @NonNull MotionTiming translationXTiming, @NonNull MotionTiming translationYTiming, float fromX, float fromY, float toX, float toY, @NonNull RectF childBounds) {
        float translationX = this.calculateValueOfAnimationAtEndOfExpansion(spec, translationXTiming, fromX, toX);
        float translationY = this.calculateValueOfAnimationAtEndOfExpansion(spec, translationYTiming, fromY, toY);
        Rect window = this.tmpRect;
        child.getWindowVisibleDisplayFrame(window);
        RectF windowF = this.tmpRectF1;
        windowF.set(window);
        RectF childVisibleBounds = this.tmpRectF2;
        this.calculateWindowBounds(child, childVisibleBounds);
        childVisibleBounds.offset(translationX, translationY);
        childVisibleBounds.intersect(windowF);
        childBounds.set(childVisibleBounds);
    }

    private float calculateValueOfAnimationAtEndOfExpansion(@NonNull FabTransformationSpec spec, @NonNull MotionTiming timing, float from, float to) {
        long delay = timing.getDelay();
        long duration = timing.getDuration();
        MotionTiming expansionTiming = spec.timings.getTiming("expansion");
        long expansionEnd = expansionTiming.getDelay() + expansionTiming.getDuration();
        float fraction = (float)((expansionEnd += 17L) - delay) / (float)duration;
        fraction = timing.getInterpolator().getInterpolation(fraction);
        return AnimationUtils.lerp(from, to, fraction);
    }

    @Nullable
    private ViewGroup calculateChildContentContainer(@NonNull View view) {
        View childContentContainer = view.findViewById(R.id.mtrl_child_content_container);
        if (childContentContainer != null) {
            return this.toViewGroupOrNull(childContentContainer);
        }
        if (view instanceof TransformationChildLayout || view instanceof TransformationChildCard) {
            childContentContainer = ((ViewGroup)view).getChildAt(0);
            return this.toViewGroupOrNull(childContentContainer);
        }
        return this.toViewGroupOrNull(view);
    }

    @Nullable
    private ViewGroup toViewGroupOrNull(View view) {
        if (view instanceof ViewGroup) {
            return (ViewGroup)view;
        }
        return null;
    }

    private int getBackgroundTint(@NonNull View view) {
        ColorStateList tintList = ViewCompat.getBackgroundTintList(view);
        if (tintList != null) {
            return tintList.getColorForState(view.getDrawableState(), tintList.getDefaultColor());
        }
        return 0;
    }

    private void createPreFillRadialExpansion(View child, long delay, int revealCenterX, int revealCenterY, float fromRadius, @NonNull List<Animator> animations) {
        if (Build.VERSION.SDK_INT >= 21 && delay > 0L) {
            Animator animator2 = ViewAnimationUtils.createCircularReveal((View)child, (int)revealCenterX, (int)revealCenterY, (float)fromRadius, (float)fromRadius);
            animator2.setStartDelay(0L);
            animator2.setDuration(delay);
            animations.add(animator2);
        }
    }

    private void createPostFillRadialExpansion(View child, long delay, long duration, long totalDuration, int revealCenterX, int revealCenterY, float toRadius, @NonNull List<Animator> animations) {
        if (Build.VERSION.SDK_INT >= 21 && delay + duration < totalDuration) {
            Animator animator2 = ViewAnimationUtils.createCircularReveal((View)child, (int)revealCenterX, (int)revealCenterY, (float)toRadius, (float)toRadius);
            animator2.setStartDelay(delay + duration);
            animator2.setDuration(totalDuration - (delay + duration));
            animations.add(animator2);
        }
    }

    protected static class FabTransformationSpec {
        @Nullable
        public MotionSpec timings;
        public Positioning positioning;

        protected FabTransformationSpec() {
        }
    }
}

