/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.transition.platform;

import android.animation.TimeInterpolator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.LinearGradient;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Shader;
import android.os.Build;
import android.transition.PathMotion;
import android.transition.PatternPathMotion;
import android.transition.Transition;
import android.transition.TransitionSet;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewParent;
import androidx.annotation.AttrRes;
import androidx.annotation.ColorInt;
import androidx.annotation.FloatRange;
import androidx.annotation.IdRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.core.graphics.PathParser;
import com.google.android.material.canvas.CanvasCompat;
import com.google.android.material.motion.MotionUtils;
import com.google.android.material.shape.AbsoluteCornerSize;
import com.google.android.material.shape.CornerSize;
import com.google.android.material.shape.RelativeCornerSize;
import com.google.android.material.shape.ShapeAppearanceModel;
import com.google.android.material.transition.platform.MaterialArcMotion;

@RequiresApi(value=21)
class TransitionUtils {
    static final int NO_DURATION = -1;
    @AttrRes
    static final int NO_ATTR_RES_ID = 0;
    private static final int PATH_TYPE_LINEAR = 0;
    private static final int PATH_TYPE_ARC = 1;
    private static final RectF transformAlphaRectF = new RectF();

    private TransitionUtils() {
    }

    static boolean maybeApplyThemeInterpolator(Transition transition, Context context, @AttrRes int attrResId, TimeInterpolator defaultInterpolator) {
        if (attrResId != 0 && transition.getInterpolator() == null) {
            TimeInterpolator interpolator2 = MotionUtils.resolveThemeInterpolator(context, attrResId, defaultInterpolator);
            transition.setInterpolator(interpolator2);
            return true;
        }
        return false;
    }

    static boolean maybeApplyThemeDuration(Transition transition, Context context, @AttrRes int attrResId) {
        int duration;
        if (attrResId != 0 && transition.getDuration() == -1L && (duration = MotionUtils.resolveThemeDuration(context, attrResId, -1)) != -1) {
            transition.setDuration((long)duration);
            return true;
        }
        return false;
    }

    static boolean maybeApplyThemePath(Transition transition, Context context, @AttrRes int attrResId) {
        PathMotion pathMotion;
        if (attrResId != 0 && (pathMotion = TransitionUtils.resolveThemePath(context, attrResId)) != null) {
            transition.setPathMotion(pathMotion);
            return true;
        }
        return false;
    }

    @Nullable
    static PathMotion resolveThemePath(Context context, @AttrRes int attrResId) {
        TypedValue pathValue = new TypedValue();
        if (context.getTheme().resolveAttribute(attrResId, pathValue, true)) {
            if (pathValue.type == 16) {
                int pathInt = pathValue.data;
                if (pathInt == 0) {
                    return null;
                }
                if (pathInt == 1) {
                    return new MaterialArcMotion();
                }
                throw new IllegalArgumentException("Invalid motion path type: " + pathInt);
            }
            if (pathValue.type == 3) {
                String pathString = String.valueOf(pathValue.string);
                return new PatternPathMotion(PathParser.createPathFromPathData(pathString));
            }
            throw new IllegalArgumentException("Motion path theme attribute must either be an enum value or path data string");
        }
        return null;
    }

    static ShapeAppearanceModel convertToRelativeCornerSizes(ShapeAppearanceModel shapeAppearanceModel, RectF bounds) {
        return shapeAppearanceModel.withTransformedCornerSizes(cornerSize -> RelativeCornerSize.createFromCornerSize(bounds, cornerSize));
    }

    static ShapeAppearanceModel transformCornerSizes(ShapeAppearanceModel shapeAppearanceModel1, ShapeAppearanceModel shapeAppearanceModel2, RectF shapeAppearanceModel1Bounds, CornerSizeBinaryOperator op) {
        ShapeAppearanceModel shapeAppearanceModel = TransitionUtils.isShapeAppearanceSignificant(shapeAppearanceModel1, shapeAppearanceModel1Bounds) ? shapeAppearanceModel1 : shapeAppearanceModel2;
        return shapeAppearanceModel.toBuilder().setTopLeftCornerSize(op.apply(shapeAppearanceModel1.getTopLeftCornerSize(), shapeAppearanceModel2.getTopLeftCornerSize())).setTopRightCornerSize(op.apply(shapeAppearanceModel1.getTopRightCornerSize(), shapeAppearanceModel2.getTopRightCornerSize())).setBottomLeftCornerSize(op.apply(shapeAppearanceModel1.getBottomLeftCornerSize(), shapeAppearanceModel2.getBottomLeftCornerSize())).setBottomRightCornerSize(op.apply(shapeAppearanceModel1.getBottomRightCornerSize(), shapeAppearanceModel2.getBottomRightCornerSize())).build();
    }

    private static boolean isShapeAppearanceSignificant(ShapeAppearanceModel shapeAppearanceModel, RectF bounds) {
        return shapeAppearanceModel.getTopLeftCornerSize().getCornerSize(bounds) != 0.0f || shapeAppearanceModel.getTopRightCornerSize().getCornerSize(bounds) != 0.0f || shapeAppearanceModel.getBottomRightCornerSize().getCornerSize(bounds) != 0.0f || shapeAppearanceModel.getBottomLeftCornerSize().getCornerSize(bounds) != 0.0f;
    }

    static float lerp(float startValue, float endValue, float fraction) {
        return startValue + fraction * (endValue - startValue);
    }

    static float lerp(float startValue, float endValue, @FloatRange(from=0.0, to=1.0) float startFraction, @FloatRange(from=0.0, to=1.0) float endFraction, @FloatRange(from=0.0, to=1.0) float fraction) {
        return TransitionUtils.lerp(startValue, endValue, startFraction, endFraction, fraction, false);
    }

    static float lerp(float startValue, float endValue, @FloatRange(from=0.0, to=1.0) float startFraction, @FloatRange(from=0.0, to=1.0) float endFraction, @FloatRange(from=0.0) float fraction, boolean allowOvershoot) {
        if (allowOvershoot && (fraction < 0.0f || fraction > 1.0f)) {
            return TransitionUtils.lerp(startValue, endValue, fraction);
        }
        if (fraction < startFraction) {
            return startValue;
        }
        if (fraction > endFraction) {
            return endValue;
        }
        return TransitionUtils.lerp(startValue, endValue, (fraction - startFraction) / (endFraction - startFraction));
    }

    static int lerp(int startValue, int endValue, @FloatRange(from=0.0, to=1.0) float startFraction, @FloatRange(from=0.0, to=1.0) float endFraction, @FloatRange(from=0.0, to=1.0) float fraction) {
        if (fraction < startFraction) {
            return startValue;
        }
        if (fraction > endFraction) {
            return endValue;
        }
        return (int)TransitionUtils.lerp(startValue, endValue, (fraction - startFraction) / (endFraction - startFraction));
    }

    static ShapeAppearanceModel lerp(ShapeAppearanceModel startValue, ShapeAppearanceModel endValue, final RectF startBounds, final RectF endBounds, final @FloatRange(from=0.0, to=1.0) float startFraction, final @FloatRange(from=0.0, to=1.0) float endFraction, final @FloatRange(from=0.0, to=1.0) float fraction) {
        if (fraction < startFraction) {
            return startValue;
        }
        if (fraction > endFraction) {
            return endValue;
        }
        return TransitionUtils.transformCornerSizes(startValue, endValue, startBounds, new CornerSizeBinaryOperator(){

            @Override
            @NonNull
            public CornerSize apply(@NonNull CornerSize cornerSize1, @NonNull CornerSize cornerSize2) {
                float startCornerSize = cornerSize1.getCornerSize(startBounds);
                float endCornerSize = cornerSize2.getCornerSize(endBounds);
                float cornerSize = TransitionUtils.lerp(startCornerSize, endCornerSize, startFraction, endFraction, fraction);
                return new AbsoluteCornerSize(cornerSize);
            }
        });
    }

    static Shader createColorShader(@ColorInt int color2) {
        return new LinearGradient(0.0f, 0.0f, 0.0f, 0.0f, color2, color2, Shader.TileMode.CLAMP);
    }

    static View findDescendantOrAncestorById(View view, @IdRes int viewId) {
        View descendant = view.findViewById(viewId);
        if (descendant != null) {
            return descendant;
        }
        return TransitionUtils.findAncestorById(view, viewId);
    }

    static View findAncestorById(View view, @IdRes int ancestorId) {
        String resourceName = view.getResources().getResourceName(ancestorId);
        while (view != null) {
            if (view.getId() == ancestorId) {
                return view;
            }
            ViewParent parent = view.getParent();
            if (!(parent instanceof View)) break;
            view = (View)parent;
        }
        throw new IllegalArgumentException(resourceName + " is not a valid ancestor");
    }

    static RectF getRelativeBounds(View view) {
        return new RectF((float)view.getLeft(), (float)view.getTop(), (float)view.getRight(), (float)view.getBottom());
    }

    static Rect getRelativeBoundsRect(View view) {
        return new Rect(view.getLeft(), view.getTop(), view.getRight(), view.getBottom());
    }

    static RectF getLocationOnScreen(View view) {
        int[] location = new int[2];
        view.getLocationOnScreen(location);
        int left = location[0];
        int top = location[1];
        int right = left + view.getWidth();
        int bottom = top + view.getHeight();
        return new RectF((float)left, (float)top, (float)right, (float)bottom);
    }

    @NonNull
    static <T> T defaultIfNull(@Nullable T value, @NonNull T defaultValue) {
        return value != null ? value : defaultValue;
    }

    static float calculateArea(@NonNull RectF bounds) {
        return bounds.width() * bounds.height();
    }

    private static int saveLayerAlphaCompat(Canvas canvas, Rect bounds, int alpha) {
        transformAlphaRectF.set(bounds);
        if (Build.VERSION.SDK_INT >= 21) {
            return canvas.saveLayerAlpha(transformAlphaRectF, alpha);
        }
        return canvas.saveLayerAlpha(TransitionUtils.transformAlphaRectF.left, TransitionUtils.transformAlphaRectF.top, TransitionUtils.transformAlphaRectF.right, TransitionUtils.transformAlphaRectF.bottom, alpha, 31);
    }

    static void transform(Canvas canvas, Rect bounds, float dx, float dy, float scale, int alpha, CanvasCompat.CanvasOperation op) {
        if (alpha <= 0) {
            return;
        }
        int checkpoint = canvas.save();
        canvas.translate(dx, dy);
        canvas.scale(scale, scale);
        if (alpha < 255) {
            TransitionUtils.saveLayerAlphaCompat(canvas, bounds, alpha);
        }
        op.run(canvas);
        canvas.restoreToCount(checkpoint);
    }

    static void maybeAddTransition(TransitionSet transitionSet, @Nullable Transition transition) {
        if (transition != null) {
            transitionSet.addTransition(transition);
        }
    }

    static void maybeRemoveTransition(TransitionSet transitionSet, @Nullable Transition transition) {
        if (transition != null) {
            transitionSet.removeTransition(transition);
        }
    }

    static interface CornerSizeBinaryOperator {
        @NonNull
        public CornerSize apply(@NonNull CornerSize var1, @NonNull CornerSize var2);
    }
}

