/*
 * Decompiled with CFR 0.152.
 */
package com.inputstick.api;

import com.inputstick.api.InputStickDataListener;
import com.inputstick.api.InputStickStateListener;
import com.inputstick.api.Packet;
import java.util.ArrayList;
import java.util.Vector;

public abstract class ConnectionManager {
    public static final int STATE_DISCONNECTED = 0;
    public static final int STATE_FAILURE = 1;
    public static final int STATE_CONNECTING = 2;
    public static final int STATE_CONNECTED = 3;
    public static final int STATE_READY = 4;
    public static final int DISC_REASON_UNKNOWN = 0;
    public static final int DISC_REASON_ERROR = 1;
    public static final int DISC_REASON_APP_DISCONNECTED = 16;
    public static final int DISC_REASON_UTILITY_DISCONNECTED = 33;
    public static final int DISC_REASON_UTILITY_CANCELLED = 34;
    public static final int DISC_REASON_UTILITY_FORCED = 35;
    protected Vector<InputStickStateListener> mStateListeners = new Vector();
    protected Vector<InputStickDataListener> mDataListeners = new Vector();
    protected int mState;
    private int mErrorCode;
    private int mDisconnectReasonCode;

    public abstract void connect();

    public abstract void disconnect();

    public abstract void sendPacket(Packet var1);

    protected void stateNotify(int state) {
        this.stateNotify(state, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stateNotify(int state, boolean forceNotification) {
        if (forceNotification || this.mState != state) {
            this.mState = state;
            Vector<InputStickStateListener> vector = this.mStateListeners;
            synchronized (vector) {
                ArrayList<InputStickStateListener> tmp = new ArrayList<InputStickStateListener>();
                for (InputStickStateListener listener2 : this.mStateListeners) {
                    tmp.add(listener2);
                }
                for (InputStickStateListener listener2 : tmp) {
                    listener2.onStateChanged(state);
                }
            }
        }
    }

    public int getState() {
        return this.mState;
    }

    public boolean isReady() {
        return this.mState == 4;
    }

    public boolean isConnected() {
        return this.mState == 4 || this.mState == 3;
    }

    protected void resetErrorCode() {
        this.mErrorCode = 0;
        this.setDisconnectReason(0);
    }

    protected void setErrorCode(int code) {
        if (code != 0) {
            this.setDisconnectReason(1);
        }
        this.mErrorCode = code;
    }

    public int getErrorCode() {
        return this.mErrorCode;
    }

    protected void setDisconnectReason(int code) {
        this.mDisconnectReasonCode = code;
    }

    public int getDisconnectReason() {
        return this.mDisconnectReasonCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onData(byte[] data) {
        Vector<InputStickDataListener> vector = this.mDataListeners;
        synchronized (vector) {
            ArrayList<InputStickDataListener> tmp = new ArrayList<InputStickDataListener>();
            for (InputStickDataListener listener2 : this.mDataListeners) {
                tmp.add(listener2);
            }
            for (InputStickDataListener listener2 : tmp) {
                listener2.onInputStickData(data);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStateListener(InputStickStateListener listener2) {
        if (listener2 != null) {
            Vector<InputStickStateListener> vector = this.mStateListeners;
            synchronized (vector) {
                if (!this.mStateListeners.contains(listener2)) {
                    this.mStateListeners.add(listener2);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeStateListener(InputStickStateListener listener2) {
        if (listener2 != null) {
            Vector<InputStickStateListener> vector = this.mStateListeners;
            synchronized (vector) {
                this.mStateListeners.remove(listener2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDataListener(InputStickDataListener listener2) {
        if (listener2 != null) {
            Vector<InputStickDataListener> vector = this.mDataListeners;
            synchronized (vector) {
                if (!this.mDataListeners.contains(listener2)) {
                    this.mDataListeners.add(listener2);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDataListener(InputStickDataListener listener2) {
        if (listener2 != null) {
            Vector<InputStickDataListener> vector = this.mDataListeners;
            synchronized (vector) {
                this.mDataListeners.remove(listener2);
            }
        }
    }
}

