/*
 * Decompiled with CFR 0.152.
 */
package com.inputstick.api;

import android.util.SparseArray;

public class InputStickError {
    public static String ERROR_UNKNOWN_MSG = "Unknown";
    public static final int ERROR_NONE = 0;
    public static final int ERROR_UNKNOWN = 1;
    public static final int ERROR_BLUETOOTH = 256;
    public static final int ERROR_BLUETOOTH_CONNECTION_FAILED = 257;
    public static final int ERROR_BLUETOOTH_CONNECTION_LOST = 258;
    public static final int ERROR_BLUETOOTH_NOT_SUPPORTED = 259;
    public static final int ERROR_BLUETOOTH_INVALID_MAC = 260;
    public static final int ERROR_BLUETOOTH_ECHO_TIMEDOUT = 261;
    public static final int ERROR_BLUETOOTH_NO_REMOTE_DEVICE = 262;
    public static final int ERROR_BLUETOOTH_BT40_NOT_SUPPRTED = 263;
    public static final int ERROR_BLUETOOTH_BT40_NO_SPP_SERVICE = 264;
    public static final int ERROR_BLUETOOTH_NOT_ENABLED = 265;
    public static final int ERROR_HARDWARE = 512;
    public static final int ERROR_HARDWARE_WDG_RESET = 513;
    public static final int ERROR_PACKET = 768;
    public static final int ERROR_PACKET_INVALID_CRC = 769;
    public static final int ERROR_PACKET_INVALID_LENGTH = 770;
    public static final int ERROR_PACKET_INVALID_HEADER = 771;
    public static final int ERROR_INIT = 1024;
    public static final int ERROR_INIT_UNSUPPORTED_CMD = 1025;
    public static final int ERROR_INIT_TIMEDOUT = 1026;
    public static final int ERROR_INIT_FW_TYPE_NOT_SUPPORTED = 1027;
    public static final int ERROR_INIT_FW_VERSION_NOT_SUPPORTED = 1028;
    public static final int ERROR_SECURITY = 1280;
    public static final int ERROR_SECURITY_NOT_SUPPORTED = 1281;
    public static final int ERROR_SECURITY_NO_KEY = 1282;
    public static final int ERROR_SECURITY_INVALID_KEY = 1283;
    public static final int ERROR_SECURITY_CHALLENGE = 1284;
    public static final int ERROR_SECURITY_NOT_PROTECTED = 1285;
    public static final int ERROR_ANDROID = 4096;
    public static final int ERROR_ANDROID_NO_UTILITY_APP = 4097;
    public static final int ERROR_ANDROID_SERVICE_DISCONNECTED = 4098;
    public static final int ERROR_ANDROID_UTIL_FORCE_DISC = 4099;
    public static final int ERROR_ANDROID_UTIL_IDLE_DISC = 4100;
    private static final SparseArray<String> errorCodeMap = new SparseArray();

    public static String getErrorType(int errorCode) {
        String result2 = (String)errorCodeMap.get(errorCode &= 0xFF00);
        if (result2 != null) {
            return result2;
        }
        return ERROR_UNKNOWN_MSG;
    }

    public static String getErrorMessage(int errorCode) {
        if (errorCode == 0) {
            return (String)errorCodeMap.get(0);
        }
        if ((errorCode & 0xFF) == 0) {
            return ERROR_UNKNOWN_MSG;
        }
        String result2 = (String)errorCodeMap.get(errorCode);
        if (result2 != null) {
            return result2;
        }
        return ERROR_UNKNOWN_MSG;
    }

    public static String getFullErrorMessage(int errorCode) {
        return InputStickError.getErrorType(errorCode) + " - " + InputStickError.getErrorMessage(errorCode);
    }

    static {
        errorCodeMap.put(0, (Object)"None");
        errorCodeMap.put(1, (Object)"Unknown");
        errorCodeMap.put(256, (Object)"Bluetooth");
        errorCodeMap.put(257, (Object)"Failed to connect");
        errorCodeMap.put(258, (Object)"Connection lost");
        errorCodeMap.put(259, (Object)"Not supported");
        errorCodeMap.put(260, (Object)"Invalid MAC");
        errorCodeMap.put(261, (Object)"Echo timedout");
        errorCodeMap.put(262, (Object)"Can't find remote device");
        errorCodeMap.put(263, (Object)"BT 4.0 is not supported");
        errorCodeMap.put(264, (Object)"BT 4.0 RXTX not found");
        errorCodeMap.put(265, (Object)"BT not enabled");
        errorCodeMap.put(512, (Object)"Hardware");
        errorCodeMap.put(513, (Object)"WDG reset");
        errorCodeMap.put(768, (Object)"Invalid packet");
        errorCodeMap.put(769, (Object)"Invalid CRC");
        errorCodeMap.put(770, (Object)"Invalid length");
        errorCodeMap.put(771, (Object)"Invalid header");
        errorCodeMap.put(1024, (Object)"Init");
        errorCodeMap.put(1025, (Object)"Command not supported");
        errorCodeMap.put(1026, (Object)"Timedout");
        errorCodeMap.put(1027, (Object)"FW type not supported");
        errorCodeMap.put(1028, (Object)"FW version not supported");
        errorCodeMap.put(1280, (Object)"Security");
        errorCodeMap.put(1281, (Object)"Not supported");
        errorCodeMap.put(1282, (Object)"No key provided");
        errorCodeMap.put(1283, (Object)"Invalid key");
        errorCodeMap.put(1284, (Object)"Challenge failed");
        errorCodeMap.put(1285, (Object)"Key was provided, but device is not password protected");
        errorCodeMap.put(4096, (Object)"Android");
        errorCodeMap.put(4097, (Object)"InputStickUtility app not installed");
        errorCodeMap.put(4098, (Object)"Service connection lost");
        errorCodeMap.put(4099, (Object)"Connection closed by InputStickUtility");
        errorCodeMap.put(4100, (Object)"Connection closed due to inactivity");
    }
}

