/*
 * Decompiled with CFR 0.152.
 */
package com.inputstick.api;

import com.inputstick.api.Util;

public class Packet {
    public static final byte NONE = 0;
    public static final byte START_TAG = 85;
    public static final byte FLAG_RESPOND = -128;
    public static final byte FLAG_ENCRYPTED = 64;
    public static final byte FLAG_HMAC = 32;
    public static final int MAX_SUBPACKETS = 17;
    public static final int MAX_TOTAL_LENGTH = 272;
    public static final int MAX_PAYLOAD_LENGTH = 268;
    public static final byte CMD_IDENTIFY = 1;
    public static final byte CMD_LED = 2;
    public static final byte CMD_RUN_BL = 3;
    public static final byte CMD_RUN_FW = 4;
    public static final byte CMD_GET_INFO = 5;
    public static final byte CMD_BL_ERASE = 6;
    public static final byte CMD_ADD_DATA = 7;
    public static final byte CMD_BL_WRITE = 8;
    public static final byte CMD_FW_INFO = 16;
    public static final byte CMD_INIT = 17;
    public static final byte CMD_INIT_AUTH = 18;
    public static final byte CMD_INIT_CON = 19;
    public static final byte CMD_SET_VALUE = 20;
    public static final byte CMD_RESTORE_DEFAULTS = 21;
    public static final byte CMD_RESTORE_STATUS = 22;
    public static final byte CMD_GET_VALUE = 23;
    public static final byte CMD_SET_PIN = 24;
    public static final byte CMD_USB_RESUME = 25;
    public static final byte CMD_USB_POWER = 26;
    public static final byte CMD_SET_NAME = 28;
    public static final byte CMD_SYSTEM_NOTIFICATION = 31;
    public static final byte CMD_HID_STATUS_REPORT = 32;
    public static final byte CMD_HID_DATA_KEYB = 33;
    public static final byte CMD_HID_DATA_CONSUMER = 34;
    public static final byte CMD_HID_DATA_MOUSE = 35;
    public static final byte CMD_HID_DATA_GAMEPAD = 36;
    public static final byte CMD_HID_DATA_MIXED = 37;
    public static final byte CMD_HID_DATA_TOUCHSCREEN = 38;
    public static final byte CMD_HID_DATA_RAW = 39;
    public static final byte CMD_HID_DATA_ENDP = 43;
    public static final byte CMD_HID_DATA_KEYB_FAST = 44;
    public static final byte CMD_HID_DATA_KEYB_FASTEST = 45;
    public static final byte CMD_HID_STATUS = 47;
    public static final byte CMD_INIT_AUTH_HMAC = 48;
    public static final byte CMD_SET_UPDATE_INTERVAL = 49;
    public static final byte CMD_KEYGEN_GENERATE = 51;
    public static final byte CMD_KEYGEN_TEST = 52;
    public static final byte CMD_KEYGEN_VERIFY = 53;
    public static final byte CMD_DUMMY = -1;
    public static final byte RESP_OK = 1;
    public static final byte RESP_UNKNOWN_CMD = -1;
    public static final byte[] RAW_OLD_BOOTLOADER = new byte[]{85, 0, 2, -125, 0, -38};
    public static final byte[] RAW_DELAY_1_MS = new byte[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
    private byte[] mData;
    private int mPos;
    private boolean mRespond;

    public Packet(boolean respond, byte[] data) {
        this.mRespond = respond;
        this.mData = data;
        this.mPos = data.length;
    }

    public Packet(boolean respond, byte cmd, byte param, byte[] data) {
        this.mRespond = respond;
        this.mData = new byte[272];
        this.mData[0] = cmd;
        this.mData[1] = param;
        this.mPos = 2;
        this.addBytes(data);
    }

    public Packet(boolean respond, byte cmd, byte param) {
        this(respond, cmd, param, null);
    }

    public Packet(boolean respond, byte cmd) {
        this.mRespond = respond;
        this.mData = new byte[272];
        this.mData[0] = cmd;
        this.mPos = 1;
    }

    public void modifyByte(int pos, byte b) {
        this.mData[pos] = b;
    }

    public boolean addBytes(byte[] data) {
        if (data == null) {
            return true;
        }
        if (this.getRemainingFreeSpace() >= data.length) {
            System.arraycopy(data, 0, this.mData, this.mPos, data.length);
            this.mPos += data.length;
            return true;
        }
        return false;
    }

    public boolean addByte(byte b) {
        if (this.getRemainingFreeSpace() >= 1) {
            this.mData[this.mPos++] = b;
            return true;
        }
        return false;
    }

    public boolean addInt16(int val) {
        if (this.getRemainingFreeSpace() >= 2) {
            this.mData[this.mPos + 0] = Util.getMSB(val);
            this.mData[this.mPos + 1] = Util.getLSB(val);
            this.mPos += 2;
            return true;
        }
        return false;
    }

    public boolean addInt32(long val) {
        if (this.getRemainingFreeSpace() >= 4) {
            this.mData[this.mPos + 3] = (byte)val;
            this.mData[this.mPos + 2] = (byte)(val >>= 8);
            this.mData[this.mPos + 1] = (byte)(val >>= 8);
            this.mData[this.mPos + 0] = (byte)(val >>= 8);
            val >>= 8;
            this.mPos += 4;
            return true;
        }
        return false;
    }

    public byte[] getBytes() {
        byte[] result2 = new byte[this.mPos];
        System.arraycopy(this.mData, 0, result2, 0, this.mPos);
        return result2;
    }

    public boolean getRespond() {
        return this.mRespond;
    }

    public int getRemainingFreeSpace() {
        return 272 - this.mPos;
    }

    public void print() {
        Util.printHex(this.mData, "PACKET DATA:");
    }
}

