/*
 * Decompiled with CFR 0.152.
 */
package com.inputstick.api;

import com.inputstick.api.AES;
import com.inputstick.api.Packet;
import com.inputstick.api.Util;
import com.inputstick.api.bluetooth.BTService;
import java.util.Arrays;
import java.util.Random;
import java.util.zip.CRC32;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class PacketManager {
    public static final int MAX_PAYLAOD = 64;
    public static final int HEADER_OFFSET = 2;
    public static final int CRC_OFFSET = 4;
    public static final int PACKET_SIZE = 16;
    private final BTService mBTService;
    private final AES mAes;
    private byte[] mKey;
    private byte[] cmpData;
    private final CRC32 mCrc;
    private boolean mEncryption;
    private byte[] mHMACKey;
    private int mHmacCounter;

    public PacketManager(BTService btService, byte[] key) {
        this.mBTService = btService;
        this.mCrc = new CRC32();
        this.mAes = new AES();
        this.mKey = key;
        this.mEncryption = false;
    }

    public boolean setEncryption(byte[] cmp, boolean encryptOut, byte[] encryptedHMACKey) {
        byte[] cmpDec = this.mAes.decrypt(cmp);
        this.mHMACKey = null;
        if (Arrays.equals(cmpDec, this.cmpData)) {
            this.mEncryption = encryptOut;
            if (encryptedHMACKey != null) {
                this.mHMACKey = this.mAes.decrypt(encryptedHMACKey);
            }
            this.mHmacCounter = 0;
            return true;
        }
        this.mEncryption = false;
        return false;
    }

    public boolean isEncrypted() {
        return this.mEncryption;
    }

    public void changeKey(byte[] key) {
        this.mKey = key;
    }

    public Packet encPacket(boolean enable, boolean hmac) {
        Random r = new Random();
        Packet p = hmac ? new Packet(true, 48) : new Packet(true, 18);
        if (enable) {
            p.addByte((byte)1);
        } else {
            p.addByte((byte)0);
        }
        byte[] iv = this.mAes.init(this.mKey);
        p.addBytes(iv);
        byte[] initData = new byte[16];
        r.nextBytes(initData);
        this.mCrc.reset();
        this.mCrc.update(initData, 4, 12);
        long crcValue = this.mCrc.getValue();
        initData[3] = (byte)crcValue;
        initData[2] = (byte)(crcValue >>= 8);
        initData[1] = (byte)(crcValue >>= 8);
        initData[0] = (byte)(crcValue >>= 8);
        initData = this.mAes.encrypt(initData);
        p.addBytes(initData);
        this.cmpData = new byte[16];
        r.nextBytes(this.cmpData);
        p.addBytes(this.cmpData);
        return p;
    }

    public byte[] bytesToPacket(byte[] data) {
        byte[] payload = Arrays.copyOfRange(data, 2, data.length);
        if ((data[1] & 0x40) != 0) {
            if (this.mAes.isReady()) {
                payload = this.mAes.decrypt(payload);
            } else {
                return null;
            }
        }
        long crcCompare = Util.getLong(payload[0], payload[1], payload[2], payload[3]);
        this.mCrc.reset();
        this.mCrc.update(payload, 4, payload.length - 4);
        long crcValue = this.mCrc.getValue();
        if (crcValue == crcCompare) {
            payload = Arrays.copyOfRange(payload, 4, payload.length);
            return payload;
        }
        return null;
    }

    public void setStatusUpdateInterval(int interval) {
        this.mBTService.setStatusUpdateInterval(interval);
    }

    public void sendRAW(byte[] data) {
        this.mBTService.write(data);
    }

    public void sendPacket(Packet p) {
        if (p != null) {
            this.sendPacket(p, this.mEncryption);
        }
    }

    public void sendPacket(Packet p, boolean encrypt) {
        byte[] data = p.getBytes();
        int length = data.length + 4;
        int packets = (length - 1 >> 4) + 1;
        byte[] result2 = new byte[packets * 16];
        System.arraycopy(data, 0, result2, 4, data.length);
        this.mCrc.reset();
        this.mCrc.update(result2, 4, result2.length - 4);
        long crcValue = this.mCrc.getValue();
        result2[3] = (byte)crcValue;
        result2[2] = (byte)(crcValue >>= 8);
        result2[1] = (byte)(crcValue >>= 8);
        result2[0] = (byte)(crcValue >>= 8);
        if (encrypt) {
            result2 = this.mAes.encrypt(result2);
        }
        byte[] header = new byte[]{85, (byte)packets};
        if (encrypt) {
            header[1] = (byte)(header[1] | 0x40);
        }
        if (p.getRespond()) {
            header[1] = (byte)(header[1] | 0xFFFFFF80);
        }
        byte[] hmacPacket = null;
        if (encrypt && this.mHMACKey != null) {
            try {
                int counter = this.mHmacCounter++;
                hmacPacket = new byte[20];
                hmacPacket[0] = (byte)counter;
                hmacPacket[1] = (byte)(counter >>= 8);
                hmacPacket[2] = (byte)(counter >>= 8);
                hmacPacket[3] = (byte)(counter >>= 8);
                Mac sha256_HMAC = Mac.getInstance("HmacSHA256");
                sha256_HMAC.init(new SecretKeySpec(this.mHMACKey, "HmacSHA256"));
                sha256_HMAC.update(hmacPacket, 0, 4);
                sha256_HMAC.update(result2, 0, result2.length);
                byte[] hmacOutput = sha256_HMAC.doFinal();
                System.arraycopy(hmacOutput, 0, hmacPacket, 4, 16);
                header[1] = (byte)(header[1] | 0x20);
            }
            catch (Exception e) {
                hmacPacket = null;
            }
        }
        this.mBTService.write(header);
        this.mBTService.write(result2);
        if (hmacPacket != null) {
            this.mBTService.write(hmacPacket);
        }
    }
}

