/*
 * Decompiled with CFR 0.152.
 */
package com.inputstick.api;

import android.annotation.SuppressLint;
import android.util.Log;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public abstract class Util {
    public static final int LOG_MAX_CAPACITY = 500;
    public static final int FLAG_LOG_API = 1;
    public static final int FLAG_LOG_BT_CALLS = 256;
    public static final int FLAG_LOG_BT_ADAPTER = 512;
    public static final int FLAG_LOG_BT_PACKET = 1024;
    public static final int FLAG_LOG_BT_EXCEPTION = 2048;
    public static final int FLAG_LOG_BT_SERVICE = 4096;
    public static final int FLAG_LOG_UTILITY_CALLS = 65536;
    public static final int FLAG_LOG_UTILITY_SERVICE = 131072;
    public static final int FLAG_LOG_UTILITY_UI = 262144;
    public static final int FLAG_LOG_UTILITY_PACKET = 524288;
    public static final int FLAG_LOG_UTILITY_EXCEPTION = 0x100000;
    public static final int FLAG_NONE = 0;
    public static final int FLAG_ALL = -1;
    private static boolean logCatEnabled;
    private static int eventLogFlags;
    private static String[] logMessages;
    private static int[] logFlags;
    private static long[] logTimeStamps;
    private static int cnt;
    private static int totalCnt;
    public static boolean debug;
    public static boolean flashingToolMode;

    private static void initLog() {
        if (logMessages == null || logFlags == null || logTimeStamps == null) {
            logMessages = new String[500];
            logFlags = new int[500];
            logTimeStamps = new long[500];
            cnt = 0;
            totalCnt = 0;
        }
    }

    public static void clearLog() {
        logMessages = null;
        logFlags = null;
        logTimeStamps = null;
        Util.initLog();
    }

    public static void setLogOptions(int logFlags, boolean logCat) {
        eventLogFlags = logFlags;
        logCatEnabled = logCat;
    }

    public static void log(int flag, String message) {
        if ((eventLogFlags & flag) != 0) {
            Util.initLog();
            Util.logMessages[Util.cnt] = message;
            Util.logFlags[Util.cnt] = flag;
            Util.logTimeStamps[Util.cnt] = System.currentTimeMillis();
            ++totalCnt;
            if (++cnt == 500) {
                cnt = 0;
            }
            if (logCatEnabled) {
                String msg = "[" + Util.getNameOfFlag(flag) + "] " + message;
                Log.d((String)"InputStickUtility", (String)msg);
            }
        }
    }

    public static String getLog(int printFlags) {
        int i;
        String result2 = "";
        Util.initLog();
        if (totalCnt == 0) {
            return null;
        }
        int logged = cnt;
        if (cnt > 500) {
            logged = 500;
        }
        result2 = result2 + "[" + System.currentTimeMillis() + "] [LOG] Logged messages: " + logged + " (total: " + totalCnt + ")\n";
        for (i = cnt; i < 500; ++i) {
            if (logMessages[i] == null) continue;
            result2 = result2 + "[" + logTimeStamps[i] + "] ";
            result2 = result2 + "[" + Util.getNameOfFlag(logFlags[i]) + "] ";
            result2 = result2 + logMessages[i] + "\n";
        }
        for (i = 0; i < cnt; ++i) {
            if (logMessages[i] == null) continue;
            result2 = result2 + "[" + logTimeStamps[i] + "] ";
            result2 = result2 + "[" + Util.getNameOfFlag(logFlags[i]) + "] ";
            result2 = result2 + logMessages[i] + "\n";
        }
        return result2;
    }

    private static String getNameOfFlag(int flag) {
        switch (flag) {
            case 1024: {
                return "BT PACKET";
            }
            case 524288: {
                return "UTILITY PACKET";
            }
            case 256: {
                return "BT CALL";
            }
            case 512: {
                return "BT ADAPTER";
            }
            case 2048: {
                return "BT EXCEPTION";
            }
            case 4096: {
                return "BT SERVICE";
            }
            case 65536: {
                return "UTILITY CALLS";
            }
            case 131072: {
                return "UTILITY SERVICE";
            }
            case 262144: {
                return "UTILITY UI";
            }
            case 0x100000: {
                return "UTILITY EXCEPTION";
            }
            case 1: {
                return "API";
            }
        }
        return "UNKNOWN";
    }

    public static void printHex(byte[] toPrint, String info) {
        if (debug) {
            System.out.println(info);
            Util.printHex(toPrint);
        }
    }

    @SuppressLint(value={"DefaultLocale"})
    public static String byteToHexString(byte b) {
        String s;
        if (b < 16 && b >= 0) {
            s = Integer.toHexString(b);
            s = "0" + s;
        } else {
            s = Integer.toHexString(b);
            if (s.length() > 2) {
                s = s.substring(s.length() - 2);
            }
        }
        s = s.toUpperCase();
        return s;
    }

    public static void printHex(byte[] toPrint) {
        if (debug) {
            if (toPrint != null) {
                int cnt = 0;
                for (int i = 0; i < toPrint.length; ++i) {
                    byte b = toPrint[i];
                    System.out.print("0x" + Util.byteToHexString(b) + " ");
                    if (++cnt != 8) continue;
                    System.out.println("");
                    cnt = 0;
                }
            } else {
                System.out.println("null");
            }
            System.out.println("\n#####");
        }
    }

    public static byte getLSB(int n) {
        return (byte)(n & 0xFF);
    }

    public static byte getMSB(int n) {
        return (byte)((n & 0xFF00) >> 8);
    }

    public static int getInt(byte b) {
        int bInt = b & 0xFF;
        return bInt;
    }

    public static int getInt(byte msb, byte lsb) {
        int msbInt = msb & 0xFF;
        int lsbInt = lsb & 0xFF;
        return (msbInt << 8) + lsbInt;
    }

    public static long getLong(byte b0, byte b1, byte b2, byte b3) {
        long result2 = b0 & 0xFF;
        result2 <<= 8;
        result2 += (long)(b1 & 0xFF);
        result2 <<= 8;
        result2 += (long)(b2 & 0xFF);
        result2 <<= 8;
        return result2 += (long)(b3 & 0xFF);
    }

    public static byte[] getPasswordBytes(String plainText) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            return md.digest(plainText.getBytes("UTF-8"));
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String[] convertToStringArray(CharSequence[] charSequences) {
        String[] result2 = new String[charSequences.length];
        for (int i = 0; i < charSequences.length; ++i) {
            result2[i] = charSequences[i].toString();
        }
        return result2;
    }

    static {
        debug = false;
        flashingToolMode = false;
    }
}

