/*
 * Decompiled with CFR 0.152.
 */
package com.inputstick.api.basic;

import com.inputstick.api.basic.InputStickHID;
import com.inputstick.api.hid.ConsumerReport;
import com.inputstick.api.hid.HIDTransaction;

public class InputStickConsumer {
    public static final int VOL_UP = 233;
    public static final int VOL_DOWN = 234;
    public static final int VOL_MUTE = 226;
    public static final int TRACK_NEXT = 181;
    public static final int TRACK_PREV = 182;
    public static final int STOP = 183;
    public static final int PLAY_PAUSE = 205;
    public static final int LAUNCH_BROWSER = 406;
    public static final int LAUNCH_EMAIL = 394;
    public static final int LAUNCH_CALC = 402;
    public static final int HOME = 547;
    public static final int BACK = 548;
    public static final int FORWARD = 549;
    public static final int REFRESH = 551;
    public static final int SEARCH = 545;
    public static final byte SYSTEM_POWER_DOWN = 1;
    public static final byte SYSTEM_SLEEP = 2;
    public static final byte SYSTEM_WAKEUP = 3;

    private InputStickConsumer() {
    }

    public static void systemAction(byte action) {
        HIDTransaction t = new HIDTransaction();
        t.addReport(new ConsumerReport(2, action, 0));
        t.addReport(new ConsumerReport(2, 0, 0));
        InputStickHID.addConsumerTransaction(t, true);
    }

    public static void systemPowerDown() {
        InputStickConsumer.systemAction((byte)1);
    }

    public static void systemSleep() {
        InputStickConsumer.systemAction((byte)2);
    }

    public static void systemWakeUp() {
        InputStickConsumer.systemAction((byte)3);
    }

    public static void consumerAction(int action) {
        HIDTransaction t = new HIDTransaction();
        t.addReport(new ConsumerReport(action));
        t.addReport(new ConsumerReport());
        InputStickHID.addConsumerTransaction(t, true);
    }

    public static String actionToString(int action) {
        switch (action) {
            case 233: {
                return "Volume up";
            }
            case 234: {
                return "Volume down";
            }
            case 226: {
                return "Mute/Unmute";
            }
            case 181: {
                return "Next track";
            }
            case 182: {
                return "Previous track";
            }
            case 183: {
                return "Stop";
            }
            case 205: {
                return "Play/Pause";
            }
            case 406: {
                return "Launch web browser";
            }
            case 394: {
                return "Launch email client";
            }
            case 402: {
                return "Launch calculator";
            }
            case 547: {
                return "Home button";
            }
            case 548: {
                return "Back button";
            }
            case 549: {
                return "Forward";
            }
            case 551: {
                return "Refresh";
            }
            case 545: {
                return "Search";
            }
            case 1: {
                return "Power down";
            }
            case 2: {
                return "Sleep";
            }
            case 3: {
                return "Wake up";
            }
        }
        return String.valueOf(action);
    }
}

