/*
 * Decompiled with CFR 0.152.
 */
package com.inputstick.api.basic;

import android.app.AlertDialog;
import android.app.Application;
import android.content.Context;
import com.inputstick.api.BTConnectionManager;
import com.inputstick.api.ConnectionManager;
import com.inputstick.api.DownloadDialog;
import com.inputstick.api.HIDInfo;
import com.inputstick.api.IPCConnectionManager;
import com.inputstick.api.InputStickDataListener;
import com.inputstick.api.InputStickStateListener;
import com.inputstick.api.OnEmptyBufferListener;
import com.inputstick.api.Packet;
import com.inputstick.api.basic.InputStickKeyboard;
import com.inputstick.api.basic.InputStickMouse;
import com.inputstick.api.basic.InputStickRawHID;
import com.inputstick.api.hid.HIDTransaction;
import com.inputstick.api.hid.HIDTransactionQueue;
import com.inputstick.api.init.BasicInitManager;
import com.inputstick.api.init.DeviceInfo;
import com.inputstick.api.init.InitManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Vector;

public class InputStickHID
implements InputStickStateListener,
InputStickDataListener {
    public static final int INTERFACE_KEYBOARD = 0;
    public static final int INTERFACE_CONSUMER = 1;
    public static final int INTERFACE_MOUSE = 2;
    public static final int INTERFACE_RAW_HID = 3;
    private static ConnectionManager mConnectionManager;
    private static Vector<InputStickStateListener> mStateListeners;
    protected static Vector<OnEmptyBufferListener> mBufferEmptyListeners;
    private static InputStickHID instance;
    private static HIDInfo mHIDInfo;
    private static DeviceInfo mDeviceInfo;
    private static HIDTransactionQueue keyboardQueue;
    private static HIDTransactionQueue mouseQueue;
    private static HIDTransactionQueue consumerQueue;
    private static HIDTransactionQueue rawHIDQueue;

    private InputStickHID() {
    }

    public static InputStickHID getInstance() {
        return instance;
    }

    private static void init() {
        mHIDInfo = new HIDInfo();
        keyboardQueue = new HIDTransactionQueue(0, mConnectionManager, 32, 32);
        mouseQueue = new HIDTransactionQueue(2, mConnectionManager, 32, 32);
        consumerQueue = new HIDTransactionQueue(1, mConnectionManager, 32, 32);
        rawHIDQueue = new HIDTransactionQueue(3, mConnectionManager, 2, 1);
        mConnectionManager.addStateListener(instance);
        mConnectionManager.addDataListener(instance);
        mConnectionManager.connect();
    }

    public static AlertDialog getDownloadDialog(Context ctx) {
        if (mConnectionManager.getErrorCode() == 4097) {
            return DownloadDialog.getDialog(ctx, 0);
        }
        return null;
    }

    public static void connect(Application app) {
        mConnectionManager = new IPCConnectionManager(app);
        InputStickHID.init();
    }

    public static void disconnect() {
        if (mConnectionManager != null) {
            mConnectionManager.disconnect();
        }
    }

    public static void connect(Application app, String mac, byte[] key, InitManager initManager) {
        InputStickHID.connect(app, mac, key, initManager, false);
    }

    public static void connect(Application app, String mac, byte[] key, InitManager initManager, boolean isBT40) {
        mConnectionManager = new BTConnectionManager(initManager, app, mac, key, isBT40);
        InputStickHID.init();
    }

    public static void connect(Application app, String mac, byte[] key, boolean isBT40) {
        mConnectionManager = new BTConnectionManager(new BasicInitManager(key), app, mac, key, isBT40);
        InputStickHID.init();
    }

    public static void connect(Application app, String mac, byte[] key) {
        InputStickHID.connect(app, mac, key, false);
    }

    public static void wakeUpUSBHost() {
        if (InputStickHID.isConnected()) {
            Packet p = new Packet(false, 25);
            InputStickHID.sendPacket(p);
            mConnectionManager.sendPacket(p);
        }
    }

    public static ConnectionManager getConnectionManager() {
        return mConnectionManager;
    }

    public static DeviceInfo getDeviceInfo() {
        if (InputStickHID.isReady() && mDeviceInfo != null) {
            return mDeviceInfo;
        }
        return null;
    }

    public static HIDInfo getHIDInfo() {
        return mHIDInfo;
    }

    public static int getState() {
        if (mConnectionManager != null) {
            return mConnectionManager.getState();
        }
        return 0;
    }

    public static int getErrorCode() {
        if (mConnectionManager != null) {
            return mConnectionManager.getErrorCode();
        }
        return 1;
    }

    public static int getDisconnectReason() {
        if (mConnectionManager != null) {
            return mConnectionManager.getDisconnectReason();
        }
        return 0;
    }

    public static boolean isConnected() {
        return InputStickHID.getState() == 4 || InputStickHID.getState() == 3;
    }

    public static boolean isReady() {
        return InputStickHID.getState() == 4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addStateListener(InputStickStateListener listener2) {
        if (listener2 != null && !mStateListeners.contains(listener2)) {
            Vector<InputStickStateListener> vector = mStateListeners;
            synchronized (vector) {
                mStateListeners.add(listener2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeStateListener(InputStickStateListener listener2) {
        if (listener2 != null) {
            Vector<InputStickStateListener> vector = mStateListeners;
            synchronized (vector) {
                mStateListeners.remove(listener2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addBufferEmptyListener(OnEmptyBufferListener listener2) {
        if (listener2 != null) {
            Vector<OnEmptyBufferListener> vector = mBufferEmptyListeners;
            synchronized (vector) {
                if (!mBufferEmptyListeners.contains(listener2)) {
                    mBufferEmptyListeners.add(listener2);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeBufferEmptyListener(OnEmptyBufferListener listener2) {
        if (listener2 != null) {
            Vector<OnEmptyBufferListener> vector = mBufferEmptyListeners;
            synchronized (vector) {
                mBufferEmptyListeners.remove(listener2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendEmptyBufferNotifications(int bufferType, int interfaceType) {
        if (bufferType == 1) {
            Vector<OnEmptyBufferListener> vector = mBufferEmptyListeners;
            synchronized (vector) {
                for (OnEmptyBufferListener listener2 : mBufferEmptyListeners) {
                    listener2.onRemoteBufferEmpty(interfaceType);
                }
            }
        }
        if (bufferType == 2) {
            Vector<OnEmptyBufferListener> vector = mBufferEmptyListeners;
            synchronized (vector) {
                for (OnEmptyBufferListener listener3 : mBufferEmptyListeners) {
                    listener3.onLocalBufferEmpty(interfaceType);
                }
            }
        }
    }

    public static void addKeyboardTransaction(HIDTransaction transaction, boolean sendNow) {
        if (transaction != null && keyboardQueue != null) {
            keyboardQueue.addTransaction(transaction, sendNow);
        }
    }

    public static void addKeyboardTransaction(HIDTransaction transaction) {
        if (transaction != null && keyboardQueue != null) {
            keyboardQueue.addTransaction(transaction, true);
        }
    }

    public static void flushKeyboardBuffer() {
        if (keyboardQueue != null) {
            keyboardQueue.sendFromQueue();
        }
    }

    public static void addMouseTransaction(HIDTransaction transaction, boolean sendNow) {
        if (transaction != null && mouseQueue != null) {
            mouseQueue.addTransaction(transaction, sendNow);
        }
    }

    public static void addMouseTransaction(HIDTransaction transaction) {
        if (transaction != null && mouseQueue != null) {
            mouseQueue.addTransaction(transaction, true);
        }
    }

    public static void flushMouseBuffer() {
        if (mouseQueue != null) {
            mouseQueue.sendFromQueue();
        }
    }

    public static void addConsumerTransaction(HIDTransaction transaction, boolean sendNow) {
        if (transaction != null && consumerQueue != null) {
            consumerQueue.addTransaction(transaction, sendNow);
        }
    }

    public static void addConsumerTransaction(HIDTransaction transaction) {
        if (transaction != null && consumerQueue != null) {
            consumerQueue.addTransaction(transaction, true);
        }
    }

    public static void flushConsumerBuffer() {
        if (consumerQueue != null) {
            consumerQueue.sendFromQueue();
        }
    }

    public static void addRawHIDTransaction(HIDTransaction transaction, boolean sendNow) {
        if (transaction != null && rawHIDQueue != null) {
            rawHIDQueue.addTransaction(transaction, sendNow);
        }
    }

    public static void addRawHIDTransaction(HIDTransaction transaction) {
        if (transaction != null && rawHIDQueue != null) {
            rawHIDQueue.addTransaction(transaction, true);
        }
    }

    public static void flushRawHIDBuffer() {
        if (rawHIDQueue != null) {
            rawHIDQueue.sendFromQueue();
        }
    }

    public static void clearKeyboardBuffer() {
        if (keyboardQueue != null) {
            keyboardQueue.clearBuffer();
        }
    }

    public static void clearMouseBuffer() {
        if (mouseQueue != null) {
            mouseQueue.clearBuffer();
        }
    }

    public static void clearConsumerBuffer() {
        if (consumerQueue != null) {
            consumerQueue.clearBuffer();
        }
    }

    public static void clearRawHIDBuffer() {
        if (rawHIDQueue != null) {
            rawHIDQueue.clearBuffer();
        }
    }

    public static void clearAllBuffers() {
        InputStickHID.clearKeyboardBuffer();
        InputStickHID.clearMouseBuffer();
        InputStickHID.clearConsumerBuffer();
        InputStickHID.clearRawHIDBuffer();
    }

    public static boolean sendPacket(Packet p) {
        if (mConnectionManager != null) {
            mConnectionManager.sendPacket(p);
            return true;
        }
        return false;
    }

    public static boolean isKeyboardLocalBufferEmpty() {
        if (keyboardQueue != null) {
            return keyboardQueue.isLocalBufferEmpty();
        }
        return true;
    }

    public static boolean isMouseLocalBufferEmpty() {
        if (mouseQueue != null) {
            return mouseQueue.isLocalBufferEmpty();
        }
        return true;
    }

    public static boolean isConsumerLocalBufferEmpty() {
        if (consumerQueue != null) {
            return consumerQueue.isLocalBufferEmpty();
        }
        return true;
    }

    public static boolean isRawHIDLocalBufferEmpty() {
        if (rawHIDQueue != null) {
            return rawHIDQueue.isLocalBufferEmpty();
        }
        return true;
    }

    public static boolean areAllLocalBuffersEmpty() {
        return InputStickHID.isKeyboardLocalBufferEmpty() && InputStickHID.isMouseLocalBufferEmpty() && InputStickHID.isConsumerLocalBufferEmpty() && InputStickHID.isRawHIDLocalBufferEmpty();
    }

    public static boolean isKeyboardRemoteBufferEmpty() {
        if (keyboardQueue != null) {
            return keyboardQueue.isRemoteBufferEmpty();
        }
        return true;
    }

    public static boolean isMouseRemoteBufferEmpty() {
        if (mouseQueue != null) {
            return mouseQueue.isRemoteBufferEmpty();
        }
        return true;
    }

    public static boolean isConsumerRemoteBufferEmpty() {
        if (consumerQueue != null) {
            return consumerQueue.isRemoteBufferEmpty();
        }
        return true;
    }

    public static boolean isRawHIDRemoteBufferEmpty() {
        if (rawHIDQueue != null) {
            return rawHIDQueue.isRemoteBufferEmpty();
        }
        return true;
    }

    public static boolean areAllRemoteBuffersEmpty() {
        return InputStickHID.isKeyboardRemoteBufferEmpty() && InputStickHID.isMouseRemoteBufferEmpty() && InputStickHID.isConsumerRemoteBufferEmpty() && InputStickHID.isRawHIDRemoteBufferEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onStateChanged(int state) {
        Vector<InputStickStateListener> vector = mStateListeners;
        synchronized (vector) {
            ArrayList<InputStickStateListener> tmp = new ArrayList<InputStickStateListener>();
            for (InputStickStateListener listener2 : mStateListeners) {
                tmp.add(listener2);
            }
            for (InputStickStateListener listener2 : tmp) {
                listener2.onStateChanged(state);
            }
        }
    }

    @Override
    public void onInputStickData(byte[] data) {
        byte cmd = data[0];
        if (cmd == 16 && (mDeviceInfo = new DeviceInfo(data)).getFirmwareVersion() >= 100) {
            keyboardQueue.setCapacity(128);
            mouseQueue.setCapacity(64);
            consumerQueue.setCapacity(64);
        }
        if (cmd == 39 && data.length > 65) {
            InputStickRawHID.notifyRawHIDListeners(Arrays.copyOfRange(data, 1, 65));
        }
        if (cmd == 47) {
            mHIDInfo.update(data);
            InputStickKeyboard.setReportProtocol(mHIDInfo.isKeyboardReportProtocol());
            InputStickMouse.setReportProtocol(mHIDInfo.isMouseReportProtocol());
            if (keyboardQueue != null) {
                keyboardQueue.update(mHIDInfo);
            }
            if (mouseQueue != null) {
                mouseQueue.update(mHIDInfo);
            }
            if (consumerQueue != null) {
                consumerQueue.update(mHIDInfo);
            }
            if (rawHIDQueue != null) {
                rawHIDQueue.update(mHIDInfo);
            }
            InputStickKeyboard.setLEDs(mHIDInfo.getNumLock(), mHIDInfo.getCapsLock(), mHIDInfo.getScrollLock());
        }
    }

    static {
        mStateListeners = new Vector();
        mBufferEmptyListeners = new Vector();
        instance = new InputStickHID();
    }
}

