/*
 * Decompiled with CFR 0.152.
 */
package com.inputstick.api.basic;

import android.util.SparseArray;
import com.inputstick.api.InputStickKeyboardListener;
import com.inputstick.api.basic.InputStickHID;
import com.inputstick.api.hid.HIDKeycodes;
import com.inputstick.api.hid.HIDTransaction;
import com.inputstick.api.hid.KeyboardReport;
import com.inputstick.api.layout.KeyboardLayout;
import java.util.Vector;

public class InputStickKeyboard {
    public static final int TYPING_SPEED_FASTEST = 0;
    public static final int TYPING_SPEED_NORMAL = 1;
    public static final int TYPING_SPEED_050X = 2;
    public static final int TYPING_SPEED_033X = 3;
    public static final int TYPING_SPEED_025X = 4;
    public static final int TYPING_SPEED_020X = 5;
    public static final int TYPING_SPEED_017X = 6;
    public static final int TYPING_SPEED_014X = 7;
    public static final int TYPING_SPEED_013X = 8;
    public static final int TYPING_SPEED_011X = 9;
    public static final int TYPING_SPEED_010X = 10;
    private static final byte NONE = 0;
    private static final byte LED_NUM_LOCK = 1;
    private static final byte LED_CAPS_LOCK = 2;
    private static final byte LED_SCROLL_LOCK = 4;
    private static boolean mReportProtocol;
    private static boolean mNumLock;
    private static boolean mCapsLock;
    private static boolean mScrollLock;
    private static Vector<InputStickKeyboardListener> mKeyboardListeners;
    private static final SparseArray<String> ledsMap;

    private InputStickKeyboard() {
    }

    public static void pressAndRelease(byte modifier, byte key) {
        HIDTransaction t = new HIDTransaction();
        t.addReport(new KeyboardReport(modifier, 0));
        t.addReport(new KeyboardReport(modifier, key));
        t.addReport(new KeyboardReport(0, 0));
        InputStickHID.addKeyboardTransaction(t, true);
    }

    public static void pressAndRelease(byte modifier, byte key, int typingSpeed) {
        int i;
        HIDTransaction t = new HIDTransaction();
        int cnt = typingSpeed;
        if (cnt < 1) {
            cnt = 1;
        }
        for (i = 0; i < cnt; ++i) {
            t.addReport(new KeyboardReport(modifier, 0));
        }
        for (i = 0; i < cnt; ++i) {
            t.addReport(new KeyboardReport(modifier, key));
        }
        for (i = 0; i < cnt; ++i) {
            t.addReport(new KeyboardReport(0, 0));
        }
        InputStickHID.addKeyboardTransaction(t, true);
    }

    public static void type(String toType, String layoutCode) {
        KeyboardLayout layout2 = KeyboardLayout.getLayout(layoutCode);
        layout2.type(toType);
    }

    public static void type(String toType, String layoutCode, int typingSpeed) {
        KeyboardLayout layout2 = KeyboardLayout.getLayout(layoutCode);
        layout2.type(toType, typingSpeed);
    }

    public static void typeASCII(String toType) {
        if (toType != null) {
            for (int i = 0; i < toType.length(); ++i) {
                int keyCode;
                int index = toType.charAt(i);
                if (index == 10) {
                    InputStickKeyboard.pressAndRelease((byte)0, (byte)40);
                    continue;
                }
                if (index == 9) {
                    InputStickKeyboard.pressAndRelease((byte)0, (byte)43);
                    continue;
                }
                if (index > 127) {
                    index = 127;
                }
                if ((keyCode = HIDKeycodes.getKeyCode(index)) > 128) {
                    InputStickKeyboard.pressAndRelease((byte)2, (byte)(keyCode -= 128));
                    continue;
                }
                InputStickKeyboard.pressAndRelease((byte)0, (byte)keyCode);
            }
        }
    }

    public static void customReport(byte modifier, byte key0, byte key1, byte key2, byte key3, byte key4, byte key5) {
        HIDTransaction t = new HIDTransaction();
        t.addReport(new KeyboardReport(modifier, key0, key1, key2, key3, key4, key5));
        InputStickHID.addKeyboardTransaction(t, true);
    }

    public static boolean isReportProtocol() {
        return mReportProtocol;
    }

    public static boolean isNumLock() {
        return mNumLock;
    }

    public static boolean isCapsLock() {
        return mCapsLock;
    }

    public static boolean isScrollLock() {
        return mScrollLock;
    }

    public static void toggleNumLock() {
        InputStickKeyboard.pressAndRelease((byte)0, (byte)83);
    }

    public static void toggleCapsLock() {
        InputStickKeyboard.pressAndRelease((byte)0, (byte)57);
    }

    public static void toggleScrollLock() {
        InputStickKeyboard.pressAndRelease((byte)0, (byte)71);
    }

    public static String ledsToString(byte leds) {
        String result2 = "None";
        boolean first2 = true;
        for (int i = 0; i < 8; ++i) {
            byte mod = (byte)(1 << i);
            if ((leds & mod) == 0) continue;
            result2 = !first2 ? result2 + ", " : "";
            first2 = false;
            result2 = result2 + (String)ledsMap.get((int)mod);
        }
        return result2;
    }

    public static void addKeyboardListener(InputStickKeyboardListener listener2) {
        if (listener2 != null && !mKeyboardListeners.contains(listener2)) {
            mKeyboardListeners.add(listener2);
        }
    }

    public static void removeKeyboardListener(InputStickKeyboardListener listener2) {
        if (listener2 != null) {
            mKeyboardListeners.remove(listener2);
        }
    }

    protected static void setReportProtocol(boolean reportProtocol) {
        mReportProtocol = reportProtocol;
    }

    protected static void setLEDs(boolean numLock, boolean capsLock, boolean scrollLock) {
        boolean mustUpdate = false;
        if (numLock != mNumLock || capsLock != mCapsLock || scrollLock != mScrollLock) {
            mustUpdate = true;
        }
        mNumLock = numLock;
        mCapsLock = capsLock;
        mScrollLock = scrollLock;
        if (mustUpdate) {
            for (InputStickKeyboardListener listener2 : mKeyboardListeners) {
                listener2.onLEDsChanged(mNumLock, mCapsLock, mScrollLock);
            }
        }
    }

    static {
        mKeyboardListeners = new Vector();
        ledsMap = new SparseArray();
        ledsMap.put(1, (Object)"NumLock");
        ledsMap.put(2, (Object)"CapsLock");
        ledsMap.put(4, (Object)"ScrollLock");
    }
}

