/*
 * Decompiled with CFR 0.152.
 */
package com.inputstick.api.basic;

import android.util.SparseArray;
import com.inputstick.api.basic.InputStickHID;
import com.inputstick.api.hid.HIDTransaction;
import com.inputstick.api.hid.MouseReport;

public class InputStickMouse {
    private static final byte NONE = 0;
    public static final byte BUTTON_NONE = 0;
    public static final byte BUTTON_LEFT = 1;
    public static final byte BUTTON_RIGHT = 2;
    public static final byte BUTTON_MIDDLE = 4;
    private static final SparseArray<String> buttonsMap = new SparseArray();
    private static boolean mReportProtocol;

    private InputStickMouse() {
    }

    public static void click(byte button, int n) {
        HIDTransaction t = new HIDTransaction();
        t.addReport(new MouseReport());
        for (int i = 0; i < n; ++i) {
            t.addReport(new MouseReport(button, 0, 0, 0));
            t.addReport(new MouseReport());
        }
        InputStickHID.addMouseTransaction(t, true);
    }

    public static void move(byte x, byte y) {
        HIDTransaction t = new HIDTransaction();
        t.addReport(new MouseReport(0, x, y, 0));
        InputStickHID.addMouseTransaction(t, true);
    }

    public static void scroll(byte wheel) {
        HIDTransaction t = new HIDTransaction();
        t.addReport(new MouseReport(0, 0, 0, wheel));
        InputStickHID.addMouseTransaction(t, true);
    }

    public static void customReport(byte buttons, byte x, byte y, byte wheel) {
        HIDTransaction t = new HIDTransaction();
        t.addReport(new MouseReport(buttons, x, y, wheel));
        InputStickHID.addMouseTransaction(t, true);
    }

    public static String buttonsToString(byte buttons) {
        String result2 = "None";
        boolean first2 = true;
        for (int i = 0; i < 8; ++i) {
            byte mod = (byte)(1 << i);
            if ((buttons & mod) == 0) continue;
            result2 = !first2 ? result2 + ", " : "";
            first2 = false;
            result2 = result2 + (String)buttonsMap.get((int)mod);
        }
        return result2;
    }

    public static boolean isReportProtocol() {
        return mReportProtocol;
    }

    protected static void setReportProtocol(boolean reportProtocol) {
        mReportProtocol = reportProtocol;
    }

    static {
        buttonsMap.put(1, (Object)"Left");
        buttonsMap.put(2, (Object)"Right");
        buttonsMap.put(4, (Object)"Middle");
    }
}

