/*
 * Decompiled with CFR 0.152.
 */
package com.inputstick.api.basic;

import com.inputstick.api.InputStickRawHIDListener;
import com.inputstick.api.basic.InputStickHID;
import com.inputstick.api.hid.HIDTransaction;
import com.inputstick.api.hid.RawHIDReport;
import java.util.Arrays;
import java.util.Vector;

public class InputStickRawHID {
    private static Vector<InputStickRawHIDListener> mRawHIDListeners = new Vector();

    public static void sendRawHIDData(byte[] data) {
        if (data != null) {
            HIDTransaction t = new HIDTransaction();
            int start = 0;
            while (start < data.length) {
                int end = start + 64;
                if (end > data.length) {
                    end = data.length;
                }
                t.addReport(new RawHIDReport(Arrays.copyOfRange(data, start, end)));
                InputStickHID.addRawHIDTransaction(t, true);
                start = end;
            }
        }
    }

    public static void addRawHIDListener(InputStickRawHIDListener listener2) {
        if (listener2 != null && !mRawHIDListeners.contains(listener2)) {
            mRawHIDListeners.add(listener2);
        }
    }

    public static void removeRawHIDListener(InputStickRawHIDListener listener2) {
        if (listener2 != null) {
            mRawHIDListeners.remove(listener2);
        }
    }

    protected static void notifyRawHIDListeners(byte[] data) {
        for (InputStickRawHIDListener listener2 : mRawHIDListeners) {
            listener2.onRawHIDData(data);
        }
    }
}

