/*
 * Decompiled with CFR 0.152.
 */
package com.inputstick.api.bluetooth;

import android.app.Application;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothSocket;
import com.inputstick.api.Util;
import com.inputstick.api.bluetooth.BTConnection;
import com.inputstick.api.bluetooth.BTService;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.UUID;

public class BT20Connection
extends BTConnection {
    private static final UUID MY_UUID = UUID.fromString("00001101-0000-1000-8000-00805F9B34FB");
    private final BluetoothAdapter mAdapter = BluetoothAdapter.getDefaultAdapter();
    private ConnectThread mConnectThread;
    private ConnectedThread mConnectedThread;

    public BT20Connection(Application app, BTService btService, String mac, boolean reflections) {
        super(app, btService, mac, reflections);
    }

    @Override
    public void connect() {
        Util.log(256, "Connect (2.0)");
        this.cancelThreads();
        BluetoothDevice device = this.mAdapter.getRemoteDevice(this.mMac);
        if (device != null) {
            this.mConnectThread = new ConnectThread(device, this.mReflections);
            this.mConnectThread.start();
        } else {
            this.mBTservice.connectionFailed(false, 262);
        }
    }

    @Override
    public void disconnect() {
        Util.log(256, "Disconnect (2.0)");
        this.cancelThreads();
    }

    @Override
    public void setStatusUpdateInterval(int updateRate) {
    }

    @Override
    public void write(byte[] out) {
        this.mConnectedThread.write(out);
    }

    private synchronized void cancelThreads() {
        if (this.mConnectThread != null) {
            this.mConnectThread.cancel();
            this.mConnectThread = null;
        }
        if (this.mConnectedThread != null) {
            this.mConnectedThread.cancel();
            this.mConnectedThread = null;
        }
    }

    private class ConnectThread
    extends Thread {
        private final BluetoothSocket mmSocket;

        public ConnectThread(BluetoothDevice device, boolean useReflection) {
            BluetoothSocket tmp = null;
            try {
                if (useReflection) {
                    Method m = device.getClass().getMethod("createRfcommSocket", Integer.TYPE);
                    tmp = (BluetoothSocket)m.invoke((Object)device, 1);
                } else {
                    tmp = device.createRfcommSocketToServiceRecord(MY_UUID);
                }
            }
            catch (IOException e) {
                Util.log(2048, "Socket create() failed");
            }
            catch (Exception e) {
                Util.log(2048, "Socket create() REFLECTION failed");
                e.printStackTrace();
            }
            this.mmSocket = tmp;
        }

        @Override
        public void run() {
            Util.log(256, "BEGIN mConnectThread");
            BT20Connection.this.mAdapter.cancelDiscovery();
            try {
                this.mmSocket.connect();
            }
            catch (Exception e) {
                try {
                    this.mmSocket.close();
                }
                catch (IOException e2) {
                    Util.log(2048, "unable to close() socket during connection failure");
                }
                BT20Connection.this.mBTservice.connectionFailed(true, 0);
                return;
            }
            BT20Connection.this.mConnectThread = null;
            BT20Connection.this.cancelThreads();
            BT20Connection.this.mConnectedThread = new ConnectedThread(this.mmSocket);
            BT20Connection.this.mConnectedThread.start();
            BT20Connection.this.mBTservice.connectionEstablished();
        }

        public void cancel() {
            try {
                this.mmSocket.close();
            }
            catch (IOException e) {
                Util.log(2048, "close() of connect socket failed");
            }
        }
    }

    private class ConnectedThread
    extends Thread {
        private final BluetoothSocket mmSocket;
        private final InputStream mmInStream;
        private final OutputStream mmOutStream;

        public ConnectedThread(BluetoothSocket socket) {
            Util.log(256, "create ConnectedThread");
            this.mmSocket = socket;
            InputStream tmpIn = null;
            OutputStream tmpOut = null;
            try {
                tmpIn = socket.getInputStream();
                tmpOut = socket.getOutputStream();
            }
            catch (IOException e) {
                Util.log(2048, "failed to create tmp sockets");
            }
            this.mmInStream = tmpIn;
            this.mmOutStream = tmpOut;
        }

        @Override
        public void run() {
            Util.log(256, "BEGIN mConnectedThread");
            try {
                while (true) {
                    int rxTmp = this.mmInStream.read();
                    BT20Connection.this.mBTservice.onByteRx(rxTmp);
                }
            }
            catch (IOException e) {
                BT20Connection.this.mBTservice.connectionFailed(false, 258);
                return;
            }
        }

        public void write(byte[] buffer) {
            try {
                this.mmOutStream.write(buffer);
                this.mmOutStream.flush();
            }
            catch (IOException e) {
                Util.log(2048, "write() exception");
            }
        }

        public void cancel() {
            try {
                this.mmSocket.close();
            }
            catch (IOException e) {
                Util.log(2048, "socket close() exception");
            }
        }
    }
}

