/*
 * Decompiled with CFR 0.152.
 */
package com.inputstick.api.bluetooth;

import android.annotation.SuppressLint;
import android.app.Application;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCallback;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattDescriptor;
import android.bluetooth.BluetoothGattService;
import android.bluetooth.BluetoothManager;
import android.os.Handler;
import android.os.Looper;
import com.inputstick.api.Util;
import com.inputstick.api.bluetooth.BTConnection;
import com.inputstick.api.bluetooth.BTService;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;

@SuppressLint(value={"NewApi"})
public class BT40Connection
extends BTConnection {
    private static final int HW_NONE = 0;
    private static final int HW_HM = 1;
    private static final int HW_NRF = 2;
    private static final int CONNECTION_TIMEOUT = 10000;
    public static final String UUID_HM_DESC = "00002902-0000-1000-8000-00805f9b34fb";
    public static final String UUID_HM_SPS = "0000ffe0-0000-1000-8000-00805f9b34fb";
    public static final String UUID_HM_RX_TX = "0000ffe1-0000-1000-8000-00805f9b34fb";
    public static final String UUID_NRF_DESC = "00002902-0000-1000-8000-00805f9b34fb";
    public static final String UUID_NRF_SPS = "6e400001-b5a3-f393-e0a9-e50e24dcca9e";
    public static final String UUID_NRF_RX = "6e400003-b5a3-f393-e0a9-e50e24dcca9e";
    public static final String UUID_NRF_TX = "6e400002-b5a3-f393-e0a9-e50e24dcca9e";
    private Handler handler;
    private BluetoothAdapter mBluetoothAdapter;
    private BluetoothGatt mBluetoothGatt;
    private BluetoothGattCharacteristic characteristicRx;
    private BluetoothGattCharacteristic characteristicTx;
    private int hardwareType;
    private LinkedList<byte[]> txBuffer;
    private boolean canSend;
    private long lastRxTime;
    private int mStatusUpdateInterval;
    private boolean isConnecting;
    private byte h0;
    private byte h1;
    private boolean header;
    private final BluetoothGattCallback mGattCallback = new BluetoothGattCallback(){

        @SuppressLint(value={"MissingPermission"})
        public void onConnectionStateChange(BluetoothGatt gatt, int status, int newState) {
            Util.log(512, "onConnectionStateChange" + newState);
            if (newState == 2) {
                BT40Connection.this.isConnecting = false;
                if (BT40Connection.this.mBluetoothGatt != null) {
                    boolean result2 = BT40Connection.this.mBluetoothGatt.discoverServices();
                    Util.log(512, "Attempting to start service discovery: " + result2);
                }
            } else if (newState == 0) {
                BT40Connection.this.isConnecting = false;
                BT40Connection.this.mBTservice.connectionFailed(false, 258);
            }
        }

        @SuppressLint(value={"MissingPermission"})
        public void onServicesDiscovered(BluetoothGatt gatt, int status) {
            if (status == 0) {
                Util.log(512, "onServicesDiscovered: OK");
                List gattServices = null;
                if (BT40Connection.this.mBluetoothGatt != null) {
                    gattServices = BT40Connection.this.mBluetoothGatt.getServices();
                }
                if (gattServices != null) {
                    for (BluetoothGattService gattService : gattServices) {
                        if (BT40Connection.UUID_HM_SPS.equals(gattService.getUuid().toString())) {
                            BT40Connection.this.characteristicTx = BT40Connection.this.characteristicRx = gattService.getCharacteristic(UUID.fromString(BT40Connection.UUID_HM_RX_TX));
                            BT40Connection.this.hardwareType = 1;
                        }
                        if (BT40Connection.UUID_NRF_SPS.equals(gattService.getUuid().toString())) {
                            BT40Connection.this.characteristicRx = gattService.getCharacteristic(UUID.fromString(BT40Connection.UUID_NRF_RX));
                            BT40Connection.this.characteristicTx = gattService.getCharacteristic(UUID.fromString(BT40Connection.UUID_NRF_TX));
                            BT40Connection.this.hardwareType = 2;
                        }
                        if (BT40Connection.this.characteristicRx == null || BT40Connection.this.characteristicTx == null) continue;
                        break;
                    }
                }
                if (BT40Connection.this.hardwareType == 1) {
                    Util.log(512, "Serial service discovered (HM type)");
                    boolean result2 = BT40Connection.this.mBluetoothGatt.setCharacteristicNotification(BT40Connection.this.characteristicRx, true);
                    Util.log(512, "setCharacteristicNotification: " + result2);
                    descriptor = BT40Connection.this.characteristicRx.getDescriptor(UUID.fromString("00002902-0000-1000-8000-00805f9b34fb"));
                    result2 = descriptor.setValue(BluetoothGattDescriptor.ENABLE_NOTIFICATION_VALUE);
                    Util.log(512, "setValue: " + result2);
                    result2 = BT40Connection.this.mBluetoothGatt.writeDescriptor(descriptor);
                    Util.log(512, "writeDescriptor: " + result2);
                    Util.log(512, "Descriptor UUID: " + descriptor.getUuid());
                } else if (BT40Connection.this.hardwareType == 2) {
                    Util.log(512, "Serial service discovered (DA type)");
                    boolean result3 = BT40Connection.this.mBluetoothGatt.setCharacteristicNotification(BT40Connection.this.characteristicRx, true);
                    Util.log(512, "setCharacteristicNotification: " + result3);
                    descriptor = BT40Connection.this.characteristicRx.getDescriptor(UUID.fromString("00002902-0000-1000-8000-00805f9b34fb"));
                    result3 = descriptor.setValue(BluetoothGattDescriptor.ENABLE_NOTIFICATION_VALUE);
                    Util.log(512, "setValue: " + result3);
                    result3 = BT40Connection.this.mBluetoothGatt.writeDescriptor(descriptor);
                    Util.log(512, "writeDescriptor: " + result3);
                    Util.log(512, "Descriptor UUID: " + descriptor.getUuid());
                } else {
                    Util.log(2048, "Serial service NOT found");
                    BT40Connection.this.mBTservice.connectionFailed(false, 264);
                }
            } else {
                Util.log(2048, "onServicesDiscovered: " + status);
            }
        }

        public void onDescriptorWrite(BluetoothGatt gatt, BluetoothGattDescriptor descriptor, int status) {
            Util.log(512, "onDescriptorWrite: " + status);
            BT40Connection.this.txBuffer = new LinkedList();
            BT40Connection.this.canSend = true;
            BT40Connection.this.lastRxTime = System.currentTimeMillis();
            BT40Connection.this.sendNext();
            BT40Connection.this.mBTservice.connectionEstablished();
        }

        public void onCharacteristicRead(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic, int status) {
            Util.log(512, "onCharacteristicRead: " + status);
            if (status == 0) {
                // empty if block
            }
        }

        public void onCharacteristicChanged(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic) {
            byte[] b = characteristic.getValue();
            if (b != null) {
                Util.log(1024, "onCharacteristicChanged (" + b.length + ")");
                boolean processedPacket = BT40Connection.this.mBTservice.onByteRx(b);
                if (processedPacket) {
                    BT40Connection.this.lastRxTime = System.currentTimeMillis();
                    BT40Connection.this.sendNext();
                }
            } else {
                Util.log(2048, "onCharacteristicChanged (null)");
            }
        }

        public void onCharacteristicWrite(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic, int status) {
            if (status == 0) {
                Util.log(1024, "onCharacteristicWrite: OK");
                BT40Connection.this.canSend = true;
                BT40Connection.this.sendNext();
            } else {
                Util.log(2048, "onCharacteristicWrite: " + status);
            }
        }
    };

    public BT40Connection(Application app, BTService btService, String mac, boolean reflections) {
        super(app, btService, mac, reflections);
        BluetoothManager bluetoothManager = (BluetoothManager)this.mCtx.getSystemService("bluetooth");
        this.mBluetoothAdapter = bluetoothManager.getAdapter();
        this.mStatusUpdateInterval = 0;
    }

    @Override
    @SuppressLint(value={"MissingPermission"})
    public void connect() {
        Util.log(256, "Connect (4.0)");
        BluetoothDevice device = this.mBluetoothAdapter.getRemoteDevice(this.mMac);
        if (device != null) {
            this.mBluetoothGatt = device.connectGatt(this.mCtx, false, this.mGattCallback);
            this.hardwareType = 0;
            this.isConnecting = true;
            this.handler = new Handler(Looper.getMainLooper());
            this.handler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    if (BT40Connection.this.isConnecting) {
                        BT40Connection.this.disconnect();
                        BT40Connection.this.mBTservice.connectionFailed(true, 257);
                    }
                }
            }, 10000L);
        } else {
            this.mBTservice.connectionFailed(false, 262);
        }
    }

    @Override
    @SuppressLint(value={"MissingPermission"})
    public void disconnect() {
        Util.log(256, "Disconnect (4.0)");
        this.txBuffer = null;
        try {
            if (this.mBluetoothGatt != null) {
                this.mBluetoothGatt.close();
                this.mBluetoothGatt.disconnect();
                this.mBluetoothGatt = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void setStatusUpdateInterval(int interval) {
        this.mStatusUpdateInterval = interval;
        this.lastRxTime = System.currentTimeMillis() - (long)this.mStatusUpdateInterval;
        Util.log(256, "Status Update Interval set to: " + interval);
        if (this.hardwareType == 2) {
            this.mStatusUpdateInterval = 0;
        }
    }

    @Override
    public void write(byte[] out) {
        int offset = 0;
        if (Util.flashingToolMode) {
            if (out.length == 1) {
                this.txBuffer.add(out);
                this.sendNext();
                return;
            }
            if (out.length == 1026) {
                byte[] tmp = new byte[]{out[0], out[1]};
                this.txBuffer.add(tmp);
                offset = 2;
                for (int i = 0; i < 64; ++i) {
                    tmp = new byte[16];
                    System.arraycopy(out, offset, tmp, 0, 16);
                    offset += 16;
                    this.txBuffer.add(tmp);
                }
                this.sendNext();
                return;
            }
        }
        if (out.length == 2) {
            this.addHeader(out);
        } else if (out.length == 20) {
            this.addHMAC(out);
        } else {
            int loops = out.length / 16;
            offset = 0;
            for (int i = 0; i < loops; ++i) {
                byte[] tmp = new byte[16];
                System.arraycopy(out, offset, tmp, 0, 16);
                offset += 16;
                this.addData16(tmp);
            }
            this.sendNext();
        }
    }

    private synchronized void addHeader(byte[] data) {
        this.h0 = data[0];
        this.h1 = data[1];
        this.header = true;
    }

    private synchronized void addHMAC(byte[] data) {
        if (this.txBuffer != null) {
            this.txBuffer.add(data);
        }
    }

    private synchronized void addData16(byte[] data) {
        int offset = 0;
        if (this.txBuffer != null) {
            byte[] tmp;
            if (this.header) {
                this.header = false;
                tmp = new byte[18];
                offset = 2;
                tmp[0] = this.h0;
                tmp[1] = this.h1;
            } else {
                tmp = new byte[16];
                offset = 0;
            }
            System.arraycopy(data, 0, tmp, offset, 16);
            this.txBuffer.add(tmp);
        }
    }

    private synchronized byte[] getData() {
        if (this.txBuffer != null && !this.txBuffer.isEmpty()) {
            byte[] data = this.txBuffer.poll();
            return data;
        }
        return null;
    }

    @SuppressLint(value={"MissingPermission"})
    private synchronized void sendNext() {
        long time = System.currentTimeMillis();
        if (this.mStatusUpdateInterval > 0 && time > this.lastRxTime + (long)this.mStatusUpdateInterval - 45L) {
            return;
        }
        if (this.canSend) {
            byte[] data = this.getData();
            if (data != null) {
                this.canSend = false;
                boolean r1 = false;
                boolean r2 = false;
                r1 = this.characteristicTx.setValue(data);
                this.characteristicTx.setWriteType(1);
                r2 = this.mBluetoothGatt.writeCharacteristic(this.characteristicTx);
                Util.log(1024, "sendNext: " + r1 + " / " + r2);
            } else {
                Util.log(1024, "sendNext: no data to send");
            }
        }
    }
}

