/*
 * Decompiled with CFR 0.152.
 */
package com.inputstick.api.bluetooth;

import android.app.Application;
import android.bluetooth.BluetoothAdapter;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Build;
import android.os.Handler;
import android.os.Message;
import com.inputstick.api.Util;
import com.inputstick.api.bluetooth.BT20Connection;
import com.inputstick.api.bluetooth.BT40Connection;
import com.inputstick.api.bluetooth.BTConnection;
import com.inputstick.api.bluetooth.PacketReader;

public class BTService {
    public static final int DEFAULT_CONNECT_TIMEOUT = 30000;
    public static final int EVENT_NONE = 0;
    public static final int EVENT_DATA = 1;
    public static final int EVENT_CONNECTED = 2;
    public static final int EVENT_CANCELLED = 3;
    public static final int EVENT_ERROR = 4;
    private final Handler mHandler;
    private int mLastEvent = 0;
    private String mMac;
    private final Application mApp;
    private final Context mCtx;
    private boolean mUseReflection;
    private int mConnectTimeout;
    private long timeout;
    private int retryCnt;
    private boolean disconnecting;
    private boolean connected;
    private PacketReader mPacketReader;
    private BTConnection mBTConnection;
    private boolean turnBluetoothOn;
    private boolean receiverRegistered;
    private Handler mDelayHandler = new Handler();
    private final BroadcastReceiver mReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            int state;
            String action = intent.getAction();
            if (action.equals("android.bluetooth.adapter.action.STATE_CHANGED") && (state = intent.getIntExtra("android.bluetooth.adapter.extra.STATE", Integer.MIN_VALUE)) == 12 && BTService.this.turnBluetoothOn) {
                BTService.this.turnBluetoothOn = false;
                BTService.this.mDelayHandler.removeCallbacksAndMessages(null);
                BTService.this.mDelayHandler.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        BTService.this.doConnect(false);
                    }
                }, 250L);
            }
        }
    };

    public BTService(Application app, Handler handler) {
        this.mHandler = handler;
        this.mApp = app;
        this.mCtx = app.getApplicationContext();
        this.mConnectTimeout = 30000;
    }

    public void setConnectTimeout(int timeout) {
        this.mConnectTimeout = timeout;
    }

    public void enableReflection(boolean enabled) {
        this.mUseReflection = enabled;
    }

    public void setStatusUpdateInterval(int interval) {
        if (this.connected) {
            this.mBTConnection.setStatusUpdateInterval(interval);
        }
    }

    protected synchronized void event(int event, int arg1) {
        Util.log(4096, "event() " + this.mLastEvent + " -> " + event);
        this.mLastEvent = event;
        Message msg = Message.obtain(null, (int)this.mLastEvent, (int)arg1, (int)0);
        this.mHandler.sendMessage(msg);
    }

    public synchronized int getLastEvent() {
        return this.mLastEvent;
    }

    private void doConnect(boolean reconnecting) {
        if (reconnecting) {
            ++this.retryCnt;
        } else {
            this.retryCnt = 0;
            this.timeout = System.currentTimeMillis() + (long)this.mConnectTimeout;
        }
        this.mBTConnection.connect();
    }

    public synchronized void connect(String mac) {
        this.connect(mac, false);
    }

    public synchronized void connect(String mac, boolean doNotAsk) {
        this.connect(mac, doNotAsk, false);
    }

    public synchronized void connect(String mac, boolean doNotAsk, boolean bt40) {
        try {
            Util.log(4096, "connect to: " + mac + " REFLECTION: " + this.mUseReflection);
            this.disconnecting = false;
            this.connected = false;
            this.mMac = mac;
            if (BluetoothAdapter.checkBluetoothAddress((String)mac)) {
                BluetoothAdapter mBluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
                if (mBluetoothAdapter == null) {
                    this.event(4, 259);
                } else {
                    this.mBTConnection = bt40 ? new BT40Connection(this.mApp, this, this.mMac, this.mUseReflection) : new BT20Connection(this.mApp, this, this.mMac, this.mUseReflection);
                    if (mBluetoothAdapter.isEnabled()) {
                        this.doConnect(false);
                    } else if (this.mApp != null) {
                        this.turnBluetoothOn = true;
                        if (!this.receiverRegistered) {
                            IntentFilter filter2 = new IntentFilter("android.bluetooth.adapter.action.STATE_CHANGED");
                            this.mCtx.registerReceiver(this.mReceiver, filter2);
                            this.receiverRegistered = true;
                        }
                        if (doNotAsk) {
                            BluetoothAdapter.getDefaultAdapter().enable();
                        } else {
                            Intent enableBtIntent = new Intent("android.bluetooth.adapter.action.REQUEST_ENABLE");
                            enableBtIntent.setFlags(0x10000000);
                            this.mApp.startActivity(enableBtIntent);
                            this.mDelayHandler.postDelayed(new Runnable(){

                                @Override
                                public void run() {
                                    BTService.this.event(4, 265);
                                }
                            }, (long)(this.mConnectTimeout - 500));
                        }
                    }
                }
            } else {
                this.event(4, 260);
            }
        }
        catch (NoClassDefFoundError e) {
            this.event(4, 263);
        }
    }

    public synchronized void disconnect() {
        Util.log(4096, "disconnect");
        this.mDelayHandler.removeCallbacksAndMessages(null);
        this.removeReceiver();
        this.disconnecting = true;
        if (this.mBTConnection != null) {
            this.mBTConnection.disconnect();
        }
        this.event(3, 0);
    }

    public synchronized void write(byte[] out) {
        if (this.connected) {
            this.mBTConnection.write(out);
        }
    }

    protected synchronized void connectionEstablished() {
        this.mDelayHandler.removeCallbacksAndMessages(null);
        this.removeReceiver();
        this.mPacketReader = new PacketReader(this, this.mHandler);
        this.timeout = 0L;
        this.connected = true;
        this.event(2, 0);
    }

    protected void connectionFailed(boolean canRetry, int errorCode) {
        this.mDelayHandler.removeCallbacksAndMessages(null);
        this.removeReceiver();
        this.connected = false;
        if (this.disconnecting) {
            this.disconnecting = false;
        } else if (canRetry) {
            if (this.timeout > 0L && System.currentTimeMillis() < this.timeout) {
                Util.log(4096, "RETRY: " + this.retryCnt + " time left: " + (this.timeout - System.currentTimeMillis()));
                this.doConnect(true);
            } else {
                this.event(4, 257);
            }
        } else {
            this.event(4, errorCode);
        }
    }

    protected synchronized void onByteRx(int rxByte) {
        this.mPacketReader.rxByte((byte)rxByte);
    }

    protected synchronized boolean onByteRx(byte[] rxBytes) {
        boolean result2 = false;
        for (int i = 0; i < rxBytes.length; ++i) {
            if (!this.mPacketReader.rxByte(rxBytes[i])) continue;
            result2 = true;
        }
        return result2;
    }

    private void removeReceiver() {
        if (this.receiverRegistered) {
            this.mCtx.unregisterReceiver(this.mReceiver);
            this.receiverRegistered = false;
        }
    }

    public static boolean isBT40Supported() {
        return Build.VERSION.SDK_INT < 18;
    }
}

