/*
 * Decompiled with CFR 0.152.
 */
package com.inputstick.api.bluetooth;

import android.os.Handler;
import com.inputstick.api.Util;
import com.inputstick.api.bluetooth.BTService;

public class PacketReader {
    private static final int RX_TIMEOUT = 3000;
    private static final int RX_TAG = 0;
    private static final int RX_LENGTH = 1;
    private static final int RX_DATA = 2;
    private long lastRxTime;
    private int rxState;
    private int rxPos;
    private int rxLength;
    private byte[] rxData;
    private int rxWdgCnt;
    private final BTService mBTService;
    private final Handler mHandler;

    public PacketReader(BTService btService, Handler handler) {
        this.mBTService = btService;
        this.mHandler = handler;
    }

    public boolean rxByte(byte b) {
        boolean result2 = false;
        long time = System.currentTimeMillis();
        if (time > this.lastRxTime + 3000L) {
            this.rxState = 0;
        }
        switch (this.rxState) {
            case 0: {
                if (b == 85) {
                    this.rxState = 1;
                    break;
                }
                Util.log(2048, "Unexpected byte (" + b + ")");
                if (b == 175) {
                    ++this.rxWdgCnt;
                }
                if (this.rxWdgCnt <= 1024) break;
                this.rxWdgCnt = 0;
                this.mBTService.event(4, 513);
                break;
            }
            case 1: {
                this.rxLength = b;
                this.rxLength &= 0x3F;
                this.rxLength *= 16;
                this.rxLength += 2;
                this.rxPos = 2;
                this.rxData = new byte[this.rxLength];
                this.rxData[0] = 85;
                this.rxData[1] = b;
                this.rxState = 2;
                break;
            }
            case 2: {
                if (this.rxPos < this.rxLength) {
                    this.rxData[this.rxPos] = b;
                    ++this.rxPos;
                    if (this.rxPos != this.rxLength) break;
                    Util.log(1024, "Received (" + this.rxLength + "B)");
                    this.mHandler.obtainMessage(1, 0, 0, (Object)this.rxData).sendToTarget();
                    this.rxState = 0;
                    result2 = true;
                    break;
                }
                Util.log(2048, "Buffer overrun");
                this.rxState = 0;
            }
        }
        this.lastRxTime = time;
        return result2;
    }
}

