/*
 * Decompiled with CFR 0.152.
 */
package com.inputstick.api.hid;

import android.util.SparseArray;

public class HIDKeycodes {
    public static final byte NONE = 0;
    public static final byte CTRL_LEFT = 1;
    public static final byte SHIFT_LEFT = 2;
    public static final byte ALT_LEFT = 4;
    public static final byte GUI_LEFT = 8;
    public static final byte CTRL_RIGHT = 16;
    public static final byte SHIFT_RIGHT = 32;
    public static final byte ALT_RIGHT = 64;
    public static final byte GUI_RIGHT = -128;
    public static final byte KEY_ENTER = 40;
    public static final byte KEY_ESCAPE = 41;
    public static final byte KEY_BACKSPACE = 42;
    public static final byte KEY_TAB = 43;
    public static final byte KEY_SPACEBAR = 44;
    public static final byte KEY_CAPS_LOCK = 57;
    public static final byte KEY_1 = 30;
    public static final byte KEY_2 = 31;
    public static final byte KEY_3 = 32;
    public static final byte KEY_4 = 33;
    public static final byte KEY_5 = 34;
    public static final byte KEY_6 = 35;
    public static final byte KEY_7 = 36;
    public static final byte KEY_8 = 37;
    public static final byte KEY_9 = 38;
    public static final byte KEY_0 = 39;
    public static final byte KEY_F1 = 58;
    public static final byte KEY_F2 = 59;
    public static final byte KEY_F3 = 60;
    public static final byte KEY_F4 = 61;
    public static final byte KEY_F5 = 62;
    public static final byte KEY_F6 = 63;
    public static final byte KEY_F7 = 64;
    public static final byte KEY_F8 = 65;
    public static final byte KEY_F9 = 66;
    public static final byte KEY_F10 = 67;
    public static final byte KEY_F11 = 68;
    public static final byte KEY_F12 = 69;
    public static final byte KEY_PRINT_SCREEN = 70;
    public static final byte KEY_SCROLL_LOCK = 71;
    public static final byte KEY_PASUE = 72;
    public static final byte KEY_INSERT = 73;
    public static final byte KEY_HOME = 74;
    public static final byte KEY_PAGE_UP = 75;
    public static final byte KEY_DELETE = 76;
    public static final byte KEY_END = 77;
    public static final byte KEY_PAGE_DOWN = 78;
    public static final byte KEY_ARROW_RIGHT = 79;
    public static final byte KEY_ARROW_LEFT = 80;
    public static final byte KEY_ARROW_DOWN = 81;
    public static final byte KEY_ARROW_UP = 82;
    public static final byte KEY_NUM_LOCK = 83;
    public static final byte KEY_NUM_SLASH = 84;
    public static final byte KEY_NUM_STAR = 85;
    public static final byte KEY_NUM_MINUS = 86;
    public static final byte KEY_NUM_PLUS = 87;
    public static final byte KEY_NUM_ENTER = 88;
    public static final byte KEY_NUM_1 = 89;
    public static final byte KEY_NUM_2 = 90;
    public static final byte KEY_NUM_3 = 91;
    public static final byte KEY_NUM_4 = 92;
    public static final byte KEY_NUM_5 = 93;
    public static final byte KEY_NUM_6 = 94;
    public static final byte KEY_NUM_7 = 95;
    public static final byte KEY_NUM_8 = 96;
    public static final byte KEY_NUM_9 = 97;
    public static final byte KEY_NUM_0 = 98;
    public static final byte KEY_NUM_DOT = 99;
    public static final byte KEY_BACKSLASH_NON_US = 100;
    public static final byte KEY_A = 4;
    public static final byte KEY_B = 5;
    public static final byte KEY_C = 6;
    public static final byte KEY_D = 7;
    public static final byte KEY_E = 8;
    public static final byte KEY_F = 9;
    public static final byte KEY_G = 10;
    public static final byte KEY_H = 11;
    public static final byte KEY_I = 12;
    public static final byte KEY_J = 13;
    public static final byte KEY_K = 14;
    public static final byte KEY_L = 15;
    public static final byte KEY_M = 16;
    public static final byte KEY_N = 17;
    public static final byte KEY_O = 18;
    public static final byte KEY_P = 19;
    public static final byte KEY_Q = 20;
    public static final byte KEY_R = 21;
    public static final byte KEY_S = 22;
    public static final byte KEY_T = 23;
    public static final byte KEY_U = 24;
    public static final byte KEY_V = 25;
    public static final byte KEY_W = 26;
    public static final byte KEY_X = 27;
    public static final byte KEY_Y = 28;
    public static final byte KEY_Z = 29;
    public static final byte KEY_MINUS = 45;
    public static final byte KEY_EQUALS = 46;
    public static final byte KEY_LEFT_BRACKET = 47;
    public static final byte KEY_RIGHT_BRACKET = 48;
    public static final byte KEY_BACKSLASH = 49;
    public static final byte KEY_SEMICOLON = 51;
    public static final byte KEY_APOSTROPHE = 52;
    public static final byte KEY_GRAVE = 53;
    public static final byte KEY_COMA = 54;
    public static final byte KEY_DOT = 55;
    public static final byte KEY_SLASH = 56;
    public static final byte KEY_APPLICATION = 101;
    public static final SparseArray<String> modifiersMap = new SparseArray();
    public static final SparseArray<String> keyMap;
    public static final int[] ASCIItoHID;

    public static char getChar(byte keyCode) {
        for (int i = 0; i < ASCIItoHID.length; ++i) {
            if (ASCIItoHID[i] != keyCode) continue;
            return (char)i;
        }
        return '\u0000';
    }

    public static byte getKeyCode(char c) {
        return (byte)ASCIItoHID[c];
    }

    public static int getKeyCode(int c) {
        return ASCIItoHID[c];
    }

    public static String modifiersToString(byte modifiers) {
        String result2 = "None";
        boolean first2 = true;
        for (int i = 0; i < 8; ++i) {
            byte mod = (byte)(1 << i);
            if ((modifiers & mod) == 0) continue;
            result2 = !first2 ? result2 + ", " : "";
            first2 = false;
            result2 = result2 + (String)modifiersMap.get((int)mod);
        }
        return result2;
    }

    public static String keyToString(byte key) {
        String result2 = (String)keyMap.get((int)key);
        if (result2 == null) {
            result2 = "Unknown";
        }
        return result2;
    }

    static {
        modifiersMap.put(1, (Object)"Left Ctrl");
        modifiersMap.put(2, (Object)"Left Shift");
        modifiersMap.put(4, (Object)"Left Alt");
        modifiersMap.put(8, (Object)"Left GUI");
        modifiersMap.put(16, (Object)"Right Ctrl");
        modifiersMap.put(32, (Object)"Right Shift");
        modifiersMap.put(64, (Object)"Right Alt");
        modifiersMap.put(-128, (Object)"Right GUI");
        keyMap = new SparseArray();
        keyMap.put(0, (Object)"None");
        keyMap.put(40, (Object)"Enter");
        keyMap.put(41, (Object)"Esc");
        keyMap.put(42, (Object)"Backspace");
        keyMap.put(43, (Object)"Tab");
        keyMap.put(44, (Object)"Space");
        keyMap.put(57, (Object)"CapsLock");
        keyMap.put(30, (Object)"1");
        keyMap.put(31, (Object)"2");
        keyMap.put(32, (Object)"3");
        keyMap.put(33, (Object)"4");
        keyMap.put(34, (Object)"5");
        keyMap.put(35, (Object)"6");
        keyMap.put(36, (Object)"7");
        keyMap.put(37, (Object)"8");
        keyMap.put(38, (Object)"9");
        keyMap.put(39, (Object)"0");
        keyMap.put(58, (Object)"F1");
        keyMap.put(59, (Object)"F2");
        keyMap.put(60, (Object)"F3");
        keyMap.put(61, (Object)"F4");
        keyMap.put(62, (Object)"F5");
        keyMap.put(63, (Object)"F6");
        keyMap.put(64, (Object)"F7");
        keyMap.put(65, (Object)"F8");
        keyMap.put(66, (Object)"F9");
        keyMap.put(67, (Object)"F10");
        keyMap.put(68, (Object)"F11");
        keyMap.put(69, (Object)"F12");
        keyMap.put(70, (Object)"Print Scrn");
        keyMap.put(71, (Object)"ScrollLock");
        keyMap.put(72, (Object)"Pause Break");
        keyMap.put(73, (Object)"Insert");
        keyMap.put(74, (Object)"Home");
        keyMap.put(75, (Object)"PageUp");
        keyMap.put(76, (Object)"Delete");
        keyMap.put(77, (Object)"End");
        keyMap.put(78, (Object)"PageDown");
        keyMap.put(79, (Object)"Right Arrow");
        keyMap.put(80, (Object)"Left Arrow");
        keyMap.put(81, (Object)"Down Arrow");
        keyMap.put(82, (Object)"Up Arrow");
        keyMap.put(83, (Object)"NumLock");
        keyMap.put(84, (Object)"Num /");
        keyMap.put(85, (Object)"Num *");
        keyMap.put(86, (Object)"Num -");
        keyMap.put(87, (Object)"Num +");
        keyMap.put(88, (Object)"Num Enter");
        keyMap.put(89, (Object)"Num 1");
        keyMap.put(90, (Object)"Num 2");
        keyMap.put(91, (Object)"Num 3");
        keyMap.put(92, (Object)"Num 4");
        keyMap.put(93, (Object)"Num 5");
        keyMap.put(94, (Object)"Num 6");
        keyMap.put(95, (Object)"Num 7");
        keyMap.put(96, (Object)"Num 8");
        keyMap.put(97, (Object)"Num 9");
        keyMap.put(98, (Object)"Num 0");
        keyMap.put(99, (Object)"Num .");
        keyMap.put(4, (Object)"A");
        keyMap.put(5, (Object)"B");
        keyMap.put(6, (Object)"C");
        keyMap.put(7, (Object)"D");
        keyMap.put(8, (Object)"E");
        keyMap.put(9, (Object)"F");
        keyMap.put(10, (Object)"G");
        keyMap.put(11, (Object)"H");
        keyMap.put(12, (Object)"I");
        keyMap.put(13, (Object)"J");
        keyMap.put(14, (Object)"K");
        keyMap.put(15, (Object)"L");
        keyMap.put(16, (Object)"M");
        keyMap.put(17, (Object)"N");
        keyMap.put(18, (Object)"O");
        keyMap.put(19, (Object)"P");
        keyMap.put(20, (Object)"Q");
        keyMap.put(21, (Object)"R");
        keyMap.put(22, (Object)"S");
        keyMap.put(23, (Object)"T");
        keyMap.put(24, (Object)"U");
        keyMap.put(25, (Object)"V");
        keyMap.put(26, (Object)"W");
        keyMap.put(27, (Object)"X");
        keyMap.put(28, (Object)"Y");
        keyMap.put(29, (Object)"Z");
        keyMap.put(45, (Object)"-");
        keyMap.put(46, (Object)"=");
        keyMap.put(47, (Object)"[");
        keyMap.put(48, (Object)"]");
        keyMap.put(49, (Object)"\\");
        keyMap.put(51, (Object)";");
        keyMap.put(52, (Object)"'");
        keyMap.put(53, (Object)"`");
        keyMap.put(54, (Object)",");
        keyMap.put(55, (Object)".");
        keyMap.put(56, (Object)"/");
        keyMap.put(101, (Object)"Application");
        ASCIItoHID = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 44, 158, 180, 160, 161, 162, 164, 52, 166, 167, 165, 174, 54, 45, 55, 56, 39, 30, 31, 32, 33, 34, 35, 36, 37, 38, 179, 51, 182, 46, 183, 184, 159, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 47, 49, 48, 163, 173, 181, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 175, 177, 176, 181, 0};
    }
}

