/*
 * Decompiled with CFR 0.152.
 */
package com.inputstick.api.hid;

import com.inputstick.api.ConnectionManager;
import com.inputstick.api.HIDInfo;
import com.inputstick.api.Packet;
import com.inputstick.api.basic.InputStickHID;
import com.inputstick.api.hid.HIDTransaction;
import java.util.LinkedList;

public class HIDTransactionQueue {
    private static final int DEFAULT_BUFFER_SIZE = 32;
    private static final int DEFAULT_MAX_REPORTS_PER_PACKET = 32;
    private final LinkedList<HIDTransaction> queue;
    private final ConnectionManager mConnectionManager;
    private final byte cmd;
    private int mBufferCapacity;
    private int mFreeSpace;
    private int mSentSinceLastNotification;
    private int mMaxReportsPerPacket;
    private int mInterfaceType;
    private int mBufferEmptyCnt;

    public HIDTransactionQueue(int interfaceType, ConnectionManager connectionManager, int bufferCapacity, int maxReportsPerPacket) {
        this.mBufferCapacity = bufferCapacity;
        this.mFreeSpace = bufferCapacity;
        this.mMaxReportsPerPacket = maxReportsPerPacket;
        this.mSentSinceLastNotification = 0;
        this.queue = new LinkedList();
        this.mConnectionManager = connectionManager;
        this.mInterfaceType = interfaceType;
        switch (interfaceType) {
            case 0: {
                this.cmd = (byte)33;
                break;
            }
            case 2: {
                this.cmd = (byte)35;
                break;
            }
            case 1: {
                this.cmd = (byte)34;
                break;
            }
            case 3: {
                this.cmd = (byte)39;
                break;
            }
            default: {
                this.cmd = (byte)-1;
            }
        }
    }

    public HIDTransactionQueue(int interfaceType, ConnectionManager connectionManager) {
        this(interfaceType, connectionManager, 32, 32);
    }

    public synchronized void setCapacity(int capacity) {
        int diff = capacity - this.mBufferCapacity;
        this.mBufferCapacity += diff;
        this.mFreeSpace += diff;
    }

    public synchronized void update(HIDInfo hidInfo) {
        int freedSpace = 0;
        boolean bufferEmpty = false;
        switch (this.mInterfaceType) {
            case 0: {
                freedSpace = hidInfo.getKeyboardReportsSentToHost();
                bufferEmpty = hidInfo.isKeyboardReady();
                break;
            }
            case 2: {
                freedSpace = hidInfo.getMouseReportsSentToHost();
                bufferEmpty = hidInfo.isMouseReady();
                break;
            }
            case 1: {
                freedSpace = hidInfo.getConsumerReportsSentToHost();
                bufferEmpty = hidInfo.isConsumerReady();
                break;
            }
            case 3: {
                freedSpace = hidInfo.getRawHIDReportsSentToHost();
                bufferEmpty = hidInfo.isRawHIDReady();
            }
        }
        this.mFreeSpace += freedSpace;
        if (this.mFreeSpace > this.mBufferCapacity) {
            this.mFreeSpace = this.mBufferCapacity;
        }
        if (bufferEmpty) {
            ++this.mBufferEmptyCnt;
            if (this.mBufferEmptyCnt == 10) {
                this.mFreeSpace = this.mBufferCapacity;
            }
        } else {
            this.mBufferEmptyCnt = 0;
        }
        if (this.queue.isEmpty()) {
            if (this.mFreeSpace == this.mBufferCapacity && this.mSentSinceLastNotification != 0) {
                this.mSentSinceLastNotification = 0;
                this.notifyOnRemoteBufferEmpty();
            }
        } else {
            this.sendFromQueue();
        }
    }

    public synchronized void sendFromQueue() {
        boolean didSend;
        do {
            byte transactionCmd;
            didSend = false;
            if (this.queue.isEmpty() || this.mFreeSpace <= 0) continue;
            byte reports = 0;
            int remainingReports = this.mFreeSpace > this.mMaxReportsPerPacket ? this.mMaxReportsPerPacket : this.mFreeSpace;
            Packet p = new Packet(false, this.cmd, reports);
            HIDTransaction transaction = this.queue.peek();
            byte firstTransactionCmd = transaction.getTransactionTypeCmd();
            while ((transaction = this.queue.peek()) != null && (transactionCmd = transaction.getTransactionTypeCmd()) == firstTransactionCmd && transaction.getReportsCount() <= remainingReports) {
                remainingReports -= transaction.getReportsCount();
                reports = (byte)(reports + transaction.getReportsCount());
                while (transaction.hasNext()) {
                    p.addBytes(transaction.getNextReport());
                }
                this.queue.removeFirst();
            }
            if (reports > 0) {
                if (firstTransactionCmd != 0) {
                    p.modifyByte(0, firstTransactionCmd);
                }
                p.modifyByte(1, reports);
                this.mConnectionManager.sendPacket(p);
                this.mFreeSpace -= reports;
                this.mSentSinceLastNotification += reports;
            }
            if (this.queue.isEmpty()) {
                this.notifyOnLocalBufferEmpty();
            }
            if (reports <= 0) continue;
            didSend = true;
        } while (didSend);
    }

    public synchronized void addTransaction(HIDTransaction transaction, boolean sendNow) {
        while (transaction.getReportsCount() > this.mMaxReportsPerPacket) {
            HIDTransaction t = transaction.split(this.mMaxReportsPerPacket);
            this.queue.add(t);
        }
        this.queue.add(transaction);
        if (sendNow) {
            this.sendFromQueue();
        }
    }

    private void notifyOnRemoteBufferEmpty() {
        InputStickHID.sendEmptyBufferNotifications(1, this.mInterfaceType);
    }

    private void notifyOnLocalBufferEmpty() {
        InputStickHID.sendEmptyBufferNotifications(2, this.mInterfaceType);
    }

    public synchronized boolean isLocalBufferEmpty() {
        return this.queue.isEmpty();
    }

    public synchronized boolean isRemoteBufferEmpty() {
        return this.queue.isEmpty() && this.mFreeSpace == this.mBufferCapacity;
    }

    public synchronized void clearBuffer() {
        this.queue.clear();
    }
}

