/*
 * Decompiled with CFR 0.152.
 */
package com.inputstick.api.init;

import android.os.Handler;
import com.inputstick.api.Packet;
import com.inputstick.api.init.InitManager;

public class BasicInitManager
extends InitManager {
    private int lastStatusParam = 0;
    private Handler handler;
    private boolean cancelled;
    private boolean doNotSetUpdateInterval;

    public BasicInitManager(byte[] key) {
        super(key);
    }

    @Override
    public void onConnected() {
        this.lastStatusParam = 0;
        this.cancelled = false;
        this.initDone = false;
        this.sendPacket(new Packet(true, 4));
        this.handler = new Handler();
        this.handler.postDelayed(new Runnable(){

            @Override
            public void run() {
                if (!BasicInitManager.this.cancelled && !BasicInitManager.this.initDone) {
                    BasicInitManager.this.sendPacket(new Packet(true, 4));
                }
            }
        }, 1000L);
        this.handler.postDelayed(new Runnable(){

            @Override
            public void run() {
                if (!BasicInitManager.this.cancelled && !BasicInitManager.this.initDone) {
                    BasicInitManager.this.mListener.onInitFailure(1026);
                }
            }
        }, 2000L);
    }

    @Override
    public void onDisconnected() {
        this.cancelled = true;
    }

    @Override
    public void onData(byte[] data) {
        byte cmd = data[0];
        byte respCode = data[1];
        int param = data[1];
        switch (cmd) {
            case 4: {
                this.sendPacket(new Packet(true, 16));
                break;
            }
            case 16: {
                this.onFWInfo(data, true, true, new Packet(true, 17));
                break;
            }
            case 17: {
                if (respCode == 1) {
                    this.initDone = true;
                    if (this.mInfo.getFirmwareVersion() >= 100) {
                        this.sendPacket(new Packet(true, 49, 5));
                        break;
                    }
                    if (this.doNotSetUpdateInterval) break;
                    this.setStatusUpdateInterval(100);
                    break;
                }
                this.mListener.onInitFailure(respCode);
                break;
            }
            case 49: {
                if (respCode != 1) break;
                this.setStatusUpdateInterval(500);
                break;
            }
            case 18: 
            case 48: {
                this.initDone = this.onAuth(data, true, new Packet(true, 17));
                break;
            }
            case 47: {
                if (this.mKey == null) {
                    this.initDone = true;
                }
                if (!this.initDone || param == this.lastStatusParam) break;
                this.lastStatusParam = param;
                if (param == 5) {
                    this.mListener.onInitReady();
                    break;
                }
                this.mListener.onInitNotReady();
            }
        }
    }

    public void disableStatusUpdateInterval() {
        this.doNotSetUpdateInterval = true;
    }
}

