/*
 * Decompiled with CFR 0.152.
 */
package com.inputstick.api.init;

public class DeviceInfo {
    private int firmwareType;
    private int versionMajor;
    private int versionMinor;
    private int versionHardware;
    private int securityStatus;
    private boolean passwordProtected;

    public DeviceInfo(byte[] data) {
        if (data != null) {
            if (data.length > 5) {
                this.firmwareType = data[2];
                this.versionMajor = data[3];
                this.versionMinor = data[4];
                this.versionHardware = data[5];
            }
            if (data.length > 20) {
                this.securityStatus = data[19];
                this.passwordProtected = data[20] != 0;
            }
        }
    }

    public int getSecurityStatus() {
        return this.securityStatus;
    }

    public boolean isAuthenticated() {
        return (this.securityStatus & 0x10) != 0;
    }

    public boolean isUnlocked() {
        if (this.getFirmwareVersion() < 96) {
            return true;
        }
        return (this.securityStatus & 8) != 0;
    }

    public int getFirmwareType() {
        return this.firmwareType;
    }

    public boolean isPasswordProtected() {
        return this.passwordProtected;
    }

    public int getVersionMinor() {
        return this.versionMinor;
    }

    public int getVersionMajor() {
        return this.versionMajor;
    }

    public int getHardwareVersion() {
        return this.versionHardware;
    }

    public int getFirmwareVersion() {
        return this.versionMajor * 100 + this.versionMinor;
    }

    public boolean supportsEncryption() {
        return this.getFirmwareVersion() >= 91;
    }

    public boolean supportsPinChange() {
        return this.getFirmwareVersion() >= 97;
    }

    public boolean supportsGamepad() {
        return this.getFirmwareVersion() >= 97;
    }

    public boolean supportsRestoreOptions() {
        return this.getFirmwareVersion() >= 98;
    }
}

