/*
 * Decompiled with CFR 0.152.
 */
package com.inputstick.api.init;

import com.inputstick.api.Packet;
import com.inputstick.api.PacketManager;
import com.inputstick.api.init.DeviceInfo;
import com.inputstick.api.init.InitManagerListener;

public class InitManager {
    public static final int DEFAULT_INIT_TIMEOUT = 60000;
    protected PacketManager mPacketManager;
    protected InitManagerListener mListener;
    protected byte[] mKey;
    protected DeviceInfo mInfo;
    protected boolean initDone;

    public InitManager(byte[] key) {
        this.mKey = key;
    }

    public DeviceInfo getDeviceInfo() {
        return this.mInfo;
    }

    public boolean isEncrypted() {
        return this.mPacketManager.isEncrypted();
    }

    public void init(InitManagerListener listener2, PacketManager packetManager) {
        this.mListener = listener2;
        this.mPacketManager = packetManager;
        this.initDone = false;
    }

    public void onConnected() {
        this.mListener.onInitReady();
    }

    public void onDisconnected() {
    }

    public void onData(byte[] data) {
    }

    public void sendPacket(Packet p) {
        this.mPacketManager.sendPacket(p);
    }

    public void setStatusUpdateInterval(int interval) {
        this.mPacketManager.setStatusUpdateInterval(interval);
    }

    public void onFWInfo(byte[] data, boolean authenticate, boolean enableEncryption, Packet sendNext) {
        this.mInfo = new DeviceInfo(data);
        if (authenticate) {
            if (this.mInfo.isPasswordProtected()) {
                if (this.mKey != null) {
                    boolean hmac = this.mInfo.getFirmwareVersion() >= 100;
                    this.sendPacket(this.mPacketManager.encPacket(enableEncryption, hmac));
                } else {
                    this.mListener.onInitFailure(1282);
                }
            } else {
                if (this.mKey != null) {
                    this.mListener.onInitFailure(1285);
                }
                this.sendPacket(sendNext);
            }
        } else {
            this.sendPacket(sendNext);
        }
    }

    public boolean onAuth(byte[] data, boolean enableOutEncryption, Packet sendNext) {
        byte respCode = data[1];
        switch (respCode) {
            case 1: {
                byte[] cmp = new byte[16];
                byte[] hmacKey = null;
                System.arraycopy(data, 2, cmp, 0, 16);
                if (this.mInfo.getFirmwareVersion() >= 100) {
                    hmacKey = new byte[32];
                    System.arraycopy(data, 18, hmacKey, 0, 32);
                }
                if (this.mPacketManager.setEncryption(cmp, enableOutEncryption, hmacKey)) {
                    this.sendPacket(sendNext);
                    return true;
                }
                this.mListener.onInitFailure(1284);
                break;
            }
            case 32: {
                this.mListener.onInitFailure(1283);
                break;
            }
            case 33: {
                this.mListener.onInitFailure(1285);
                break;
            }
            case -1: {
                this.mListener.onInitFailure(1281);
                break;
            }
            default: {
                this.mListener.onInitFailure(1280);
            }
        }
        return false;
    }
}

