/*
 * Decompiled with CFR 0.152.
 */
package com.inputstick.api.layout;

import com.inputstick.api.basic.InputStickHID;
import com.inputstick.api.hid.HIDTransaction;
import com.inputstick.api.hid.ShortKeyboardReport;
import com.inputstick.api.layout.BelgianLayout;
import com.inputstick.api.layout.CanadianFrenchLayout;
import com.inputstick.api.layout.CroatianLayout;
import com.inputstick.api.layout.CzechLayout;
import com.inputstick.api.layout.CzechLinuxLayout;
import com.inputstick.api.layout.CzechProgrammersLayout;
import com.inputstick.api.layout.DanishLayout;
import com.inputstick.api.layout.DutchLayout;
import com.inputstick.api.layout.DvorakLayout;
import com.inputstick.api.layout.FinnishLayout;
import com.inputstick.api.layout.FrenchLayout;
import com.inputstick.api.layout.FrenchLinuxLayout;
import com.inputstick.api.layout.GermanLayout;
import com.inputstick.api.layout.GermanMacLayout;
import com.inputstick.api.layout.GreekLayout;
import com.inputstick.api.layout.HebrewLayout;
import com.inputstick.api.layout.HungarianLayout;
import com.inputstick.api.layout.ItalianLayout;
import com.inputstick.api.layout.NorwegianLayout;
import com.inputstick.api.layout.PolishLayout;
import com.inputstick.api.layout.PolishLinuxLayout;
import com.inputstick.api.layout.PortugueseBrazilianLayout;
import com.inputstick.api.layout.PortugueseLayout;
import com.inputstick.api.layout.RussianLayout;
import com.inputstick.api.layout.SlovakLayout;
import com.inputstick.api.layout.SpanishLayout;
import com.inputstick.api.layout.SwedishLayout;
import com.inputstick.api.layout.SwissFrenchLayout;
import com.inputstick.api.layout.SwissGermanLayout;
import com.inputstick.api.layout.UnitedKingdomLayout;
import com.inputstick.api.layout.UnitedStatesInternationalLayout;
import com.inputstick.api.layout.UnitedStatesLayout;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public abstract class KeyboardLayout {
    public static final int MAX_SCANCODE = 96;
    public static final byte[] scanCodeToHID = new byte[]{0, 41, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 45, 46, 42, 43, 20, 26, 8, 21, 23, 28, 24, 12, 18, 19, 47, 48, 40, 0, 4, 22, 7, 9, 10, 11, 13, 14, 15, 51, 52, 53, 0, 49, 29, 27, 6, 25, 5, 17, 16, 54, 55, 56, 0, 70, 0, 44, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 83, 71, 74, 82, 75, 0, 80, 0, 79, 0, 77, 81, 78, 73, 76, 0, 0, 100, 68, 69, 0, 0, 0, 0, 0, 0, 0};
    public static final KeyboardLayout[] keyboardLayouts = new KeyboardLayout[]{BelgianLayout.getInstance(), CanadianFrenchLayout.getInstance(), CroatianLayout.getInstance(), CzechLayout.getInstance(), CzechLinuxLayout.getInstance(), CzechProgrammersLayout.getInstance(), DanishLayout.getInstance(), DutchLayout.getInstance(), DvorakLayout.getInstance(), FinnishLayout.getInstance(), FrenchLayout.getInstance(), FrenchLinuxLayout.getInstance(), GermanLayout.getInstance(), GermanMacLayout.getInstance(), GreekLayout.getInstance(), HebrewLayout.getInstance(), HungarianLayout.getInstance(), ItalianLayout.getInstance(), NorwegianLayout.getInstance(), PolishLayout.getInstance(), PolishLinuxLayout.getInstance(), PortugueseBrazilianLayout.getInstance(), PortugueseLayout.getInstance(), RussianLayout.getInstance(), SlovakLayout.getInstance(), SpanishLayout.getInstance(), SwedishLayout.getInstance(), SwissFrenchLayout.getInstance(), SwissGermanLayout.getInstance(), UnitedKingdomLayout.getInstance(), UnitedStatesInternationalLayout.getInstance(), UnitedStatesLayout.getInstance()};
    public static final int LAYOUT_CODE = 0;
    private static byte prevKey;

    public abstract int[][] getLUT();

    public abstract int[][] getFastLUT();

    public abstract int[][] getDeadkeyLUT();

    public abstract int[] getDeadkeys();

    public abstract String getLocaleName();

    public abstract String getNativeName();

    public abstract String getEnglishName();

    public abstract String getVariant();

    public abstract void type(String var1);

    public abstract void type(String var1, int var2);

    public abstract void type(String var1, byte var2);

    public abstract void type(String var1, byte var2, int var3);

    public abstract char getChar(int var1, boolean var2, boolean var3, boolean var4);

    public void type(int[][] fastLUT, String text) {
        this.type(fastLUT, text, (byte)0, 1);
    }

    public void type(int[][] fastLUT, String text, byte modifiers) {
        this.type(fastLUT, text, modifiers, 1);
    }

    public void type(int[][] fastLUT, String text, byte modifiers, int typingSpeed) {
        if (InputStickHID.getState() == 4 && text != null) {
            HIDTransaction t;
            char[] chars = text.toCharArray();
            prevKey = 0;
            for (char c : chars) {
                t = KeyboardLayout.getHIDTransaction(fastLUT, c, modifiers, typingSpeed);
                if (t == null) continue;
                InputStickHID.addKeyboardTransaction(t, false);
            }
            if (typingSpeed == 0) {
                t = new HIDTransaction(44);
                t.addReport(new ShortKeyboardReport());
                InputStickHID.addKeyboardTransaction(t, false);
            }
            InputStickHID.flushKeyboardBuffer();
        }
    }

    public static int hidToScanCode(byte key) {
        for (int scanCode = 0; scanCode < 96; ++scanCode) {
            if (scanCodeToHID[scanCode] != key) continue;
            return scanCode;
        }
        return -1;
    }

    public static char getChar(int[][] lut, int scanCode, boolean capsLock, boolean shift, boolean altGr) {
        if (scanCode >= 96 || scanCode < 0) {
            return '\u0000';
        }
        int index = 1;
        if (capsLock && lut[scanCode][0] > 0) {
            index = lut[scanCode][0] == 1 ? (shift ? 1 : 2) : (shift ? (altGr ? 4 : 1) : (altGr ? 5 : 2));
        } else {
            if (shift) {
                index = 2;
            }
            if (altGr) {
                index = shift ? 5 : 4;
            }
        }
        if (lut[scanCode][index] == -1) {
            index = 1;
        }
        return (char)lut[scanCode][index];
    }

    public static int getScanCode(int[][] lut, char c) {
        for (int scanCode = 0; scanCode < 96; ++scanCode) {
            if (lut[scanCode][0] == -1) continue;
            for (int i = 1; i < 6; ++i) {
                if (lut[scanCode][i] != c) continue;
                return scanCode;
            }
        }
        return -1;
    }

    public static byte getKey(int scanCode) {
        return scanCodeToHID[scanCode];
    }

    public static byte getModifiers(int[][] lut, int scanCode, char c) {
        if (lut[scanCode][1] == c) {
            return 0;
        }
        if (lut[scanCode][2] == c) {
            return 2;
        }
        if (lut[scanCode][3] == c) {
            return 1;
        }
        if (lut[scanCode][4] == c) {
            return 64;
        }
        if (lut[scanCode][5] == c) {
            return 66;
        }
        return 0;
    }

    public static boolean isDeadkey(int[] deadkeys, char c) {
        if (deadkeys != null) {
            for (int key : deadkeys) {
                if (key != c) continue;
                return true;
            }
        }
        return false;
    }

    public static int searchLUT(int[][] deadkeyLUT, char c, int returnIndex) {
        if (deadkeyLUT != null) {
            for (int i = 0; i < deadkeyLUT.length; ++i) {
                if (deadkeyLUT[i][2] != c) continue;
                return deadkeyLUT[i][returnIndex];
            }
        }
        return -1;
    }

    public static int findDeadKey(int[][] deadkeyLUT, char c) {
        return KeyboardLayout.searchLUT(deadkeyLUT, c, 0);
    }

    public static int findFollowingKey(int[][] deadkeyLUT, char c) {
        return KeyboardLayout.searchLUT(deadkeyLUT, c, 1);
    }

    public static HIDTransaction getHIDTransaction(int[][] fastLUT, char c, byte additionalModifierKeys, int typingSpeed) {
        HIDTransaction t = new HIDTransaction(44);
        for (int i = 0; i < fastLUT.length; ++i) {
            if (fastLUT[i][0] != c) continue;
            byte modifiers = (byte)fastLUT[i][1];
            modifiers = (byte)(modifiers | additionalModifierKeys);
            byte key = (byte)fastLUT[i][2];
            byte deadKeyModifiers = (byte)fastLUT[i][3];
            byte deadKey = (byte)fastLUT[i][4];
            if (deadKey > 0) {
                if (typingSpeed == 0) {
                    KeyboardLayout.addPressAndReleaseReportsToHIDTransaction(t, deadKeyModifiers, deadKey, 1);
                } else {
                    KeyboardLayout.addPressAndReleaseReportsToHIDTransaction(t, deadKeyModifiers, deadKey, typingSpeed);
                }
            }
            if (typingSpeed == 0) {
                if (key == prevKey) {
                    t.addReport(new ShortKeyboardReport());
                }
                KeyboardLayout.addPressAndReleaseReportsToHIDTransaction(t, modifiers, key, 0);
            } else {
                KeyboardLayout.addPressAndReleaseReportsToHIDTransaction(t, modifiers, key, typingSpeed);
            }
            prevKey = key;
        }
        return t;
    }

    private static void addPressAndReleaseReportsToHIDTransaction(HIDTransaction t, byte modifiers, byte key, int typingSpeed) {
        if (typingSpeed == 0) {
            t.addReport(new ShortKeyboardReport(modifiers, key));
        } else {
            int i;
            for (i = 0; i < typingSpeed; ++i) {
                t.addReport(new ShortKeyboardReport(modifiers, 0));
            }
            for (i = 0; i < typingSpeed; ++i) {
                t.addReport(new ShortKeyboardReport(modifiers, key));
            }
            for (i = 0; i < typingSpeed; ++i) {
                t.addReport(new ShortKeyboardReport());
            }
        }
    }

    public static HIDTransaction getHIDTransaction(int[][] lut, int[][] deadkeyLUT, int[] deadkeys, char c, byte additionalModifierKeys) {
        HIDTransaction t = new HIDTransaction(44);
        int scanCode = KeyboardLayout.getScanCode(lut, c);
        if (scanCode > 0) {
            byte key = KeyboardLayout.getKey(scanCode);
            byte modifiers = KeyboardLayout.getModifiers(lut, scanCode, c);
            modifiers = (byte)(modifiers | additionalModifierKeys);
            t.addReport(new ShortKeyboardReport(modifiers, 0));
            t.addReport(new ShortKeyboardReport(modifiers, key));
            t.addReport(new ShortKeyboardReport());
            if (KeyboardLayout.isDeadkey(deadkeys, c)) {
                t.addReport(new ShortKeyboardReport(0, 44));
                t.addReport(new ShortKeyboardReport());
            }
        } else {
            int deadkey = KeyboardLayout.findDeadKey(deadkeyLUT, c);
            if (deadkey > 0) {
                int following = KeyboardLayout.findFollowingKey(deadkeyLUT, c);
                scanCode = KeyboardLayout.getScanCode(lut, (char)deadkey);
                byte key = KeyboardLayout.getKey(scanCode);
                byte modifiers = KeyboardLayout.getModifiers(lut, scanCode, (char)deadkey);
                t.addReport(new ShortKeyboardReport(modifiers, 0));
                t.addReport(new ShortKeyboardReport(modifiers, key));
                t.addReport(new ShortKeyboardReport());
                scanCode = KeyboardLayout.getScanCode(lut, (char)following);
                key = KeyboardLayout.getKey(scanCode);
                modifiers = KeyboardLayout.getModifiers(lut, scanCode, (char)following);
                t.addReport(new ShortKeyboardReport(modifiers, 0));
                t.addReport(new ShortKeyboardReport(modifiers, key));
                t.addReport(new ShortKeyboardReport());
            }
        }
        return t;
    }

    public static KeyboardLayout getLayout(String locale) {
        if (locale != null) {
            for (KeyboardLayout layout2 : keyboardLayouts) {
                if (!locale.equalsIgnoreCase(layout2.getLocaleName())) continue;
                return layout2;
            }
        }
        return UnitedStatesLayout.getInstance();
    }

    public static CharSequence[] getLayoutNames(boolean addNativeNames) {
        ArrayList<LayoutInfo> infoArray = KeyboardLayout.getLayoutInfoSortedByLayoutName();
        CharSequence[] result2 = new CharSequence[infoArray.size()];
        for (int i = 0; i < infoArray.size(); ++i) {
            LayoutInfo info = infoArray.get(i);
            String tmp = info.englishName;
            if (addNativeNames && !info.nativeName.equalsIgnoreCase("english")) {
                tmp = tmp + " (" + info.nativeName + ")";
            }
            tmp = tmp + " [" + info.variant + "]";
            result2[i] = tmp;
        }
        return result2;
    }

    public static CharSequence[] getLayoutCodes() {
        ArrayList<LayoutInfo> tmp = KeyboardLayout.getLayoutInfoSortedByLayoutName();
        CharSequence[] result2 = new CharSequence[tmp.size()];
        for (int i = 0; i < tmp.size(); ++i) {
            result2[i] = tmp.get((int)i).localeName;
        }
        return result2;
    }

    private static ArrayList<LayoutInfo> getLayoutInfoSortedByLayoutName() {
        ArrayList<LayoutInfo> result2 = new ArrayList<LayoutInfo>();
        for (int i = 0; i < keyboardLayouts.length; ++i) {
            LayoutInfo info = new LayoutInfo();
            info.localeName = keyboardLayouts[i].getLocaleName();
            info.nativeName = keyboardLayouts[i].getNativeName();
            info.englishName = keyboardLayouts[i].getEnglishName();
            info.variant = keyboardLayouts[i].getVariant();
            result2.add(info);
        }
        Collections.sort(result2, new Comparator<LayoutInfo>(){

            @Override
            public int compare(LayoutInfo i1, LayoutInfo i2) {
                return i1.englishName.compareToIgnoreCase(i2.englishName);
            }
        });
        return result2;
    }

    private static class LayoutInfo {
        public String localeName;
        public String nativeName;
        public String englishName;
        public String variant;

        private LayoutInfo() {
        }
    }
}

