/*
 * Decompiled with CFR 0.152.
 */
package com.inputstick.api.utils.remote;

import android.annotation.SuppressLint;
import android.app.AlertDialog;
import android.content.Context;
import android.os.Build;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.ScrollView;
import com.inputstick.api.basic.InputStickHID;
import com.inputstick.api.layout.KeyboardLayout;
import com.inputstick.api.utils.remote.ModifiersSupport;
import com.inputstick.api.utils.remote.RemoteSupport;

public class KeyboardSupport {
    @SuppressLint(value={"InlinedApi"})
    private static final LUTEntry[] LUT_SPECIAL_KEYS = new LUTEntry[]{new LUTEntry(21, 80), new LUTEntry(22, 79), new LUTEntry(19, 82), new LUTEntry(20, 81), new LUTEntry(111, 41), new LUTEntry(131, 58), new LUTEntry(132, 59), new LUTEntry(133, 60), new LUTEntry(134, 61), new LUTEntry(135, 62), new LUTEntry(136, 63), new LUTEntry(137, 64), new LUTEntry(138, 65), new LUTEntry(139, 66), new LUTEntry(140, 67), new LUTEntry(141, 68), new LUTEntry(142, 69), new LUTEntry(124, 73), new LUTEntry(112, 76), new LUTEntry(122, 74), new LUTEntry(123, 77), new LUTEntry(92, 75), new LUTEntry(93, 78), new LUTEntry(143, 83), new LUTEntry(115, 57), new LUTEntry(116, 71), new LUTEntry(121, 72), new LUTEntry(120, 70), new LUTEntry(66, 40), new LUTEntry(67, 42), new LUTEntry(61, 43), new LUTEntry(62, 44), new LUTEntry(21, 80), new LUTEntry(21, 80), new LUTEntry(21, 80)};
    private static final LUTEntry[] LUT_OTHER_KEYS = new LUTEntry[]{new LUTEntry(68, 53), new LUTEntry(8, 30), new LUTEntry(9, 31), new LUTEntry(10, 32), new LUTEntry(11, 33), new LUTEntry(12, 34), new LUTEntry(13, 35), new LUTEntry(14, 36), new LUTEntry(15, 37), new LUTEntry(16, 38), new LUTEntry(7, 39), new LUTEntry(69, 45), new LUTEntry(70, 46), new LUTEntry(45, 20), new LUTEntry(51, 26), new LUTEntry(33, 8), new LUTEntry(46, 21), new LUTEntry(48, 23), new LUTEntry(53, 28), new LUTEntry(49, 24), new LUTEntry(37, 12), new LUTEntry(43, 18), new LUTEntry(44, 19), new LUTEntry(71, 47), new LUTEntry(72, 48), new LUTEntry(29, 4), new LUTEntry(47, 22), new LUTEntry(32, 7), new LUTEntry(34, 9), new LUTEntry(35, 10), new LUTEntry(36, 11), new LUTEntry(38, 13), new LUTEntry(39, 14), new LUTEntry(40, 15), new LUTEntry(74, 51), new LUTEntry(75, 52), new LUTEntry(54, 29), new LUTEntry(52, 27), new LUTEntry(31, 6), new LUTEntry(50, 25), new LUTEntry(30, 5), new LUTEntry(42, 17), new LUTEntry(41, 16), new LUTEntry(55, 54), new LUTEntry(56, 55), new LUTEntry(76, 56), new LUTEntry(73, 49)};
    protected RemoteSupport mRemote;

    private static byte getHIDKeyCode(int keyCode, LUTEntry[] lut) {
        for (LUTEntry entry : lut) {
            if (entry.getKeyCode() != keyCode) continue;
            return entry.getHIDKeyCode();
        }
        return 0;
    }

    public KeyboardSupport(RemoteSupport remote) {
        this.mRemote = remote;
    }

    public void onPress(KeyboardLayout layout2, byte modifier, byte key) {
        this.mRemote.pressAndRelease(modifier, key);
    }

    public void onKeyMultiple(int keyCode, int repeatCount, KeyEvent event) {
        if (keyCode == 0 && event.getAction() == 2) {
            String s = event.getCharacters();
            this.mRemote.type(s, (byte)0);
        }
    }

    @SuppressLint(value={"NewApi"})
    private byte getEventModifiers(KeyEvent event, boolean ctrl, boolean shift, boolean alt) {
        byte result2 = 0;
        if (Build.VERSION.SDK_INT >= 11 && event.isCtrlPressed() && ctrl) {
            result2 = (byte)(result2 | 1);
        }
        if (event.isShiftPressed() && shift) {
            result2 = (byte)(result2 | 2);
        }
        if (event.isAltPressed() && alt) {
            result2 = (byte)(result2 | 4);
        }
        return result2;
    }

    public void onKeyDown(byte modifiers, int keyCode, KeyEvent event) {
        if (!KeyEvent.isModifierKey((int)keyCode) && !this.handleKeyEvent(event, keyCode, modifiers, LUT_SPECIAL_KEYS)) {
            boolean unicode = false;
            char c = (char)event.getUnicodeChar();
            if (KeyboardLayout.getScanCode(this.mRemote.getPreferences().getKeyboardLayout().getLUT(), c) > 0) {
                unicode = true;
            } else if (KeyboardLayout.findDeadKey(this.mRemote.getPreferences().getKeyboardLayout().getDeadkeyLUT(), c) > 0) {
                unicode = true;
            }
            if (unicode) {
                byte eventModifiers = this.getEventModifiers(event, true, false, true);
                eventModifiers = (byte)(eventModifiers | modifiers);
                String s = String.valueOf(c);
                if (InputStickHID.getState() == 4) {
                    this.mRemote.type(s, eventModifiers);
                }
            } else {
                this.handleKeyEvent(event, keyCode, modifiers, LUT_OTHER_KEYS);
            }
        }
    }

    private boolean handleKeyEvent(KeyEvent event, int keyCode, byte modifiers, LUTEntry[] lut) {
        byte key = KeyboardSupport.getHIDKeyCode(keyCode, lut);
        if (key != 0) {
            byte eventModifiers = this.getEventModifiers(event, true, true, true);
            eventModifiers = (byte)(eventModifiers | modifiers);
            this.mRemote.pressAndRelease(eventModifiers, key);
            return true;
        }
        return false;
    }

    public static AlertDialog getFunctionKeysDialog(Context ctx, RemoteSupport remote, ModifiersSupport modifiers, String title) {
        AlertDialog.Builder dialog = new AlertDialog.Builder(ctx);
        ScrollView sl = new ScrollView(ctx);
        dialog.setTitle((CharSequence)title);
        LinearLayout.LayoutParams llp = new LinearLayout.LayoutParams(0, -2, 1.0f);
        LinearLayout main = new LinearLayout(ctx);
        main.setOrientation(1);
        LinearLayout layout2 = new LinearLayout(ctx);
        layout2.setOrientation(0);
        KeyboardSupport.addButton(ctx, remote, modifiers, layout2, llp, "F1", (byte)58);
        KeyboardSupport.addButton(ctx, remote, modifiers, layout2, llp, "F2", (byte)59);
        KeyboardSupport.addButton(ctx, remote, modifiers, layout2, llp, "F3", (byte)60);
        KeyboardSupport.addButton(ctx, remote, modifiers, layout2, llp, "F4", (byte)61);
        KeyboardSupport.addButton(ctx, remote, modifiers, layout2, llp, "F5", (byte)62);
        KeyboardSupport.addButton(ctx, remote, modifiers, layout2, llp, "F6", (byte)63);
        main.addView((View)layout2);
        layout2 = new LinearLayout(ctx);
        layout2.setOrientation(0);
        KeyboardSupport.addButton(ctx, remote, modifiers, layout2, llp, "F7", (byte)64);
        KeyboardSupport.addButton(ctx, remote, modifiers, layout2, llp, "F8", (byte)65);
        KeyboardSupport.addButton(ctx, remote, modifiers, layout2, llp, "F9", (byte)66);
        KeyboardSupport.addButton(ctx, remote, modifiers, layout2, llp, "F10", (byte)67);
        KeyboardSupport.addButton(ctx, remote, modifiers, layout2, llp, "F11", (byte)68);
        KeyboardSupport.addButton(ctx, remote, modifiers, layout2, llp, "F12", (byte)69);
        main.addView((View)layout2);
        layout2 = new LinearLayout(ctx);
        layout2.setOrientation(0);
        KeyboardSupport.addButton(ctx, remote, modifiers, layout2, llp, "Insert", (byte)73);
        KeyboardSupport.addButton(ctx, remote, modifiers, layout2, llp, "Delete", (byte)76);
        KeyboardSupport.addButton(ctx, remote, modifiers, layout2, llp, "Home", (byte)74);
        KeyboardSupport.addButton(ctx, remote, modifiers, layout2, llp, "End", (byte)77);
        KeyboardSupport.addButton(ctx, remote, modifiers, layout2, llp, "PgUp", (byte)75);
        KeyboardSupport.addButton(ctx, remote, modifiers, layout2, llp, "PgDown", (byte)78);
        main.addView((View)layout2);
        layout2 = new LinearLayout(ctx);
        layout2.setOrientation(0);
        KeyboardSupport.addButton(ctx, remote, modifiers, layout2, llp, "NumLock", (byte)83);
        KeyboardSupport.addButton(ctx, remote, modifiers, layout2, llp, "CapsLock", (byte)57);
        KeyboardSupport.addButton(ctx, remote, modifiers, layout2, llp, "ScrLock", (byte)71);
        KeyboardSupport.addButton(ctx, remote, modifiers, layout2, llp, "PrScrn", (byte)70);
        KeyboardSupport.addButton(ctx, remote, modifiers, layout2, llp, "Pause", (byte)72);
        main.addView((View)layout2);
        layout2 = new LinearLayout(ctx);
        layout2.setOrientation(0);
        KeyboardSupport.addButton(ctx, remote, modifiers, layout2, llp, "Esc", (byte)41);
        KeyboardSupport.addButton(ctx, remote, modifiers, layout2, llp, "Tab", (byte)43);
        KeyboardSupport.addButton(ctx, remote, modifiers, layout2, llp, "`", (byte)53);
        KeyboardSupport.addButton(ctx, remote, modifiers, layout2, llp, "Space", (byte)44);
        KeyboardSupport.addButton(ctx, remote, modifiers, layout2, llp, "\u2190 Backspace", (byte)42);
        KeyboardSupport.addButton(ctx, remote, modifiers, layout2, llp, "Enter", (byte)40);
        main.addView((View)layout2);
        layout2 = new LinearLayout(ctx);
        layout2.setOrientation(0);
        KeyboardSupport.addButton(ctx, remote, modifiers, layout2, llp, "\u2190", (byte)80);
        KeyboardSupport.addButton(ctx, remote, modifiers, layout2, llp, "\u2192", (byte)79);
        KeyboardSupport.addButton(ctx, remote, modifiers, layout2, llp, "\u2191", (byte)82);
        KeyboardSupport.addButton(ctx, remote, modifiers, layout2, llp, "\u2193", (byte)81);
        main.addView((View)layout2);
        sl.addView((View)main);
        dialog.setView((View)sl);
        dialog.setPositiveButton(0x1040000, null);
        AlertDialog tmp = dialog.create();
        return tmp;
    }

    private static void addButton(Context ctx, final RemoteSupport remote, final ModifiersSupport modifiers, LinearLayout layout2, LinearLayout.LayoutParams params, String label, byte keyCode) {
        Button button = new Button(ctx);
        button.setText((CharSequence)label);
        button.setLayoutParams((ViewGroup.LayoutParams)params);
        button.setTag((Object)keyCode);
        button.setSingleLine();
        button.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                Button b = (Button)v;
                byte key = (Byte)b.getTag();
                remote.pressAndRelease(modifiers.getModifiers(), key);
            }
        });
        layout2.addView((View)button);
    }

    private static class LUTEntry {
        private int mKeyCode;
        private byte mHIDKeyCode;

        public LUTEntry(int keyCode, byte hidKeyCode) {
            this.mKeyCode = keyCode;
            this.mHIDKeyCode = hidKeyCode;
        }

        public int getKeyCode() {
            return this.mKeyCode;
        }

        public byte getHIDKeyCode() {
            return this.mHIDKeyCode;
        }
    }
}

