/*
 * Decompiled with CFR 0.152.
 */
package com.inputstick.api.utils.remote;

import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.CompoundButton;
import android.widget.ToggleButton;
import com.inputstick.api.utils.remote.RemoteSupport;

public class ModifiersSupport {
    protected RemoteSupport mRemote;
    protected ViewGroup layoutMain;
    protected ToggleButton toggleButtonCtrl;
    protected ToggleButton toggleButtonShift;
    protected ToggleButton toggleButtonAlt;
    protected ToggleButton toggleButtonGui;
    protected ToggleButton toggleButtonAltGr;
    protected Button buttonContext;
    protected boolean isResetting;

    public ModifiersSupport(RemoteSupport remote, ViewGroup layout2, ToggleButton ctrl, ToggleButton shift, ToggleButton alt, ToggleButton gui, ToggleButton altGr, Button context) {
        this.mRemote = remote;
        this.layoutMain = layout2;
        this.toggleButtonCtrl = ctrl;
        this.toggleButtonShift = shift;
        this.toggleButtonAlt = alt;
        this.toggleButtonGui = gui;
        this.toggleButtonAltGr = altGr;
        this.buttonContext = context;
        this.toggleButtonCtrl.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener(){

            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                if (ModifiersSupport.this.isResetting) {
                    return;
                }
                ModifiersSupport.this.update();
            }
        });
        this.toggleButtonShift.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener(){

            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                if (ModifiersSupport.this.isResetting) {
                    return;
                }
                ModifiersSupport.this.update();
            }
        });
        this.toggleButtonAlt.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener(){

            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                if (ModifiersSupport.this.isResetting) {
                    return;
                }
                ModifiersSupport.this.update();
            }
        });
        this.toggleButtonGui.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener(){

            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                if (ModifiersSupport.this.isResetting) {
                    return;
                }
                ModifiersSupport.this.update();
            }
        });
        this.toggleButtonAltGr.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener(){

            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                if (ModifiersSupport.this.isResetting) {
                    return;
                }
                ModifiersSupport.this.update();
            }
        });
        this.toggleButtonCtrl.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View v) {
                ModifiersSupport.this.mRemote.pressAndRelease((byte)1, (byte)0);
                return true;
            }
        });
        this.toggleButtonShift.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View v) {
                ModifiersSupport.this.mRemote.pressAndRelease((byte)2, (byte)0);
                return true;
            }
        });
        this.toggleButtonAlt.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View v) {
                ModifiersSupport.this.mRemote.pressAndRelease((byte)4, (byte)0);
                return true;
            }
        });
        this.toggleButtonGui.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View v) {
                ModifiersSupport.this.mRemote.pressAndRelease((byte)8, (byte)0);
                return true;
            }
        });
        this.toggleButtonAltGr.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View v) {
                ModifiersSupport.this.mRemote.pressAndRelease((byte)64, (byte)0);
                return true;
            }
        });
        if (this.buttonContext != null) {
            this.buttonContext.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    ModifiersSupport.this.mRemote.pressAndRelease(ModifiersSupport.this.getModifiers(), (byte)101);
                }
            });
        }
    }

    public void resetModifiers() {
        this.isResetting = true;
        this.toggleButtonCtrl.setChecked(false);
        this.toggleButtonShift.setChecked(false);
        this.toggleButtonAlt.setChecked(false);
        this.toggleButtonGui.setChecked(false);
        this.toggleButtonAltGr.setChecked(false);
        this.isResetting = false;
        this.update();
    }

    public void manageUI(int state) {
        boolean enabled;
        boolean bl = enabled = state == 4;
        if (this.mRemote.getPreferences().showModifiersArea()) {
            this.layoutMain.setVisibility(0);
            this.toggleButtonCtrl.setEnabled(enabled);
            this.toggleButtonShift.setEnabled(enabled);
            this.toggleButtonAlt.setEnabled(enabled);
            this.toggleButtonGui.setEnabled(enabled);
            this.toggleButtonAltGr.setEnabled(enabled);
            if (this.buttonContext != null) {
                this.buttonContext.setEnabled(enabled);
            }
        } else {
            this.layoutMain.setVisibility(8);
        }
    }

    public byte getModifiers() {
        byte modifier = 0;
        if (this.mRemote.getPreferences().showModifiersArea()) {
            if (this.toggleButtonCtrl.isChecked()) {
                modifier = (byte)(modifier | 1);
            }
            if (this.toggleButtonShift.isChecked()) {
                modifier = (byte)(modifier | 2);
            }
            if (this.toggleButtonAlt.isChecked()) {
                modifier = (byte)(modifier | 4);
            }
            if (this.toggleButtonGui.isChecked()) {
                modifier = (byte)(modifier | 8);
            }
            if (this.toggleButtonAltGr.isChecked()) {
                modifier = (byte)(modifier | 0x40);
            }
        }
        return modifier;
    }

    private void update() {
        byte modifiers = this.getModifiers();
        this.mRemote.keyboardReport(modifiers, (byte)0, (byte)0, (byte)0, (byte)0, (byte)0, (byte)0);
    }
}

