/*
 * Decompiled with CFR 0.152.
 */
package com.inputstick.api.utils.remote;

import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import com.inputstick.api.utils.remote.MousePadView;
import com.inputstick.api.utils.remote.MouseScrollView;
import com.inputstick.api.utils.remote.RemotePreferences;
import com.inputstick.api.utils.remote.RemoteSupport;
import java.util.Timer;
import java.util.TimerTask;

public class MousePadSupport {
    protected static final int OUT_OF_RANGE_TIMEOUT = 5000;
    protected static final int MOUSE_REFRESH_INTERVAL = 10;
    protected static final int SCROLL_REFRESH_INTERVAL = 10;
    protected static final int IDLE_RESET_INTERVAL = 100;
    protected static final int TAP_MIN_INTERVAL = 20;
    protected static final int DEADZONE_TIMEOUT_PERIOD = 500;
    protected static final int MIN_PROXIMITY = 225;
    protected static final float MOUSEPAD_RESCALE_FACTOR = 1.2f;
    protected MouseButtonOnTouchListener mMouseButtonOnTouchListener;
    protected MouseOnTouchListener mMouseOnTouchListener;
    protected RemoteSupport mRemote;
    protected RemotePreferences mRemotePreferences;
    protected ViewGroup layoutMain;
    protected MousePadView mousePad;
    protected View buttonMouseL;
    protected View buttonMouseM;
    protected View buttonMouseR;
    protected MouseScrollView mouseScroll;
    protected int lastX;
    protected int lastY;
    protected long lastMoveTime;
    protected long lastHIDUpdateTime;
    protected int lastScroll;
    protected long lastTimeScrollTime;
    protected long lastTapTime;
    protected int lastTapX;
    protected int lastTapY;
    protected boolean tapState;
    protected boolean lmb;
    protected boolean buttonStateLeft;
    protected boolean buttonStateMiddle;
    protected boolean buttonStateRight;
    protected int touchX;
    protected int touchY;
    protected boolean deadZone;
    protected int deadZoneX;
    protected int deadZoneY;
    protected long deadZoneTimeout;
    protected Timer outOfRangeTimer;

    public MousePadSupport(RemoteSupport remote, ViewGroup layout2, MousePadView pad, View left, View middle, View right, MouseScrollView scroll) {
        this.mRemote = remote;
        this.mRemotePreferences = remote.getPreferences();
        this.mMouseOnTouchListener = new MouseOnTouchListener();
        this.mMouseButtonOnTouchListener = new MouseButtonOnTouchListener();
        this.layoutMain = layout2;
        this.mousePad = pad;
        this.buttonMouseL = left;
        this.buttonMouseM = middle;
        this.buttonMouseR = right;
        this.mouseScroll = scroll;
        this.mousePad.setOnTouchListener(this.mMouseOnTouchListener);
        if (this.buttonMouseL != null) {
            this.buttonMouseL.setOnTouchListener((View.OnTouchListener)this.mMouseButtonOnTouchListener);
        }
        if (this.buttonMouseM != null) {
            this.buttonMouseM.setOnTouchListener((View.OnTouchListener)this.mMouseButtonOnTouchListener);
        }
        if (this.buttonMouseR != null) {
            this.buttonMouseR.setOnTouchListener((View.OnTouchListener)this.mMouseButtonOnTouchListener);
        }
        if (this.mouseScroll != null) {
            this.mouseScroll.setOnTouchListener(this.mMouseOnTouchListener);
        }
    }

    protected void cancelOutOfRangeTimer() {
        if (this.outOfRangeTimer != null) {
            this.outOfRangeTimer.cancel();
            this.outOfRangeTimer = null;
        }
    }

    public void manageUI(int state) {
        boolean enabled;
        boolean bl = enabled = state == 4;
        if (this.mousePad.refreshRatio(this.mRemotePreferences.getMousePadRatio())) {
            this.mousePad.requestLayout();
            this.mousePad.invalidate();
        }
        if (this.mRemote.getPreferences().showMouseArea()) {
            this.layoutMain.setVisibility(0);
            this.mousePad.setEnabled(enabled);
            if (this.buttonMouseL != null) {
                this.buttonMouseL.setEnabled(enabled);
            }
            if (this.buttonMouseM != null) {
                this.buttonMouseM.setEnabled(enabled);
            }
            if (this.buttonMouseR != null) {
                this.buttonMouseR.setEnabled(enabled);
            }
            if (this.mouseScroll != null) {
                this.mouseScroll.setEnabled(enabled);
            }
        } else {
            this.layoutMain.setVisibility(8);
        }
    }

    protected int getProximity() {
        int w;
        int h;
        int tmp = this.mRemotePreferences.getTouchProximity();
        if (tmp == 0 && (tmp = ((h = this.mousePad.getHeight()) * h + (w = this.mousePad.getWidth()) * w) / 1000) < 225) {
            tmp = 225;
        }
        return tmp;
    }

    protected boolean checkProximity(int x, int y) {
        int d = (this.lastTapX - x) * (this.lastTapX - x);
        return (d += (this.lastTapY - y) * (this.lastTapY - y)) < this.getProximity();
    }

    protected boolean isOutOfDeadZone(int x, int y) {
        int d = (this.deadZoneX - x) * (this.deadZoneX - x);
        return (d += (this.deadZoneY - y) * (this.deadZoneY - y)) > this.getProximity();
    }

    private void setTouchCoords(int x, int y) {
        int w = this.mousePad.getWidth();
        int h = this.mousePad.getHeight();
        int center = w / 2;
        float d = center - x;
        x = (int)((float)center - (d *= 1.2f));
        if (x < 0) {
            x = 0;
        }
        if (x > w) {
            x = w;
        }
        center = h / 2;
        d = center - y;
        y = (int)((float)center - (d *= 1.2f));
        if (y < 0) {
            y = 0;
        }
        if (y > h) {
            y = h;
        }
        this.touchX = x * 10000 / w;
        this.touchY = y * 10000 / h;
        if (this.touchX > 10000) {
            this.touchX = 10000;
        }
        if (this.touchX < 0) {
            this.touchX = 0;
        }
        if (this.touchY > 10000) {
            this.touchY = 10000;
        }
        if (this.touchY < 0) {
            this.touchY = 0;
        }
    }

    private void sendReport(byte toMoveX, byte toMoveY, byte toScroll) {
        byte buttonByte = 0;
        boolean leftButton = false;
        if (this.buttonStateLeft || this.lmb) {
            buttonByte = (byte)(buttonByte | 1);
            leftButton = true;
        }
        if (this.buttonStateMiddle) {
            buttonByte = (byte)(buttonByte | 4);
        }
        if (this.buttonStateRight) {
            buttonByte = (byte)(buttonByte | 2);
        }
        if (this.mRemotePreferences.isInTouchScreenMode()) {
            if (toScroll != 0) {
                this.mRemote.mouseReport(buttonByte, (byte)0, (byte)0, toScroll);
            } else {
                this.mRemote.moveTouchPointer(leftButton, this.touchX, this.touchY);
            }
        } else {
            this.mRemote.mouseReport(buttonByte, toMoveX, toMoveY, toScroll);
        }
    }

    private class MouseOnTouchListener
    implements View.OnTouchListener {
        private MouseOnTouchListener() {
        }

        public boolean onTouch(View v, MotionEvent event) {
            long time = System.currentTimeMillis();
            byte toScroll = 0;
            byte toMoveX = 0;
            byte toMoveY = 0;
            boolean update2 = false;
            int x = (int)event.getX();
            int y = (int)event.getY();
            if (v.equals((Object)MousePadSupport.this.mousePad)) {
                switch (event.getAction()) {
                    case 0: {
                        if (MousePadSupport.this.deadZone) {
                            MousePadSupport.this.deadZoneTimeout = time + 500L;
                        }
                        if (MousePadSupport.this.tapState) {
                            long timeDiff = time - MousePadSupport.this.lastTapTime;
                            if (timeDiff < (long)MousePadSupport.this.mRemotePreferences.getTapInterval() && timeDiff > 20L) {
                                if (MousePadSupport.this.checkProximity(x, y) && MousePadSupport.this.mRemotePreferences.isTapToClick()) {
                                    MousePadSupport.this.lmb = true;
                                    update2 = true;
                                }
                            } else {
                                MousePadSupport.this.tapState = false;
                            }
                        }
                        MousePadSupport.this.lastTapTime = time;
                        if (!MousePadSupport.this.mRemotePreferences.isInTouchScreenMode()) break;
                        MousePadSupport.this.cancelOutOfRangeTimer();
                        break;
                    }
                    case 1: {
                        if (MousePadSupport.this.tapState) {
                            if (MousePadSupport.this.mRemotePreferences.isTapToClick()) {
                                MousePadSupport.this.lmb = false;
                                update2 = true;
                            }
                        } else if (time < MousePadSupport.this.lastTapTime + (long)MousePadSupport.this.mRemotePreferences.getTapInterval()) {
                            MousePadSupport.this.tapState = true;
                        }
                        MousePadSupport.this.lastTapX = x;
                        MousePadSupport.this.lastTapY = y;
                        MousePadSupport.this.lastTapTime = time;
                        if (!MousePadSupport.this.mRemotePreferences.isInTouchScreenMode()) break;
                        MousePadSupport.this.deadZone = true;
                        MousePadSupport.this.deadZoneX = x;
                        MousePadSupport.this.deadZoneY = y;
                        MousePadSupport.this.deadZoneTimeout = 0L;
                        MousePadSupport.this.cancelOutOfRangeTimer();
                        MousePadSupport.this.outOfRangeTimer = new Timer();
                        MousePadSupport.this.outOfRangeTimer.schedule(new TimerTask(){

                            @Override
                            public void run() {
                                MousePadSupport.this.mRemote.goOutOfRange(MousePadSupport.this.touchX, MousePadSupport.this.touchY);
                                MousePadSupport.this.outOfRangeTimer = null;
                            }
                        }, 5000L);
                        break;
                    }
                    case 2: {
                        if (x > 0 && x < MousePadSupport.this.mousePad.getWidth() && y > 0 && y < MousePadSupport.this.mousePad.getHeight()) {
                            if (MousePadSupport.this.deadZone && MousePadSupport.this.deadZoneTimeout > 0L && time > MousePadSupport.this.deadZoneTimeout) {
                                MousePadSupport.this.deadZone = false;
                            }
                            if (MousePadSupport.this.deadZone && MousePadSupport.this.isOutOfDeadZone(x, y)) {
                                MousePadSupport.this.deadZone = false;
                            }
                            if (time <= MousePadSupport.this.lastMoveTime + 10L) break;
                            if (time > MousePadSupport.this.lastHIDUpdateTime + 100L) {
                                MousePadSupport.this.lastX = x;
                                MousePadSupport.this.lastY = y;
                            }
                            MousePadSupport.this.lastHIDUpdateTime = time;
                            MousePadSupport.this.lastMoveTime = time;
                            toMoveX = (byte)(x - MousePadSupport.this.lastX);
                            toMoveY = (byte)(y - MousePadSupport.this.lastY);
                            toMoveX = (byte)(MousePadSupport.this.mRemotePreferences.getMouseSensitivity() * toMoveX / 50);
                            toMoveY = (byte)(MousePadSupport.this.mRemotePreferences.getMouseSensitivity() * toMoveY / 50);
                            update2 = true;
                            MousePadSupport.this.lastX = x;
                            MousePadSupport.this.lastY = y;
                            if (!MousePadSupport.this.mRemotePreferences.isInTouchScreenMode() || MousePadSupport.this.deadZone) break;
                            MousePadSupport.this.setTouchCoords(x, y);
                            break;
                        }
                        MousePadSupport.this.lastX = 0;
                        MousePadSupport.this.lastY = 0;
                    }
                }
            }
            if (v.equals((Object)MousePadSupport.this.mouseScroll)) {
                if (event.getAction() == 0) {
                    MousePadSupport.this.lastScroll = y;
                }
                if (event.getAction() == 2) {
                    if (x > 0 && x < MousePadSupport.this.mouseScroll.getWidth() && y > 0 && y < MousePadSupport.this.mouseScroll.getHeight()) {
                        if (time > MousePadSupport.this.lastTimeScrollTime + 10L) {
                            toScroll = (byte)(MousePadSupport.this.lastScroll - y);
                            toScroll = (byte)(MousePadSupport.this.mRemotePreferences.getScrollSensitivity() * toScroll / 150);
                            if (toScroll != 0) {
                                MousePadSupport.this.lastTimeScrollTime = time;
                                MousePadSupport.this.lastScroll = y;
                                update2 = true;
                            }
                        }
                    } else {
                        MousePadSupport.this.lastScroll = 0;
                    }
                }
            }
            if (update2) {
                MousePadSupport.this.sendReport(toMoveX, toMoveY, toScroll);
            }
            return true;
        }
    }

    private class MouseButtonOnTouchListener
    implements View.OnTouchListener {
        private byte buttonFix;

        private MouseButtonOnTouchListener() {
        }

        public boolean onTouch(View v, MotionEvent event) {
            if (event.getAction() == 0) {
                if (v.equals(MousePadSupport.this.buttonMouseL)) {
                    MousePadSupport.this.buttonStateLeft = true;
                } else if (v.equals(MousePadSupport.this.buttonMouseR)) {
                    this.buttonFix = (byte)2;
                    MousePadSupport.this.buttonStateRight = true;
                } else if (v.equals(MousePadSupport.this.buttonMouseM)) {
                    this.buttonFix = (byte)4;
                    MousePadSupport.this.buttonStateMiddle = true;
                }
                MousePadSupport.this.sendReport((byte)0, (byte)0, (byte)0);
            }
            if (event.getAction() == 1) {
                if (v.equals(MousePadSupport.this.buttonMouseL)) {
                    MousePadSupport.this.buttonStateLeft = false;
                } else if (v.equals(MousePadSupport.this.buttonMouseR)) {
                    MousePadSupport.this.buttonStateRight = false;
                } else if (v.equals(MousePadSupport.this.buttonMouseM)) {
                    MousePadSupport.this.buttonStateMiddle = false;
                }
                if (MousePadSupport.this.mRemotePreferences.isInTouchScreenMode() && this.buttonFix != 0) {
                    MousePadSupport.this.mRemote.mouseClick(this.buttonFix, 1);
                }
                MousePadSupport.this.sendReport((byte)0, (byte)0, (byte)0);
                this.buttonFix = 0;
            }
            return false;
        }
    }
}

