/*
 * Decompiled with CFR 0.152.
 */
package com.inputstick.api.utils.remote;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.view.View;
import com.inputstick.api.utils.remote.ViewAspectRatioMeasurer;

public class MousePadView
extends View {
    protected int mWidth;
    protected int mHeight;
    protected RectF mRect;
    protected Paint mPaint;
    protected ViewAspectRatioMeasurer mVarm = new ViewAspectRatioMeasurer();
    protected float mRatio;

    public MousePadView(Context context) {
        super(context);
        if (!this.isInEditMode()) {
            this.mRatio = 0.0f;
        }
    }

    public MousePadView(Context context, AttributeSet attrs) {
        super(context, attrs);
        if (!this.isInEditMode()) {
            this.mRatio = 0.0f;
        }
    }

    public MousePadView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        if (!this.isInEditMode()) {
            this.mRatio = 0.0f;
        }
    }

    public boolean refreshRatio(float newRatio) {
        if (this.mRatio != newRatio) {
            this.mRatio = newRatio;
            return true;
        }
        return false;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (this.mRatio > 0.0f) {
            this.mVarm.measure(widthMeasureSpec, heightMeasureSpec, this.mRatio);
            this.setMeasuredDimension(this.mVarm.getMeasuredWidth(), this.mVarm.getMeasuredHeight());
        } else {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        }
    }

    protected void onSizeChanged(int xNew, int yNew, int xOld, int yOld) {
        super.onSizeChanged(xNew, yNew, xOld, yOld);
        this.mWidth = xNew;
        this.mHeight = yNew;
        int w = this.mHeight / 100;
        if (this.mWidth > this.mHeight) {
            w = this.mWidth / 100;
        }
        if (w < 1) {
            w = 1;
        }
        this.mRect = new RectF(new Rect(0, 0, this.mWidth, this.mHeight));
        this.mPaint = new Paint();
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mPaint.setStrokeWidth((float)w);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.isEnabled()) {
            this.mPaint.setColor(-16744193);
        } else {
            this.mPaint.setColor(-3355444);
        }
        canvas.drawRect(this.mRect, this.mPaint);
    }
}

