/*
 * Decompiled with CFR 0.152.
 */
package com.inputstick.api.utils.remote;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.view.View;

public class MouseScrollView
extends View {
    protected int mWidth;
    protected int mHeight;
    protected Paint mPaint;
    protected int x1;
    protected int x2;

    public MouseScrollView(Context context) {
        super(context);
    }

    public MouseScrollView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public MouseScrollView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    protected void onSizeChanged(int xNew, int yNew, int xOld, int yOld) {
        super.onSizeChanged(xNew, yNew, xOld, yOld);
        this.mWidth = xNew;
        this.mHeight = yNew;
        int w = this.mHeight / 100;
        if (this.mWidth > this.mHeight) {
            w = this.mWidth / 100;
        }
        if (w < 1) {
            w = 1;
        }
        this.mPaint = new Paint();
        this.mPaint.setStyle(Paint.Style.FILL);
        this.x1 = this.mWidth / 4;
        this.x2 = 3 * this.x1;
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.isEnabled()) {
            this.mPaint.setColor(-16744193);
        } else {
            this.mPaint.setColor(-3355444);
        }
        int y = 0;
        do {
            canvas.drawRect(0.0f, (float)y, (float)this.mWidth, (float)(y + 5), this.mPaint);
            if ((y += 10) > this.mHeight) break;
            canvas.drawRect((float)this.x1, (float)y, (float)this.x2, (float)(y + 5), this.mPaint);
        } while ((y += 10) <= this.mHeight);
    }
}

