/*
 * Decompiled with CFR 0.152.
 */
package com.inputstick.api.utils.remote;

import com.inputstick.api.basic.InputStickKeyboard;
import com.inputstick.api.basic.InputStickMouse;
import com.inputstick.api.basic.InputStickTouchScreen;
import com.inputstick.api.utils.remote.RemotePreferences;

public class RemoteSupport {
    protected RemotePreferences preferences;
    protected boolean usedKeyboard;
    protected boolean usedMouse;
    protected boolean usedTouchscreen;
    protected int lastX;
    protected int lastY;
    protected long lastActionTime;

    public RemoteSupport(RemotePreferences preferences) {
        this.preferences = preferences;
        this.lastActionTime = 0L;
    }

    public RemotePreferences getPreferences() {
        return this.preferences;
    }

    public long getLastActionTime() {
        return this.lastActionTime;
    }

    public void keyboardReport(byte modifiers, byte key0, byte key1, byte key2, byte key3, byte key4, byte key5) {
        InputStickKeyboard.customReport(modifiers, key0, key1, key2, key3, key4, key5);
        this.usedKeyboard = true;
        this.lastActionTime = System.currentTimeMillis();
    }

    public void pressAndRelease(byte modifiers, byte key) {
        InputStickKeyboard.pressAndRelease(modifiers, key, this.preferences.getTypingSpeed());
        this.usedKeyboard = true;
        this.lastActionTime = System.currentTimeMillis();
    }

    public void type(String text, byte modifiers) {
        this.preferences.getKeyboardLayout().type(text, modifiers, this.preferences.getTypingSpeed());
        this.usedKeyboard = true;
        this.lastActionTime = System.currentTimeMillis();
    }

    public void mouseReport(byte buttons, byte x, byte y, byte wheel) {
        InputStickMouse.customReport(buttons, x, y, wheel);
        this.usedMouse = true;
        this.lastActionTime = System.currentTimeMillis();
    }

    public void mouseClick(byte button, int n) {
        InputStickMouse.click(button, n);
        this.usedMouse = true;
        this.lastActionTime = System.currentTimeMillis();
    }

    public void moveTouchPointer(boolean buttonPressed, int x, int y) {
        InputStickTouchScreen.moveTouchPointer(buttonPressed, x, y);
        this.lastX = x;
        this.lastY = y;
        this.usedTouchscreen = true;
        this.lastActionTime = System.currentTimeMillis();
    }

    public void goOutOfRange() {
        if (this.usedTouchscreen) {
            InputStickTouchScreen.goOutOfRange(this.lastX, this.lastY);
        } else {
            InputStickTouchScreen.goOutOfRange(0, 0);
        }
        this.usedTouchscreen = false;
    }

    public void goOutOfRange(int x, int y) {
        InputStickTouchScreen.goOutOfRange(x, y);
        this.usedTouchscreen = false;
    }

    public void resetHIDInterfaces() {
        if (this.usedKeyboard) {
            InputStickKeyboard.customReport((byte)0, (byte)0, (byte)0, (byte)0, (byte)0, (byte)0, (byte)0);
            this.usedKeyboard = false;
        }
        if (this.usedMouse) {
            InputStickMouse.customReport((byte)0, (byte)0, (byte)0, (byte)0);
            this.usedMouse = false;
        }
        if (this.usedTouchscreen) {
            InputStickTouchScreen.goOutOfRange(this.lastX, this.lastY);
            this.usedTouchscreen = false;
        }
        this.lastActionTime = 0L;
    }
}

