/*
 * Decompiled with CFR 0.152.
 */
package com.inputstick.api.utils.remote;

import android.view.View;

public class ViewAspectRatioMeasurer {
    private Integer measuredWidth = null;
    private Integer measuredHeight = null;

    public void measure(int widthMeasureSpec, int heightMeasureSpec, float aspectRatio) {
        int heightSize;
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int widthSize = widthMode == 0 ? Integer.MAX_VALUE : View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int n = heightSize = heightMode == 0 ? Integer.MAX_VALUE : View.MeasureSpec.getSize((int)heightMeasureSpec);
        if (heightMode == 0x40000000 && widthMode == 0x40000000) {
            this.measuredWidth = widthSize;
            this.measuredHeight = heightSize;
        } else if (heightMode == 0x40000000) {
            this.measuredWidth = (int)Math.min((float)widthSize, (float)heightSize * aspectRatio);
            this.measuredHeight = (int)((float)this.measuredWidth.intValue() / aspectRatio);
        } else if (widthMode == 0x40000000) {
            this.measuredHeight = (int)Math.min((float)heightSize, (float)widthSize / aspectRatio);
            this.measuredWidth = (int)((float)this.measuredHeight.intValue() * aspectRatio);
        } else if ((float)widthSize > (float)heightSize * aspectRatio) {
            this.measuredHeight = heightSize;
            this.measuredWidth = (int)((float)this.measuredHeight.intValue() * aspectRatio);
        } else {
            this.measuredWidth = widthSize;
            this.measuredHeight = (int)((float)this.measuredWidth.intValue() / aspectRatio);
        }
    }

    public int getMeasuredWidth() {
        if (this.measuredWidth == null) {
            throw new IllegalStateException("You need to run measure() before trying to get measured dimensions");
        }
        return this.measuredWidth;
    }

    public int getMeasuredHeight() {
        if (this.measuredHeight == null) {
            throw new IllegalStateException("You need to run measure() before trying to get measured dimensions");
        }
        return this.measuredHeight;
    }
}

