/*
 * Decompiled with CFR 0.152.
 */
package me.hackerchick.sharetoinputstick;

import android.app.Application;
import android.bluetooth.BluetoothDevice;
import android.content.Context;
import androidx.lifecycle.AndroidViewModel;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import me.hackerchick.sharetoinputstick.DBHelper;
import me.hackerchick.sharetoinputstick.InputStick;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J$\u0010\u000b\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\t0\bj\b\u0012\u0004\u0012\u00020\t`\n0\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\tJ\u001c\u0010\u0013\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\t0\bj\b\u0012\u0004\u0012\u00020\t`\n0\fJ\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\tJ\u000e\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\tJ\u000e\u0010\u0018\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\fJ\u0010\u0010\u0019\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\tJ\u000e\u0010\u001b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\fJ\u0010\u0010\u001c\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\tJ\b\u0010\u001f\u001a\u0004\u0018\u00010\u001eJ\u0010\u0010 \u001a\u00020\u00102\b\u0010!\u001a\u0004\u0018\u00010\u001eJ\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u001e0\fJ\u000e\u0010$\u001a\u00020\u00102\u0006\u0010%\u001a\u00020\u001eJ\f\u0010(\u001a\b\u0012\u0004\u0012\u00020'0\fJ\u000e\u0010)\u001a\u00020\u00102\u0006\u0010*\u001a\u00020'J\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00150\fJ\u000e\u0010-\u001a\u00020\u00102\u0006\u0010.\u001a\u00020\u0015J \u0010/\u001a\u0012\u0012\u0004\u0012\u00020\t0\bj\b\u0012\u0004\u0012\u00020\t`\n2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u00100\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u00101\u001a\u00020\u001eH\u0002J\u0016\u00100\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u00102\u001a\u000203R$\u0010\u0006\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\t0\bj\b\u0012\u0004\u0012\u00020\t`\n0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0012\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\t0\bj\b\u0012\u0004\u0012\u00020\t`\n0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0017\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001a\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001e0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010&\u001a\b\u0012\u0004\u0012\u00020'0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00150\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lme/hackerchick/sharetoinputstick/InputStickViewModel;", "Landroidx/lifecycle/AndroidViewModel;", "application", "Landroid/app/Application;", "<init>", "(Landroid/app/Application;)V", "_knownDevicesList", "Landroidx/lifecycle/MutableLiveData;", "Ljava/util/ArrayList;", "Lme/hackerchick/sharetoinputstick/InputStick;", "Lkotlin/collections/ArrayList;", "getKnownDevicesList", "Landroidx/lifecycle/LiveData;", "context", "Landroid/content/Context;", "editDevice", "", "inputStick", "_bluetoothDevicesList", "getBluetoothDevicesList", "bluetoothDevicesListContains", "", "addToBluetoothDevicesList", "_waitingDevice", "getWaitingDevice", "setWaitingDevice", "_connectingDevice", "getConnectingDevice", "setConnectingDevice", "_busyDialogMessage", "", "getBusyDialogMessage", "setBusyDialogMessage", "message", "_textToSend", "getTextToSend", "setTextToSend", "text", "_inputSpeed", "", "getInputSpeed", "setInputSpeed", "inputSpeed", "_sending", "isSending", "setSending", "value", "loadKnownDevicesList", "retrieveInputStick", "mac", "bluetoothDevice", "Landroid/bluetooth/BluetoothDevice;", "app_release"})
public final class InputStickViewModel
extends AndroidViewModel {
    @NotNull
    private final MutableLiveData<ArrayList<InputStick>> _knownDevicesList;
    @NotNull
    private final MutableLiveData<ArrayList<InputStick>> _bluetoothDevicesList;
    @NotNull
    private final MutableLiveData<InputStick> _waitingDevice;
    @NotNull
    private final MutableLiveData<InputStick> _connectingDevice;
    @Nullable
    private String _busyDialogMessage;
    @NotNull
    private final MutableLiveData<String> _textToSend;
    @NotNull
    private final MutableLiveData<Integer> _inputSpeed;
    @NotNull
    private final MutableLiveData<Boolean> _sending;

    public InputStickViewModel(@NotNull Application application) {
        Intrinsics.checkNotNullParameter(application, "application");
        super(application);
        this._knownDevicesList = new MutableLiveData();
        this._bluetoothDevicesList = new MutableLiveData();
        this._waitingDevice = new MutableLiveData();
        this._connectingDevice = new MutableLiveData();
        this._textToSend = new MutableLiveData();
        this._inputSpeed = new MutableLiveData();
        this._sending = new MutableLiveData();
    }

    @NotNull
    public final LiveData<ArrayList<InputStick>> getKnownDevicesList(@NotNull Context context) {
        Intrinsics.checkNotNullParameter(context, "context");
        if (this._knownDevicesList.getValue() == null) {
            this._knownDevicesList.setValue(this.loadKnownDevicesList(context));
        }
        return this._knownDevicesList;
    }

    public final void editDevice(@NotNull Context context, @NotNull InputStick inputStick) {
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(inputStick, "inputStick");
        DBHelper db = new DBHelper(context);
        db.upsertInputStick(inputStick.getMac(), inputStick.getName(), inputStick.getPassword(), inputStick.getLast_used());
        ArrayList<InputStick> arrayList = this.getKnownDevicesList(context).getValue();
        Intrinsics.checkNotNull(arrayList);
        ArrayList<InputStick> data = arrayList;
        Iterator<InputStick> iterator2 = data.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
        Iterator<InputStick> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            InputStick device;
            Intrinsics.checkNotNullExpressionValue(iterator3.next(), "next(...)");
            if (!Intrinsics.areEqual(device.getMac(), inputStick.getMac())) continue;
            data.remove(device);
            break;
        }
        if (inputStick.getLast_used() > 0L) {
            data.add(inputStick);
        }
        this._knownDevicesList.setValue(data);
    }

    @NotNull
    public final LiveData<ArrayList<InputStick>> getBluetoothDevicesList() {
        if (this._bluetoothDevicesList.getValue() == null) {
            this._bluetoothDevicesList.setValue(new ArrayList());
        }
        return this._bluetoothDevicesList;
    }

    public final boolean bluetoothDevicesListContains(@NotNull InputStick inputStick) {
        Intrinsics.checkNotNullParameter(inputStick, "inputStick");
        ArrayList<InputStick> arrayList = this.getBluetoothDevicesList().getValue();
        Intrinsics.checkNotNull(arrayList);
        Iterator<InputStick> iterator2 = arrayList.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
        Iterator<InputStick> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            InputStick bluetoothDevice;
            Intrinsics.checkNotNullExpressionValue(iterator3.next(), "next(...)");
            if (!Intrinsics.areEqual(bluetoothDevice.getMac(), inputStick.getMac())) continue;
            return true;
        }
        return false;
    }

    public final void addToBluetoothDevicesList(@NotNull InputStick inputStick) {
        Intrinsics.checkNotNullParameter(inputStick, "inputStick");
        ArrayList<InputStick> arrayList = this.getBluetoothDevicesList().getValue();
        Intrinsics.checkNotNull(arrayList);
        ArrayList<InputStick> data = arrayList;
        if (data.contains(inputStick)) {
            return;
        }
        data.add(inputStick);
        this._bluetoothDevicesList.setValue(data);
    }

    @NotNull
    public final LiveData<InputStick> getWaitingDevice() {
        return this._waitingDevice;
    }

    public final void setWaitingDevice(@Nullable InputStick inputStick) {
        this._waitingDevice.setValue(inputStick);
    }

    @NotNull
    public final LiveData<InputStick> getConnectingDevice() {
        return this._connectingDevice;
    }

    public final void setConnectingDevice(@Nullable InputStick inputStick) {
        this._connectingDevice.setValue(inputStick);
    }

    @Nullable
    public final String getBusyDialogMessage() {
        return this._busyDialogMessage;
    }

    public final void setBusyDialogMessage(@Nullable String message) {
        this._busyDialogMessage = message;
    }

    @NotNull
    public final LiveData<String> getTextToSend() {
        if (this._textToSend.getValue() == null) {
            this._textToSend.setValue("");
        }
        return this._textToSend;
    }

    public final void setTextToSend(@NotNull String text) {
        Intrinsics.checkNotNullParameter(text, "text");
        this._textToSend.setValue(text);
    }

    @NotNull
    public final LiveData<Integer> getInputSpeed() {
        if (this._inputSpeed.getValue() == null) {
            this._inputSpeed.setValue(1);
        }
        return this._inputSpeed;
    }

    public final void setInputSpeed(int inputSpeed) {
        this._inputSpeed.setValue(inputSpeed);
    }

    @NotNull
    public final LiveData<Boolean> isSending() {
        if (this._sending.getValue() == null) {
            this._sending.setValue(false);
        }
        return this._sending;
    }

    public final void setSending(boolean value) {
        this._sending.setValue(value);
    }

    private final ArrayList<InputStick> loadKnownDevicesList(Context context) {
        DBHelper db = new DBHelper(context);
        List<InputStick> list = db.getAllByLastUsed();
        Intrinsics.checkNotNull(list, "null cannot be cast to non-null type java.util.ArrayList<me.hackerchick.sharetoinputstick.InputStick>");
        return (ArrayList)list;
    }

    private final InputStick retrieveInputStick(Context context, String mac) {
        DBHelper db = new DBHelper(context);
        InputStick inputStick = db.getInputStick(mac);
        if (inputStick == null) {
            inputStick = new InputStick(mac, null, null, 0L);
        }
        return inputStick;
    }

    @NotNull
    public final InputStick retrieveInputStick(@NotNull Context context, @NotNull BluetoothDevice bluetoothDevice) {
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(bluetoothDevice, "bluetoothDevice");
        String string2 = bluetoothDevice.getAddress();
        Intrinsics.checkNotNullExpressionValue(string2, "getAddress(...)");
        InputStick inputStick = this.retrieveInputStick(context, string2);
        if (!Intrinsics.areEqual(inputStick.getName(), bluetoothDevice.getName())) {
            inputStick.setName(bluetoothDevice.getName());
            DBHelper db = new DBHelper(context);
            db.upsertInputStick(inputStick.getMac(), inputStick.getName(), inputStick.getPassword(), inputStick.getLast_used());
        }
        return inputStick;
    }
}

