/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.AbstractMidiDevice;
import com.sun.media.sound.AbstractMidiDeviceProvider;
import com.sun.media.sound.FastShortMessage;
import com.sun.media.sound.FastSysexMessage;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.ShortMessage;

final class MidiOutDevice
extends AbstractMidiDevice {
    MidiOutDevice(AbstractMidiDeviceProvider.Info info) {
        super(info);
    }

    @Override
    protected synchronized void implOpen() throws MidiUnavailableException {
        int n = ((AbstractMidiDeviceProvider.Info)this.getDeviceInfo()).getIndex();
        this.id = this.nOpen(n);
        if (this.id == 0L) {
            throw new MidiUnavailableException("Unable to open native device");
        }
    }

    @Override
    protected synchronized void implClose() {
        long l = this.id;
        this.id = 0L;
        super.implClose();
        this.nClose(l);
    }

    @Override
    public long getMicrosecondPosition() {
        long l = -1L;
        if (this.isOpen()) {
            l = this.nGetTimeStamp(this.id);
        }
        return l;
    }

    @Override
    protected boolean hasReceivers() {
        return true;
    }

    @Override
    protected Receiver createReceiver() {
        return new MidiOutReceiver();
    }

    private native long nOpen(int var1) throws MidiUnavailableException;

    private native void nClose(long var1);

    private native void nSendShortMessage(long var1, int var3, long var4);

    private native void nSendLongMessage(long var1, byte[] var3, int var4, long var5);

    private native long nGetTimeStamp(long var1);

    final class MidiOutReceiver
    extends AbstractMidiDevice.AbstractReceiver {
        MidiOutReceiver() {
            super(MidiOutDevice.this);
        }

        @Override
        void implSend(MidiMessage midiMessage, long l) {
            int n = midiMessage.getLength();
            int n2 = midiMessage.getStatus();
            if (n <= 3 && n2 != 240 && n2 != 247) {
                int n3;
                if (midiMessage instanceof ShortMessage) {
                    if (midiMessage instanceof FastShortMessage) {
                        n3 = ((FastShortMessage)midiMessage).getPackedMsg();
                    } else {
                        ShortMessage shortMessage = (ShortMessage)midiMessage;
                        n3 = n2 & 0xFF | (shortMessage.getData1() & 0xFF) << 8 | (shortMessage.getData2() & 0xFF) << 16;
                    }
                } else {
                    n3 = 0;
                    byte[] byArray = midiMessage.getMessage();
                    if (n > 0) {
                        n3 = byArray[0] & 0xFF;
                        if (n > 1) {
                            if (n2 == 255) {
                                return;
                            }
                            n3 |= (byArray[1] & 0xFF) << 8;
                            if (n > 2) {
                                n3 |= (byArray[2] & 0xFF) << 16;
                            }
                        }
                    }
                }
                MidiOutDevice.this.nSendShortMessage(MidiOutDevice.this.id, n3, l);
            } else {
                byte[] byArray = midiMessage instanceof FastSysexMessage ? ((FastSysexMessage)midiMessage).getReadOnlyMessage() : midiMessage.getMessage();
                int n4 = Math.min(n, byArray.length);
                if (n4 > 0) {
                    MidiOutDevice.this.nSendLongMessage(MidiOutDevice.this.id, byArray, n4, l);
                }
            }
        }

        synchronized void sendPackedMidiMessage(int n, long l) {
            if (this.isOpen() && MidiOutDevice.this.id != 0L) {
                MidiOutDevice.this.nSendShortMessage(MidiOutDevice.this.id, n, l);
            }
        }
    }
}

