/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.ast;

import com.apollographql.apollo.ast.Issue;
import com.apollographql.apollo.ast.IssueKt;
import java.util.Collection;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\n\u0018\u0000*\n\b\u0000\u0010\u0001 \u0001*\u00020\u00022\u00020\u0002B\u001f\u0012\b\u0010\u0003\u001a\u0004\u0018\u00018\u0000\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\r\u0010\u000e\u001a\u00028\u0000H\u0007\u00a2\u0006\u0002\u0010\nJ\u000b\u0010\u000f\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\nR\u0015\u0010\u0003\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0010"}, d2={"Lcom/apollographql/apollo/ast/GQLResult;", "V", "", "value", "issues", "", "Lcom/apollographql/apollo/ast/Issue;", "<init>", "(Ljava/lang/Object;Ljava/util/List;)V", "getValue", "()Ljava/lang/Object;", "Ljava/lang/Object;", "getIssues", "()Ljava/util/List;", "valueAssertNoErrors", "getOrThrow", "apollo-ast"})
public final class GQLResult<V> {
    @Nullable
    private final V value;
    @NotNull
    private final List<Issue> issues;

    public GQLResult(@Nullable V value, @NotNull List<? extends Issue> issues) {
        Intrinsics.checkNotNullParameter(issues, "issues");
        this.value = value;
        this.issues = issues;
        if (!(this.value != null || !((Collection)this.issues).isEmpty())) {
            boolean bl = false;
            String string = "Apollo: GQLResult must contain a value or issues";
            throw new IllegalStateException(string.toString());
        }
    }

    @Nullable
    public final V getValue() {
        return this.value;
    }

    @NotNull
    public final List<Issue> getIssues() {
        return this.issues;
    }

    @Deprecated(message="Use getOrThrow instead", replaceWith=@ReplaceWith(expression="getOrThrow()", imports={}))
    @NotNull
    public final V valueAssertNoErrors() {
        return this.getOrThrow();
    }

    @NotNull
    public final V getOrThrow() {
        IssueKt.checkValidGraphQL(this.issues);
        if (!(this.value != null)) {
            boolean bl = false;
            String string = "Apollo: no value and no error found";
            throw new IllegalStateException(string.toString());
        }
        return this.value;
    }
}

