/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.ast;

import com.apollographql.apollo.ast.GQLEnumTypeDefinition;
import com.apollographql.apollo.ast.GQLInputObjectTypeDefinition;
import com.apollographql.apollo.ast.GQLInterfaceTypeDefinition;
import com.apollographql.apollo.ast.GQLListType;
import com.apollographql.apollo.ast.GQLNamedType;
import com.apollographql.apollo.ast.GQLNonNullType;
import com.apollographql.apollo.ast.GQLObjectTypeDefinition;
import com.apollographql.apollo.ast.GQLScalarTypeDefinition;
import com.apollographql.apollo.ast.GQLType;
import com.apollographql.apollo.ast.GQLTypeDefinition;
import com.apollographql.apollo.ast.GQLUnionTypeDefinition;
import com.apollographql.apollo.ast.GQLVariableDefinition;
import com.apollographql.apollo.ast.VariableUsage;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ReplaceWith;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0002H\u0007\u001a\n\u0010\u0003\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0004\u001a\u00020\u0005*\u00020\u0002\u001a\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0000\u001a\u0018\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u0002H\u0000\u001a \u0010\u000f\u001a\u00020\u0007*\u00020\u00022\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00120\u0011H\u0000\u001a \u0010\u0013\u001a\u00020\u0007*\u00020\u00022\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00120\u0011H\u0000\u00a8\u0006\u0014"}, d2={"leafType", "Lcom/apollographql/apollo/ast/GQLNamedType;", "Lcom/apollographql/apollo/ast/GQLType;", "rawType", "pretty", "", "isVariableUsageAllowed", "", "variableDefinition", "Lcom/apollographql/apollo/ast/GQLVariableDefinition;", "usage", "Lcom/apollographql/apollo/ast/VariableUsage;", "areTypesCompatible", "variableType", "locationType", "isInputType", "typeDefinitions", "", "Lcom/apollographql/apollo/ast/GQLTypeDefinition;", "isOutputType", "apollo-ast"})
public final class GqltypeKt {
    @Deprecated(message="Use rawType instead", replaceWith=@ReplaceWith(expression="rawType()", imports={}))
    @NotNull
    public static final GQLNamedType leafType(@NotNull GQLType $this$leafType) {
        Intrinsics.checkNotNullParameter($this$leafType, "<this>");
        return GqltypeKt.rawType($this$leafType);
    }

    @NotNull
    public static final GQLNamedType rawType(@NotNull GQLType $this$rawType) {
        GQLNamedType gQLNamedType;
        Intrinsics.checkNotNullParameter($this$rawType, "<this>");
        GQLType gQLType = $this$rawType;
        if (gQLType instanceof GQLNonNullType) {
            gQLNamedType = GqltypeKt.rawType(((GQLNonNullType)$this$rawType).getType());
        } else if (gQLType instanceof GQLListType) {
            gQLNamedType = GqltypeKt.rawType(((GQLListType)$this$rawType).getType());
        } else if (gQLType instanceof GQLNamedType) {
            gQLNamedType = (GQLNamedType)$this$rawType;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return gQLNamedType;
    }

    @NotNull
    public static final String pretty(@NotNull GQLType $this$pretty) {
        String string;
        Intrinsics.checkNotNullParameter($this$pretty, "<this>");
        GQLType gQLType = $this$pretty;
        if (gQLType instanceof GQLNonNullType) {
            string = GqltypeKt.pretty(((GQLNonNullType)$this$pretty).getType()) + '!';
        } else if (gQLType instanceof GQLListType) {
            string = '[' + GqltypeKt.pretty(((GQLListType)$this$pretty).getType()) + ']';
        } else if (gQLType instanceof GQLNamedType) {
            string = ((GQLNamedType)$this$pretty).getName();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    public static final boolean isVariableUsageAllowed(@NotNull GQLVariableDefinition variableDefinition, @NotNull VariableUsage usage) {
        Intrinsics.checkNotNullParameter(variableDefinition, "variableDefinition");
        Intrinsics.checkNotNullParameter(usage, "usage");
        GQLType variableType = variableDefinition.getType();
        GQLType locationType = usage.getLocationType();
        if (locationType instanceof GQLNonNullType && !(variableType instanceof GQLNonNullType)) {
            if (variableDefinition.getDefaultValue() == null && !usage.getHasLocationDefaultValue()) {
                return false;
            }
            return GqltypeKt.areTypesCompatible(variableType, ((GQLNonNullType)locationType).getType());
        }
        return GqltypeKt.areTypesCompatible(variableType, locationType);
    }

    public static final boolean areTypesCompatible(@NotNull GQLType variableType, @NotNull GQLType locationType) {
        boolean bl;
        Intrinsics.checkNotNullParameter(variableType, "variableType");
        Intrinsics.checkNotNullParameter(locationType, "locationType");
        if (locationType instanceof GQLNonNullType) {
            bl = !(variableType instanceof GQLNonNullType) ? false : GqltypeKt.areTypesCompatible(((GQLNonNullType)variableType).getType(), ((GQLNonNullType)locationType).getType());
        } else if (variableType instanceof GQLNonNullType) {
            bl = GqltypeKt.areTypesCompatible(((GQLNonNullType)variableType).getType(), locationType);
        } else if (locationType instanceof GQLListType) {
            bl = !(variableType instanceof GQLListType) ? false : GqltypeKt.areTypesCompatible(((GQLListType)variableType).getType(), ((GQLListType)locationType).getType());
        } else if (variableType instanceof GQLListType) {
            bl = false;
        } else {
            if (!(variableType instanceof GQLNamedType)) {
                String string = "Check failed.";
                throw new IllegalStateException(string.toString());
            }
            if (!(locationType instanceof GQLNamedType)) {
                String string = "Check failed.";
                throw new IllegalStateException(string.toString());
            }
            bl = Intrinsics.areEqual(((GQLNamedType)variableType).getName(), ((GQLNamedType)locationType).getName());
        }
        return bl;
    }

    public static final boolean isInputType(@NotNull GQLType $this$isInputType, @NotNull Map<String, ? extends GQLTypeDefinition> typeDefinitions) {
        boolean bl;
        Intrinsics.checkNotNullParameter($this$isInputType, "<this>");
        Intrinsics.checkNotNullParameter(typeDefinitions, "typeDefinitions");
        GQLType gQLType = $this$isInputType;
        if (gQLType instanceof GQLNonNullType) {
            bl = GqltypeKt.isInputType(((GQLNonNullType)$this$isInputType).getType(), typeDefinitions);
        } else if (gQLType instanceof GQLListType) {
            bl = GqltypeKt.isInputType(((GQLListType)$this$isInputType).getType(), typeDefinitions);
        } else if (gQLType instanceof GQLNamedType) {
            GQLTypeDefinition it = typeDefinitions.get(((GQLNamedType)$this$isInputType).getName());
            boolean bl2 = false;
            bl = it instanceof GQLInputObjectTypeDefinition || it instanceof GQLScalarTypeDefinition || it instanceof GQLEnumTypeDefinition;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bl;
    }

    public static final boolean isOutputType(@NotNull GQLType $this$isOutputType, @NotNull Map<String, ? extends GQLTypeDefinition> typeDefinitions) {
        boolean bl;
        Intrinsics.checkNotNullParameter($this$isOutputType, "<this>");
        Intrinsics.checkNotNullParameter(typeDefinitions, "typeDefinitions");
        GQLType gQLType = $this$isOutputType;
        if (gQLType instanceof GQLNonNullType) {
            bl = GqltypeKt.isInputType(((GQLNonNullType)$this$isOutputType).getType(), typeDefinitions);
        } else if (gQLType instanceof GQLListType) {
            bl = GqltypeKt.isInputType(((GQLListType)$this$isOutputType).getType(), typeDefinitions);
        } else if (gQLType instanceof GQLNamedType) {
            GQLTypeDefinition it = typeDefinitions.get(((GQLNamedType)$this$isOutputType).getName());
            boolean bl2 = false;
            bl = it instanceof GQLObjectTypeDefinition || it instanceof GQLUnionTypeDefinition || it instanceof GQLInterfaceTypeDefinition || it instanceof GQLScalarTypeDefinition || it instanceof GQLEnumTypeDefinition;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bl;
    }
}

