/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.ast.internal.validation;

import com.apollographql.apollo.ast.DuplicateDeferLabel;
import com.apollographql.apollo.ast.GQLArgument;
import com.apollographql.apollo.ast.GQLDirective;
import com.apollographql.apollo.ast.GQLField;
import com.apollographql.apollo.ast.GQLFieldDefinition;
import com.apollographql.apollo.ast.GQLFragmentDefinition;
import com.apollographql.apollo.ast.GQLFragmentSpread;
import com.apollographql.apollo.ast.GQLInlineFragment;
import com.apollographql.apollo.ast.GQLNamedType;
import com.apollographql.apollo.ast.GQLOperationDefinition;
import com.apollographql.apollo.ast.GQLSelection;
import com.apollographql.apollo.ast.GQLStringValue;
import com.apollographql.apollo.ast.GQLTypeDefinition;
import com.apollographql.apollo.ast.GQLValue;
import com.apollographql.apollo.ast.GQLVariableValue;
import com.apollographql.apollo.ast.GqlfieldKt;
import com.apollographql.apollo.ast.GqltypeKt;
import com.apollographql.apollo.ast.InvalidDeferDirective;
import com.apollographql.apollo.ast.InvalidDeferLabel;
import com.apollographql.apollo.ast.Issue;
import com.apollographql.apollo.ast.Schema;
import com.apollographql.apollo.ast.SourceLocation;
import com.apollographql.apollo.ast.VariableDeferLabel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\u001c\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00100\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0006J@\u0010\u0017\u001a\u00020\u001c*\b\u0012\u0004\u0012\u00020\u001d0\u00182\u0006\u0010\u001b\u001a\u00020\u00062\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00060\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00060 H\u0002J*\u0010\u0017\u001a\u00020\u001c*\b\u0012\u0004\u0012\u00020!0\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00060\u0018H\u0002J$\u0010\"\u001a\u00020\u001c*\u00020!2\b\u0010#\u001a\u0004\u0018\u00010\u001a2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00060\u0018H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001c\u0010\u0013\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0016\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/apollographql/apollo/ast/internal/validation/Scope;", "", "schema", "Lcom/apollographql/apollo/ast/Schema;", "fragments", "", "", "Lcom/apollographql/apollo/ast/GQLFragmentDefinition;", "<init>", "(Lcom/apollographql/apollo/ast/Schema;Ljava/util/Map;)V", "getSchema", "()Lcom/apollographql/apollo/ast/Schema;", "getFragments", "()Ljava/util/Map;", "issues", "", "Lcom/apollographql/apollo/ast/Issue;", "getIssues", "()Ljava/util/List;", "deferDirectiveLabels", "", "Lcom/apollographql/apollo/ast/SourceLocation;", "deferDirectivePathAndLabels", "validate", "", "operation", "Lcom/apollographql/apollo/ast/GQLOperationDefinition;", "parentType", "", "Lcom/apollographql/apollo/ast/GQLSelection;", "path", "visitedFragmentSpreads", "", "Lcom/apollographql/apollo/ast/GQLDirective;", "validateDeferDirective", "parent", "apollo-ast"})
@SourceDebugExtension(value={"SMAP\ndefer_labels.kt\nKotlin\n*S Kotlin\n*F\n+ 1 defer_labels.kt\ncom/apollographql/apollo/ast/internal/validation/Scope\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,191:1\n1863#2,2:192\n1863#2,2:194\n295#2,2:196\n*S KotlinDebug\n*F\n+ 1 defer_labels.kt\ncom/apollographql/apollo/ast/internal/validation/Scope\n*L\n43#1:192,2\n71#1:194,2\n117#1:196,2\n*E\n"})
final class Scope {
    @NotNull
    private final Schema schema;
    @NotNull
    private final Map<String, GQLFragmentDefinition> fragments;
    @NotNull
    private final List<Issue> issues;
    @NotNull
    private final Map<String, SourceLocation> deferDirectiveLabels;
    @NotNull
    private final Map<String, SourceLocation> deferDirectivePathAndLabels;

    public Scope(@NotNull Schema schema, @NotNull Map<String, GQLFragmentDefinition> fragments) {
        Intrinsics.checkNotNullParameter(schema, "schema");
        Intrinsics.checkNotNullParameter(fragments, "fragments");
        this.schema = schema;
        this.fragments = fragments;
        this.issues = new ArrayList();
        this.deferDirectiveLabels = new LinkedHashMap();
        this.deferDirectivePathAndLabels = new LinkedHashMap();
    }

    @NotNull
    public final Schema getSchema() {
        return this.schema;
    }

    @NotNull
    public final Map<String, GQLFragmentDefinition> getFragments() {
        return this.fragments;
    }

    @NotNull
    public final List<Issue> getIssues() {
        return this.issues;
    }

    @NotNull
    public final List<Issue> validate(@NotNull GQLOperationDefinition operation, @NotNull String parentType) {
        Intrinsics.checkNotNullParameter(operation, "operation");
        Intrinsics.checkNotNullParameter(parentType, "parentType");
        this.validate(operation.getSelections(), parentType, CollectionsKt.emptyList(), operation, SetsKt.emptySet());
        return this.issues;
    }

    private final void validate(List<? extends GQLSelection> $this$validate, String parentType, List<String> path, GQLOperationDefinition operation, Set<String> visitedFragmentSpreads) {
        Iterable $this$forEach$iv = $this$validate;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GQLSelection it = (GQLSelection)element$iv;
            boolean bl = false;
            GQLSelection gQLSelection = it;
            if (gQLSelection instanceof GQLField) {
                GQLFieldDefinition fieldDefinition;
                GQLTypeDefinition typeDefinition;
                if (this.schema.getTypeDefinitions().get(parentType) == null || GqlfieldKt.definitionFromScope((GQLField)it, this.schema, typeDefinition) == null) continue;
                this.validate(((GQLField)it).getSelections(), GqltypeKt.rawType(fieldDefinition.getType()).getName(), CollectionsKt.plus((Collection)path, GqlfieldKt.responseName((GQLField)it)), null, visitedFragmentSpreads);
                continue;
            }
            if (gQLSelection instanceof GQLFragmentSpread) {
                GQLFragmentDefinition fragmentDefinition;
                this.validate(((GQLFragmentSpread)it).getDirectives(), operation, path);
                if (visitedFragmentSpreads.contains(((GQLFragmentSpread)it).getName()) || this.fragments.get(((GQLFragmentSpread)it).getName()) == null) continue;
                this.validate(fragmentDefinition.getSelections(), fragmentDefinition.getTypeCondition().getName(), path, null, SetsKt.plus(visitedFragmentSpreads, ((GQLFragmentSpread)it).getName()));
                continue;
            }
            if (gQLSelection instanceof GQLInlineFragment) {
                this.validate(((GQLInlineFragment)it).getDirectives(), operation, path);
                List<GQLSelection> list = ((GQLInlineFragment)it).getSelections();
                Object object = ((GQLInlineFragment)it).getTypeCondition();
                if (object == null || (object = ((GQLNamedType)object).getName()) == null) {
                    object = parentType;
                }
                this.validate(list, (String)object, path, null, visitedFragmentSpreads);
                continue;
            }
            throw new NoWhenBranchMatchedException();
        }
    }

    private final void validate(List<GQLDirective> $this$validate, GQLOperationDefinition operation, List<String> path) {
        Iterable $this$forEach$iv = $this$validate;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GQLDirective it = (GQLDirective)element$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual(it.getName(), "defer")) continue;
            this.validateDeferDirective(it, operation, path);
        }
    }

    private final void validateDeferDirective(GQLDirective $this$validateDeferDirective, GQLOperationDefinition parent, List<String> path) {
        String joinedPath;
        String pathAndLabel;
        GQLValue label;
        Object v0;
        Object $this$firstOrNull$iv;
        block8: {
            $this$firstOrNull$iv = $this$validateDeferDirective.getArguments();
            boolean $i$f$firstOrNull = false;
            Iterator iterator2 = $this$firstOrNull$iv.iterator();
            while (iterator2.hasNext()) {
                Object element$iv = iterator2.next();
                GQLArgument it = (GQLArgument)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getName(), "label")) continue;
                v0 = element$iv;
                break block8;
            }
            v0 = null;
        }
        GQLArgument gQLArgument = v0;
        GQLValue gQLValue = label = gQLArgument != null ? gQLArgument.getValue() : null;
        if (label instanceof GQLVariableValue) {
            this.issues.add(new VariableDeferLabel("@defer label argument must not be a variable", $this$validateDeferDirective.getSourceLocation()));
            return;
        }
        if (parent != null && (Intrinsics.areEqual(parent.getOperationType(), "mutation") || Intrinsics.areEqual(parent.getOperationType(), "subscription"))) {
            this.issues.add(new InvalidDeferDirective("The @defer directive is not allowed to be used on root fields of mutations or subscriptions", $this$validateDeferDirective.getSourceLocation()));
        }
        String labelStringValue = "";
        if (label != null) {
            if (!(label instanceof GQLStringValue)) {
                return;
            }
            labelStringValue = ((GQLStringValue)label).getValue();
            $this$firstOrNull$iv = labelStringValue;
            if (!new Regex("[a-zA-Z0-9_]+").matches((CharSequence)$this$firstOrNull$iv)) {
                this.issues.add(new InvalidDeferLabel("@defer label '" + labelStringValue + "' must only contain letters, numbers, or underscores", $this$validateDeferDirective.getSourceLocation()));
            }
            if (this.deferDirectiveLabels.containsKey(labelStringValue)) {
                StringBuilder stringBuilder = new StringBuilder().append("@defer label '").append(labelStringValue).append("' must be unique within all other @defer directives in the document. Same label found in ");
                SourceLocation sourceLocation = this.deferDirectiveLabels.get(labelStringValue);
                Intrinsics.checkNotNull(sourceLocation);
                this.issues.add(new DuplicateDeferLabel(stringBuilder.append(sourceLocation.pretty()).toString(), $this$validateDeferDirective.getSourceLocation()));
                return;
            }
            this.deferDirectiveLabels.put(labelStringValue, $this$validateDeferDirective.getSourceLocation());
        }
        if (this.deferDirectivePathAndLabels.containsKey(pathAndLabel = (joinedPath = CollectionsKt.joinToString$default(path, ".", null, null, 0, null, null, 62, null)) + '/' + labelStringValue)) {
            String labelMessage = ((CharSequence)labelStringValue).length() == 0 ? "no label" : "label '" + labelStringValue + '\'';
            StringBuilder stringBuilder = new StringBuilder().append("A @defer directive with the same path '").append(joinedPath).append("' and ").append(labelMessage).append(" is already defined in ");
            SourceLocation sourceLocation = this.deferDirectivePathAndLabels.get(pathAndLabel);
            Intrinsics.checkNotNull(sourceLocation);
            this.issues.add(new DuplicateDeferLabel(stringBuilder.append(sourceLocation.pretty()).append(". Set a unique label to distinguish them.").toString(), $this$validateDeferDirective.getSourceLocation()));
            return;
        }
        this.deferDirectivePathAndLabels.put(pathAndLabel, $this$validateDeferDirective.getSourceLocation());
    }
}

