/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.ast.introspection;

import com.apollographql.apollo.annotations.ApolloExperimental;
import com.apollographql.apollo.annotations.ApolloInternal;
import com.apollographql.apollo.ast.ConversionException;
import com.apollographql.apollo.ast.GQLDocument;
import com.apollographql.apollo.ast.introspection.GQLDocumentBuilder;
import com.apollographql.apollo.ast.introspection.Introspection;
import com.apollographql.apollo.ast.introspection.IntrospectionSchema;
import com.apollographql.apollo.ast.introspection.IntrospectionSchemaImpl;
import com.apollographql.apollo.ast.introspection.Optional;
import com.apollographql.apollo.ast.introspection.RData;
import com.apollographql.apollo.ast.introspection.RDirective;
import com.apollographql.apollo.ast.introspection.REnvelope;
import com.apollographql.apollo.ast.introspection.RSchema;
import com.apollographql.apollo.ast.introspection.RTypeFull;
import com.apollographql.apollo.ast.introspection.RTypeRoot;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonBuilder;
import kotlinx.serialization.json.JsonKt;
import okio.Buffer;
import okio.BufferedSource;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=5, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\n\b\u0002\u0010\u0003\u001a\u0004\u0018\u00010\u0004H\u0007\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0004\u001a\n\u0010\u0005\u001a\u00020\u0006*\u00020\u0001\u001a\f\u0010\t\u001a\u00020\u0001*\u00020\u0001H\u0007\"\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"toIntrospectionSchema", "Lcom/apollographql/apollo/ast/introspection/IntrospectionSchema;", "Lokio/BufferedSource;", "filePath", "", "toGQLDocument", "Lcom/apollographql/apollo/ast/GQLDocument;", "json", "Lkotlinx/serialization/json/Json;", "normalize", "apollo-ast"}, xs="com/apollographql/apollo/ast/introspection/Introspection")
@SourceDebugExtension(value={"SMAP\nintrospection_reader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 introspection_reader.kt\ncom/apollographql/apollo/ast/introspection/Introspection__Introspection_readerKt\n+ 2 Json.kt\nkotlinx/serialization/json/Json\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,559:1\n96#2:560\n1053#3:561\n1053#3:562\n*S KotlinDebug\n*F\n+ 1 introspection_reader.kt\ncom/apollographql/apollo/ast/introspection/Introspection__Introspection_readerKt\n*L\n80#1:560\n547#1:561\n548#1:562\n*E\n"})
final class Introspection__Introspection_readerKt {
    @NotNull
    private static final Json json = JsonKt.Json$default(null, Introspection__Introspection_readerKt::json$lambda$0$Introspection__Introspection_readerKt, 1, null);

    @ApolloExperimental
    @NotNull
    public static final IntrospectionSchema toIntrospectionSchema(@NotNull BufferedSource $this$toIntrospectionSchema, @Nullable String filePath) {
        RSchema __schema;
        Intrinsics.checkNotNullParameter($this$toIntrospectionSchema, "<this>");
        ByteString bom = ByteString.Companion.decodeHex("EFBBBF");
        if ($this$toIntrospectionSchema.rangeEquals(0L, bom)) {
            $this$toIntrospectionSchema.skip(bom.size());
        }
        String string = $this$toIntrospectionSchema.readUtf8();
        Json this_$iv = json;
        boolean $i$f$decodeFromString = false;
        this_$iv.getSerializersModule();
        REnvelope envelope = (REnvelope)this_$iv.decodeFromString((DeserializationStrategy)REnvelope.Companion.serializer(), string);
        RSchema rSchema = envelope.get__schema();
        if (rSchema == null) {
            RData rData = envelope.getData();
            rSchema = rData != null ? rData.get__schema() : null;
        }
        if ((__schema = rSchema) == null) {
            StringBuilder stringBuilder = new StringBuilder().append("Invalid introspection schema '");
            String string2 = string.substring(0, 50);
            Intrinsics.checkNotNullExpressionValue(string2, "substring(...)");
            throw new ConversionException(stringBuilder.append(string2).append("': expected input should look like '{ \"__schema\": { \"types\": ...'").toString(), null, 2, null);
        }
        return new IntrospectionSchemaImpl(__schema, filePath);
    }

    public static /* synthetic */ IntrospectionSchema toIntrospectionSchema$default(BufferedSource bufferedSource, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        return Introspection.toIntrospectionSchema(bufferedSource, string);
    }

    @NotNull
    public static final IntrospectionSchema toIntrospectionSchema(@NotNull String $this$toIntrospectionSchema) {
        Intrinsics.checkNotNullParameter($this$toIntrospectionSchema, "<this>");
        return Introspection.toIntrospectionSchema$default(new Buffer().writeUtf8($this$toIntrospectionSchema), null, 1, null);
    }

    @NotNull
    public static final GQLDocument toGQLDocument(@NotNull IntrospectionSchema $this$toGQLDocument) {
        Intrinsics.checkNotNullParameter($this$toGQLDocument, "<this>");
        IntrospectionSchemaImpl cfr_ignored_0 = (IntrospectionSchemaImpl)$this$toGQLDocument;
        return new GQLDocumentBuilder((IntrospectionSchemaImpl)$this$toGQLDocument).toGQLDocument(((IntrospectionSchemaImpl)$this$toGQLDocument).getFilePath());
    }

    @ApolloInternal
    @NotNull
    public static final IntrospectionSchema normalize(@NotNull IntrospectionSchema $this$normalize) {
        Intrinsics.checkNotNullParameter($this$normalize, "<this>");
        IntrospectionSchemaImpl cfr_ignored_0 = (IntrospectionSchemaImpl)$this$normalize;
        RSchema $this$normalize_u24lambda_u244 = ((IntrospectionSchemaImpl)$this$normalize).get__schema();
        boolean bl = false;
        RTypeRoot rTypeRoot = $this$normalize_u24lambda_u244.getQueryType();
        Optional<RTypeRoot> optional = $this$normalize_u24lambda_u244.getMutationType();
        Optional<RTypeRoot> optional2 = $this$normalize_u24lambda_u244.getSubscriptionType();
        Iterable $this$sortedBy$iv = $this$normalize_u24lambda_u244.getTypes();
        boolean $i$f$sortedBy = false;
        List<RTypeFull> list = CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator(){

            public final int compare(T a, T b) {
                RTypeFull it = (RTypeFull)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getName());
                it = (RTypeFull)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, (Comparable)((Object)it.getName()));
            }
        });
        Optional<List> optional3 = $this$normalize_u24lambda_u244.getDirectives().mapValue(Introspection__Introspection_readerKt::normalize$lambda$4$lambda$3$Introspection__Introspection_readerKt);
        Optional<String> optional4 = $this$normalize_u24lambda_u244.getDescription();
        return new IntrospectionSchemaImpl(new RSchema(optional4, list, rTypeRoot, optional, optional2, optional3), null);
    }

    private static final Unit json$lambda$0$Introspection__Introspection_readerKt(JsonBuilder $this$Json) {
        Intrinsics.checkNotNullParameter($this$Json, "$this$Json");
        $this$Json.setIgnoreUnknownKeys(true);
        return Unit.INSTANCE;
    }

    private static final List normalize$lambda$4$lambda$3$Introspection__Introspection_readerKt(List it) {
        Intrinsics.checkNotNullParameter(it, "it");
        Iterable $this$sortedBy$iv = it;
        boolean $i$f$sortedBy = false;
        return CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator(){

            public final int compare(T a, T b) {
                RDirective it = (RDirective)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getName());
                it = (RDirective)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, (Comparable)((Object)it.getName()));
            }
        });
    }
}

