/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.compiler.codegen.java.operations;

import com.apollographql.apollo.compiler.codegen.LayoutImplKt;
import com.apollographql.apollo.compiler.codegen.java.CodegenJavaFile;
import com.apollographql.apollo.compiler.codegen.java.JavaClassBuilder;
import com.apollographql.apollo.compiler.codegen.java.JavaOperationsContext;
import com.apollographql.apollo.compiler.codegen.java.JavaResolver;
import com.apollographql.apollo.compiler.codegen.java.operations.util.VariablesAdapterKt;
import com.apollographql.apollo.compiler.ir.IrFragmentDefinition;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.TypeSpec;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/apollographql/apollo/compiler/codegen/java/operations/FragmentVariablesAdapterBuilder;", "Lcom/apollographql/apollo/compiler/codegen/java/JavaClassBuilder;", "context", "Lcom/apollographql/apollo/compiler/codegen/java/JavaOperationsContext;", "fragment", "Lcom/apollographql/apollo/compiler/ir/IrFragmentDefinition;", "<init>", "(Lcom/apollographql/apollo/compiler/codegen/java/JavaOperationsContext;Lcom/apollographql/apollo/compiler/ir/IrFragmentDefinition;)V", "getContext", "()Lcom/apollographql/apollo/compiler/codegen/java/JavaOperationsContext;", "getFragment", "()Lcom/apollographql/apollo/compiler/ir/IrFragmentDefinition;", "packageName", "", "simpleName", "prepare", "", "build", "Lcom/apollographql/apollo/compiler/codegen/java/CodegenJavaFile;", "typeSpec", "Lcom/squareup/javapoet/TypeSpec;", "apollo-compiler"})
public final class FragmentVariablesAdapterBuilder
implements JavaClassBuilder {
    @NotNull
    private final JavaOperationsContext context;
    @NotNull
    private final IrFragmentDefinition fragment;
    @NotNull
    private final String packageName;
    @NotNull
    private final String simpleName;

    public FragmentVariablesAdapterBuilder(@NotNull JavaOperationsContext context, @NotNull IrFragmentDefinition fragment) {
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(fragment, "fragment");
        this.context = context;
        this.fragment = fragment;
        this.packageName = LayoutImplKt.fragmentAdapterPackageName(this.context.getLayout(), this.fragment.getFilePath());
        this.simpleName = LayoutImplKt.variablesAdapter(LayoutImplKt.impl(this.context.getLayout().fragmentName(this.fragment.getName())));
    }

    @NotNull
    public final JavaOperationsContext getContext() {
        return this.context;
    }

    @NotNull
    public final IrFragmentDefinition getFragment() {
        return this.fragment;
    }

    @Override
    public void prepare() {
        JavaResolver javaResolver = this.context.getResolver();
        String string = this.fragment.getName();
        ClassName className = ClassName.get(this.packageName, this.simpleName, new String[0]);
        Intrinsics.checkNotNullExpressionValue(className, "get(...)");
        javaResolver.registerFragmentVariablesAdapter(string, className);
    }

    @Override
    @NotNull
    public CodegenJavaFile build() {
        return new CodegenJavaFile(this.packageName, this.typeSpec());
    }

    private final TypeSpec typeSpec() {
        return VariablesAdapterKt.variableAdapterTypeSpec(this.fragment.getVariables(), this.context, this.simpleName, this.context.getResolver().resolveFragment(this.fragment.getName()));
    }
}

