/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.compiler.codegen.java.operations;

import com.apollographql.apollo.ast.QueryDocumentMinifier;
import com.apollographql.apollo.compiler.GeneratedMethod;
import com.apollographql.apollo.compiler.codegen.FlattenKt;
import com.apollographql.apollo.compiler.codegen.LayoutImplKt;
import com.apollographql.apollo.compiler.codegen.OperationsLayout;
import com.apollographql.apollo.compiler.codegen.java.CodegenJavaFile;
import com.apollographql.apollo.compiler.codegen.java.JavaClassBuilder;
import com.apollographql.apollo.compiler.codegen.java.JavaClassNames;
import com.apollographql.apollo.compiler.codegen.java.JavaContextKt;
import com.apollographql.apollo.compiler.codegen.java.JavaOperationsContext;
import com.apollographql.apollo.compiler.codegen.java.JavaResolver;
import com.apollographql.apollo.compiler.codegen.java.helpers.BuilderBuilder;
import com.apollographql.apollo.compiler.codegen.java.helpers.DataClassKt;
import com.apollographql.apollo.compiler.codegen.java.helpers.DocKt;
import com.apollographql.apollo.compiler.codegen.java.helpers.NamedTypeKt;
import com.apollographql.apollo.compiler.codegen.java.operations.ExecutableCommonKt;
import com.apollographql.apollo.compiler.codegen.java.operations.ModelBuilder;
import com.apollographql.apollo.compiler.ir.IrModel;
import com.apollographql.apollo.compiler.ir.IrModelGroup;
import com.apollographql.apollo.compiler.ir.IrOperation;
import com.apollographql.apollo.compiler.ir.IrOperationType;
import com.apollographql.apollo.compiler.ir.IrVariable;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.lang.model.element.Modifier;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u0007\u0012\u0006\u0010\u000b\u001a\u00020\u0007\u00a2\u0006\u0004\b\f\u0010\rJ\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\u0006\u0010\u001b\u001a\u00020\u001cJ\b\u0010\u001d\u001a\u00020\u001eH\u0002J\b\u0010\u001f\u001a\u00020\u001eH\u0002J\b\u0010 \u001a\u00020\u001eH\u0002J\u000e\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001c0\u0015H\u0002J\b\u0010\"\u001a\u00020#H\u0002J\u0015\u0010$\u001a\n %*\u0004\u0018\u00010\u001e0\u001eH\u0002\u00a2\u0006\u0002\u0010&J\u001d\u0010'\u001a\n %*\u0004\u0018\u00010\u001e0\u001e2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a2\u0006\u0002\u0010(J\u0015\u0010)\u001a\n %*\u0004\u0018\u00010\u001e0\u001eH\u0002\u00a2\u0006\u0002\u0010&J\f\u0010*\u001a\u00020\u0005*\u00020\u0005H\u0002J\b\u0010+\u001a\u00020\u001eH\u0002J\u0014\u0010,\u001a\u00020-*\u00020-2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/apollographql/apollo/compiler/codegen/java/operations/OperationBuilder;", "Lcom/apollographql/apollo/compiler/codegen/java/JavaClassBuilder;", "context", "Lcom/apollographql/apollo/compiler/codegen/java/JavaOperationsContext;", "operationId", "", "generateQueryDocument", "", "operation", "Lcom/apollographql/apollo/compiler/ir/IrOperation;", "generateDataBuilders", "flatten", "<init>", "(Lcom/apollographql/apollo/compiler/codegen/java/JavaOperationsContext;Ljava/lang/String;ZLcom/apollographql/apollo/compiler/ir/IrOperation;ZZ)V", "layout", "Lcom/apollographql/apollo/compiler/codegen/OperationsLayout;", "packageName", "simpleName", "dataSuperClassName", "Lcom/squareup/javapoet/ClassName;", "modelBuilders", "", "Lcom/apollographql/apollo/compiler/codegen/java/operations/ModelBuilder;", "prepare", "", "build", "Lcom/apollographql/apollo/compiler/codegen/java/CodegenJavaFile;", "typeSpec", "Lcom/squareup/javapoet/TypeSpec;", "buildDataMethod", "Lcom/squareup/javapoet/MethodSpec;", "buildDataOverloadMethod", "serializeVariablesMethodSpec", "dataTypeSpecs", "superInterfaceType", "Lcom/squareup/javapoet/TypeName;", "operationIdMethodSpec", "kotlin.jvm.PlatformType", "()Lcom/squareup/javapoet/MethodSpec;", "queryDocumentMethodSpec", "(Z)Lcom/squareup/javapoet/MethodSpec;", "nameMethodSpec", "asJavadocCodeBlock", "rootFieldMethodSpec", "addBuilder", "Lcom/squareup/javapoet/TypeSpec$Builder;", "apollo-compiler"})
@SourceDebugExtension(value={"SMAP\nOperationBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OperationBuilder.kt\ncom/apollographql/apollo/compiler/codegen/java/operations/OperationBuilder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 scoping.kt\ncom/apollographql/apollo/compiler/internal/ScopingKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,291:1\n1368#2:292\n1454#2,5:293\n1557#2:298\n1628#2,3:299\n1863#2,2:302\n1557#2:304\n1628#2,3:305\n1557#2:310\n1628#2,3:311\n1557#2:314\n1628#2,3:315\n3#3:308\n3#3:309\n1#4:318\n*S KotlinDebug\n*F\n+ 1 OperationBuilder.kt\ncom/apollographql/apollo/compiler/codegen/java/operations/OperationBuilder\n*L\n61#1:292\n61#1:293,5\n63#1:298\n63#1:299,3\n77#1:302,2\n94#1:304\n94#1:305,3\n200#1:310\n200#1:311,3\n273#1:314\n273#1:315,3\n104#1:308\n117#1:309\n*E\n"})
public final class OperationBuilder
implements JavaClassBuilder {
    @NotNull
    private final JavaOperationsContext context;
    @NotNull
    private final String operationId;
    private final boolean generateQueryDocument;
    @NotNull
    private final IrOperation operation;
    private final boolean generateDataBuilders;
    @NotNull
    private final OperationsLayout layout;
    @NotNull
    private final String packageName;
    @NotNull
    private final String simpleName;
    @NotNull
    private final ClassName dataSuperClassName;
    @NotNull
    private final List<ModelBuilder> modelBuilders;

    /*
     * WARNING - void declaration
     */
    public OperationBuilder(@NotNull JavaOperationsContext context, @NotNull String operationId, boolean generateQueryDocument, @NotNull IrOperation operation, boolean generateDataBuilders, boolean flatten2) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Object list$iv$iv;
        IrModelGroup it;
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv;
        ClassName className;
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(operationId, "operationId");
        Intrinsics.checkNotNullParameter(operation, "operation");
        this.context = context;
        this.operationId = operationId;
        this.generateQueryDocument = generateQueryDocument;
        this.operation = operation;
        this.generateDataBuilders = generateDataBuilders;
        this.layout = this.context.getLayout();
        this.packageName = this.layout.executableDocumentPackageName(this.operation.getNormalizedFilePath());
        this.simpleName = LayoutImplKt.operationName(this.layout, this.operation);
        Object object = this.operation.getOperationType();
        if (object instanceof IrOperationType.Query) {
            className = JavaClassNames.INSTANCE.getQueryData();
        } else if (object instanceof IrOperationType.Mutation) {
            className = JavaClassNames.INSTANCE.getMutationData();
        } else if (object instanceof IrOperationType.Subscription) {
            className = JavaClassNames.INSTANCE.getSubscriptionData();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        this.dataSuperClassName = className;
        object = FlattenKt.maybeFlatten$default(this.operation.getDataModelGroup(), flatten2, 0, SetsKt.setOf(this.simpleName), 2, null);
        OperationBuilder operationBuilder = this;
        boolean $i$f$flatMap = false;
        void var9_10 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (IrModelGroup)element$iv$iv;
            boolean bl = false;
            list$iv$iv = it.getModels();
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$flatMapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            list$iv$iv = (IrModel)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String[] stringArray = new String[]{this.packageName, this.simpleName};
            collection.add(new ModelBuilder(this.context, (IrModel)((Object)it), Intrinsics.areEqual(((IrModel)((Object)it)).getId(), this.operation.getDataModelGroup().getBaseModelId()) ? this.dataSuperClassName : null, CollectionsKt.listOf(stringArray)));
        }
        operationBuilder.modelBuilders = (List)destination$iv$iv;
    }

    @Override
    public void prepare() {
        JavaResolver javaResolver = this.context.getResolver();
        String string = this.operation.getName();
        ClassName className = ClassName.get(this.packageName, this.simpleName, new String[0]);
        Intrinsics.checkNotNullExpressionValue(className, "get(...)");
        javaResolver.registerOperation(string, className);
        Iterable $this$forEach$iv = this.modelBuilders;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ModelBuilder it = (ModelBuilder)element$iv;
            boolean bl = false;
            it.prepare();
        }
    }

    @Override
    @NotNull
    public CodegenJavaFile build() {
        return new CodegenJavaFile(this.packageName, this.typeSpec());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final TypeSpec typeSpec() {
        Object object;
        void v1;
        Object object2;
        Object $this$applyIf$iv;
        Collection<ParameterSpec> collection;
        void $this$mapTo$iv$iv;
        TypeSpec.Builder $this$map$iv;
        Modifier[] modifierArray = new Modifier[]{Modifier.PUBLIC};
        TypeSpec.Builder builder = TypeSpec.classBuilder(LayoutImplKt.operationName(this.layout, this.operation)).addModifiers(modifierArray).addSuperinterface(this.superInterfaceType());
        Intrinsics.checkNotNullExpressionValue(builder, "addSuperinterface(...)");
        Object[] objectArray = (Modifier[])this.operation.getVariables();
        List<GeneratedMethod> list = this.context.getGenerateMethods();
        TypeSpec.Builder builder2 = DocKt.maybeAddDescription(builder, this.operation.getDescription());
        OperationBuilder operationBuilder = this;
        boolean $i$f$map = false;
        void var4_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IrVariable irVariable = (IrVariable)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(NamedTypeKt.toParameterSpec(NamedTypeKt.toNamedType((IrVariable)it), this.context));
        }
        collection = (List)destination$iv$iv;
        $this$map$iv = operationBuilder.addBuilder(DataClassKt.makeClassFromParameters(builder2, list, (List<ParameterSpec>)collection, this.context.getResolver().resolveOperation(this.operation.getName())), this.context).addMethod(this.operationIdMethodSpec()).addMethod(this.queryDocumentMethodSpec(this.generateQueryDocument)).addMethod(this.nameMethodSpec()).addMethod(this.serializeVariablesMethodSpec()).addMethod(ExecutableCommonKt.adapterMethodSpec(this.context.getResolver(), this.operation.getDataProperty())).addMethod(this.rootFieldMethodSpec());
        boolean condition$iv = this.generateDataBuilders;
        boolean $i$f$applyIf = false;
        if (condition$iv) {
            object2 = $this$applyIf$iv;
            void $this$typeSpec_u24lambda_u244 = object2;
            boolean bl = false;
            $this$typeSpec_u24lambda_u244.addMethod(this.buildDataMethod());
            $this$typeSpec_u24lambda_u244.addMethod(this.buildDataOverloadMethod());
            v1 = object2;
        } else {
            v1 = $this$applyIf$iv;
        }
        $this$applyIf$iv = new Modifier[]{Modifier.FINAL};
        FieldSpec.Builder builder3 = FieldSpec.builder(JavaClassNames.INSTANCE.getString(), "OPERATION_ID", new Modifier[0]).addModifiers((Modifier[])$this$applyIf$iv);
        $this$applyIf$iv = new Modifier[]{Modifier.STATIC};
        FieldSpec.Builder builder4 = builder3.addModifiers((Modifier[])$this$applyIf$iv);
        $this$applyIf$iv = new Modifier[]{Modifier.PUBLIC};
        FieldSpec.Builder builder5 = builder4.addModifiers((Modifier[])$this$applyIf$iv);
        $this$applyIf$iv = new Object[]{this.operationId};
        $this$applyIf$iv = v1.addTypes((Iterable<TypeSpec>)this.dataTypeSpecs()).addField(builder5.initializer("$S", (Object[])$this$applyIf$iv).build());
        condition$iv = this.generateQueryDocument;
        $i$f$applyIf = false;
        if (condition$iv) {
            Object $this$typeSpec_u24lambda_u245 = object2 = $this$applyIf$iv;
            boolean bl = false;
            Object[] objectArray2 = new Modifier[]{Modifier.FINAL};
            FieldSpec.Builder builder6 = FieldSpec.builder(JavaClassNames.INSTANCE.getString(), "OPERATION_DOCUMENT", new Modifier[0]).addModifiers((Modifier[])objectArray2);
            objectArray2 = new Modifier[]{Modifier.STATIC};
            FieldSpec.Builder builder7 = builder6.addModifiers((Modifier[])objectArray2);
            objectArray2 = new Modifier[]{Modifier.PUBLIC};
            FieldSpec.Builder builder8 = builder7.addModifiers((Modifier[])objectArray2);
            objectArray2 = new Object[]{QueryDocumentMinifier.minify(this.operation.getSourceWithFragments())};
            FieldSpec.Builder builder9 = builder8.initializer("$S", objectArray2);
            objectArray2 = new Object[]{"The minimized GraphQL document being sent to the server to save a few bytes.\nThe un-minimized version is:\n\n" + this.asJavadocCodeBlock(this.operation.getSourceWithFragments())};
            ((TypeSpec.Builder)$this$typeSpec_u24lambda_u245).addField(builder9.addJavadoc("$L", objectArray2).build());
            object = object2;
        } else {
            object = objectArray;
        }
        objectArray = new Modifier[]{Modifier.FINAL};
        FieldSpec.Builder builder10 = FieldSpec.builder(JavaClassNames.INSTANCE.getString(), "OPERATION_NAME", new Modifier[0]).addModifiers((Modifier[])objectArray);
        objectArray = new Modifier[]{Modifier.STATIC};
        FieldSpec.Builder builder11 = builder10.addModifiers((Modifier[])objectArray);
        objectArray = new Modifier[]{Modifier.PUBLIC};
        FieldSpec.Builder builder12 = builder11.addModifiers((Modifier[])objectArray);
        objectArray = new Object[]{this.operation.getName()};
        TypeSpec typeSpec = object.addField(builder12.initializer("$S", objectArray).build()).build();
        Intrinsics.checkNotNullExpressionValue(typeSpec, "build(...)");
        return typeSpec;
    }

    private final MethodSpec buildDataMethod() {
        Object[] objectArray = new Modifier[]{Modifier.PUBLIC, Modifier.STATIC};
        MethodSpec.Builder builder = MethodSpec.methodBuilder("buildData").addModifiers((Modifier[])objectArray).addParameter(this.context.getResolver().resolveMapType(this.operation.getOperationType().getTypeName()), "map", new Modifier[0]).addParameter(JavaClassNames.INSTANCE.getFakeResolver(), "resolver", new Modifier[0]).returns(this.context.getResolver().resolveModel(this.operation.getDataModelGroup().getBaseModelId()));
        objectArray = new Object[]{JavaClassNames.INSTANCE.getFakeResolverKt()};
        CodeBlock.Builder builder2 = CodeBlock.builder().add("return $T.buildData(\n", objectArray).indent();
        objectArray = new Object[]{this.context.getResolver().resolveModelAdapter(this.operation.getDataModelGroup().getBaseModelId())};
        CodeBlock.Builder builder3 = builder2.add("$L.INSTANCE,\n", objectArray);
        objectArray = new Object[]{this.context.getResolver().resolveOperationSelections(this.operation.getName())};
        CodeBlock.Builder builder4 = builder3.add("$T.__root,\n", objectArray);
        objectArray = new Object[]{this.operation.getOperationType().getTypeName()};
        CodeBlock.Builder builder5 = builder4.add("$S,\n", objectArray).add("map,\n", new Object[0]).add("resolver,\n", new Object[0]);
        objectArray = new Object[]{this.context.getResolver().resolveSchema()};
        MethodSpec methodSpec = builder.addCode(builder5.add("$T.customScalarAdapters\n", objectArray).unindent().add(");", new Object[0]).build()).build();
        Intrinsics.checkNotNullExpressionValue(methodSpec, "build(...)");
        return methodSpec;
    }

    private final MethodSpec buildDataOverloadMethod() {
        Object[] objectArray = new Modifier[]{Modifier.PUBLIC, Modifier.STATIC};
        MethodSpec.Builder builder = MethodSpec.methodBuilder("buildData").addModifiers((Modifier[])objectArray).addParameter(this.context.getResolver().resolveMapType(this.operation.getOperationType().getTypeName()), "map", new Modifier[0]).returns(this.context.getResolver().resolveModel(this.operation.getDataModelGroup().getBaseModelId()));
        objectArray = new Object[]{JavaClassNames.INSTANCE.getDefaultFakeResolver(), this.context.getResolver().resolveSchema()};
        MethodSpec methodSpec = builder.addStatement("return buildData(map, new $T($T.types))", objectArray).build();
        Intrinsics.checkNotNullExpressionValue(methodSpec, "build(...)");
        return methodSpec;
    }

    private final MethodSpec serializeVariablesMethodSpec() {
        return ExecutableCommonKt.serializeVariablesMethodSpec(this.context.getResolver().resolveOperationVariablesAdapter(this.operation.getName()), "This operation doesn't have any variable");
    }

    /*
     * WARNING - void declaration
     */
    private final List<TypeSpec> dataTypeSpecs() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.modelBuilders;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ModelBuilder modelBuilder = (ModelBuilder)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.build());
        }
        return (List)destination$iv$iv;
    }

    private final TypeName superInterfaceType() {
        ClassName className;
        IrOperationType irOperationType = this.operation.getOperationType();
        if (irOperationType instanceof IrOperationType.Query) {
            className = JavaClassNames.INSTANCE.getQuery();
        } else if (irOperationType instanceof IrOperationType.Mutation) {
            className = JavaClassNames.INSTANCE.getMutation();
        } else if (irOperationType instanceof IrOperationType.Subscription) {
            className = JavaClassNames.INSTANCE.getSubscription();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        ClassName it = className;
        boolean bl = false;
        TypeName[] typeNameArray = new TypeName[]{this.context.getResolver().resolveModel(this.operation.getDataModelGroup().getBaseModelId())};
        ParameterizedTypeName parameterizedTypeName = ParameterizedTypeName.get(it, typeNameArray);
        Intrinsics.checkNotNullExpressionValue(parameterizedTypeName, "let(...)");
        return parameterizedTypeName;
    }

    private final MethodSpec operationIdMethodSpec() {
        Modifier[] modifierArray = new Modifier[]{Modifier.PUBLIC};
        return MethodSpec.methodBuilder("id").addModifiers(modifierArray).addAnnotation(JavaClassNames.INSTANCE.getOverride()).returns(JavaClassNames.INSTANCE.getString()).addStatement("return OPERATION_ID", new Object[0]).build();
    }

    private final MethodSpec queryDocumentMethodSpec(boolean generateQueryDocument) {
        Object object = new Modifier[]{Modifier.PUBLIC};
        Object $this$queryDocumentMethodSpec_u24lambda_u248 = object = MethodSpec.methodBuilder("document").addModifiers((Modifier[])object).addAnnotation(JavaClassNames.INSTANCE.getOverride()).returns(JavaClassNames.INSTANCE.getString());
        boolean bl = false;
        MethodSpec.Builder builder = generateQueryDocument ? ((MethodSpec.Builder)$this$queryDocumentMethodSpec_u24lambda_u248).addStatement("return OPERATION_DOCUMENT", new Object[0]) : ((MethodSpec.Builder)$this$queryDocumentMethodSpec_u24lambda_u248).addStatement("error(\"The query document was removed from this operation. Use generateQueryDocument.set(true) if you need it\")", new Object[0]);
        return ((MethodSpec.Builder)object).build();
    }

    private final MethodSpec nameMethodSpec() {
        Modifier[] modifierArray = new Modifier[]{Modifier.PUBLIC};
        return MethodSpec.methodBuilder("name").addModifiers(modifierArray).addAnnotation(JavaClassNames.INSTANCE.getOverride()).returns(JavaClassNames.INSTANCE.getString()).addStatement("return OPERATION_NAME", new Object[0]).build();
    }

    private final String asJavadocCodeBlock(String $this$asJavadocCodeBlock) {
        return $this$asJavadocCodeBlock;
    }

    private final MethodSpec rootFieldMethodSpec() {
        return ExecutableCommonKt.rootFieldMethodSpec(this.context, this.operation.getTypeCondition(), this.context.getResolver().resolveOperationSelections(this.operation.getName()));
    }

    /*
     * WARNING - void declaration
     */
    private final TypeSpec.Builder addBuilder(TypeSpec.Builder $this$addBuilder, JavaOperationsContext context) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        $this$addBuilder.addMethod(BuilderBuilder.Companion.builderFactoryMethod());
        ClassName operationClassName = context.getResolver().resolveOperation(this.operation.getName());
        if (this.operation.getVariables().isEmpty()) {
            TypeSpec.Builder builder = $this$addBuilder.addType(new BuilderBuilder(operationClassName, CollectionsKt.emptyList(), context).build());
            Intrinsics.checkNotNullExpressionValue(builder, "addType(...)");
            return builder;
        }
        Iterable iterable = this.operation.getVariables();
        boolean $i$f$map = false;
        void var6_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IrVariable irVariable = (IrVariable)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            TypeName irType = context.getResolver().resolveIrType(it.getType());
            collection.add(FieldSpec.builder(irType.withoutAnnotations(), JavaContextKt.javaPropertyName(context.getLayout(), it.getName()), new Modifier[0]).addAnnotations((Iterable<AnnotationSpec>)irType.annotations).build());
        }
        Object it = (List)destination$iv$iv;
        boolean bl = false;
        it = new BuilderBuilder(operationClassName, (List<FieldSpec>)it, context);
        boolean bl2 = false;
        $this$addBuilder.addType(((BuilderBuilder)it).build());
        return $this$addBuilder;
    }
}

