/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.compiler.codegen.kotlin.helpers;

import com.apollographql.apollo.compiler.codegen.kotlin.KotlinSymbols;
import com.apollographql.apollo.compiler.codegen.kotlin.helpers.CollectionsKt;
import com.apollographql.apollo.compiler.ir.IrBooleanValue;
import com.apollographql.apollo.compiler.ir.IrEnumValue;
import com.apollographql.apollo.compiler.ir.IrFloatValue;
import com.apollographql.apollo.compiler.ir.IrIntValue;
import com.apollographql.apollo.compiler.ir.IrListValue;
import com.apollographql.apollo.compiler.ir.IrNullValue;
import com.apollographql.apollo.compiler.ir.IrObjectValue;
import com.apollographql.apollo.compiler.ir.IrStringValue;
import com.apollographql.apollo.compiler.ir.IrValue;
import com.apollographql.apollo.compiler.ir.IrVariableValue;
import com.squareup.kotlinpoet.CodeBlock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u0014\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0002H\u0002\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0003H\u0002\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0004H\u0000\u00a8\u0006\u0005"}, d2={"codeBlock", "Lcom/squareup/kotlinpoet/CodeBlock;", "Lcom/apollographql/apollo/compiler/ir/IrListValue;", "Lcom/apollographql/apollo/compiler/ir/IrObjectValue;", "Lcom/apollographql/apollo/compiler/ir/IrValue;", "apollo-compiler"})
@SourceDebugExtension(value={"SMAP\nValue.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Value.kt\ncom/apollographql/apollo/compiler/codegen/kotlin/helpers/ValueKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,70:1\n1557#2:71\n1628#2,3:72\n1557#2:75\n1628#2,3:76\n*S KotlinDebug\n*F\n+ 1 Value.kt\ncom/apollographql/apollo/compiler/codegen/kotlin/helpers/ValueKt\n*L\n22#1:71\n22#1:72,3\n31#1:75\n31#1:76,3\n*E\n"})
public final class ValueKt {
    /*
     * WARNING - void declaration
     */
    private static final CodeBlock codeBlock(IrListValue $this$codeBlock) {
        void $this$mapTo$iv$iv;
        if ($this$codeBlock.getValues().isEmpty()) {
            return CodeBlock.Companion.of("emptyList<Nothing>()", new Object[0]);
        }
        Iterable $this$map$iv = $this$codeBlock.getValues();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IrValue irValue = (IrValue)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(ValueKt.codeBlock((IrValue)it));
        }
        return CollectionsKt.toListInitializerCodeblock((List)destination$iv$iv, true);
    }

    /*
     * WARNING - void declaration
     */
    private static final CodeBlock codeBlock(IrObjectValue $this$codeBlock) {
        void $this$mapTo$iv$iv;
        if ($this$codeBlock.getFields().isEmpty()) {
            return CodeBlock.Companion.of("emptyMap<Nothing, Nothing>()", new Object[0]);
        }
        Iterable $this$map$iv = $this$codeBlock.getFields();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IrObjectValue.Field field = (IrObjectValue.Field)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TuplesKt.to(it.getName(), ValueKt.codeBlock(it.getValue())));
        }
        return CollectionsKt.toMapInitializerCodeblock((List)destination$iv$iv, true);
    }

    @NotNull
    public static final CodeBlock codeBlock(@NotNull IrValue $this$codeBlock) {
        CodeBlock codeBlock;
        Intrinsics.checkNotNullParameter($this$codeBlock, "<this>");
        IrValue irValue = $this$codeBlock;
        if (irValue instanceof IrBooleanValue) {
            Object[] objectArray = new Object[]{((IrBooleanValue)$this$codeBlock).getValue()};
            codeBlock = CodeBlock.Companion.of("%L", objectArray);
        } else if (irValue instanceof IrEnumValue) {
            Object[] objectArray = new Object[]{((IrEnumValue)$this$codeBlock).getValue()};
            codeBlock = CodeBlock.Companion.of("%S", objectArray);
        } else if (irValue instanceof IrIntValue) {
            Integer asInt = StringsKt.toIntOrNull(((IrIntValue)$this$codeBlock).getValue());
            if (asInt != null) {
                Object[] objectArray = new Object[]{((IrIntValue)$this$codeBlock).getValue()};
                codeBlock = CodeBlock.Companion.of("%L", objectArray);
            } else {
                Object[] objectArray = new Object[]{KotlinSymbols.INSTANCE.getJsonNumber(), ((IrIntValue)$this$codeBlock).getValue()};
                codeBlock = CodeBlock.Companion.of("%T(%S)", objectArray);
            }
        } else if (irValue instanceof IrFloatValue) {
            Double asDouble = StringsKt.toDoubleOrNull(((IrFloatValue)$this$codeBlock).getValue());
            if (asDouble != null) {
                Object[] objectArray = new Object[]{((IrFloatValue)$this$codeBlock).getValue()};
                codeBlock = CodeBlock.Companion.of("%L", objectArray);
            } else {
                Object[] objectArray = new Object[]{KotlinSymbols.INSTANCE.getJsonNumber(), ((IrFloatValue)$this$codeBlock).getValue()};
                codeBlock = CodeBlock.Companion.of("%T(%S)", objectArray);
            }
        } else if (irValue instanceof IrListValue) {
            codeBlock = ValueKt.codeBlock((IrListValue)$this$codeBlock);
        } else if (Intrinsics.areEqual(irValue, IrNullValue.INSTANCE)) {
            codeBlock = CodeBlock.Companion.of("null", new Object[0]);
        } else if (irValue instanceof IrObjectValue) {
            codeBlock = ValueKt.codeBlock((IrObjectValue)$this$codeBlock);
        } else if (irValue instanceof IrStringValue) {
            Object[] objectArray = new Object[]{((IrStringValue)$this$codeBlock).getValue()};
            codeBlock = CodeBlock.Companion.of("%S", objectArray);
        } else if (irValue instanceof IrVariableValue) {
            Object[] objectArray = new Object[]{KotlinSymbols.INSTANCE.getCompiledVariable(), ((IrVariableValue)$this$codeBlock).getName()};
            codeBlock = CodeBlock.Companion.of("%T(%S)", objectArray);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return codeBlock;
    }
}

