/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.compiler.codegen.kotlin.schema;

import com.apollographql.apollo.compiler.codegen.LayoutImplKt;
import com.apollographql.apollo.compiler.codegen.SchemaLayout;
import com.apollographql.apollo.compiler.codegen.kotlin.CgFile;
import com.apollographql.apollo.compiler.codegen.kotlin.CgFileBuilder;
import com.apollographql.apollo.compiler.codegen.kotlin.KotlinSchemaContext;
import com.apollographql.apollo.compiler.codegen.kotlin.helpers.KDocKt;
import com.apollographql.apollo.compiler.codegen.kotlin.schema.util.TypesBuilderKt;
import com.apollographql.apollo.compiler.ir.IrScalar;
import com.squareup.kotlinpoet.ClassName;
import com.squareup.kotlinpoet.TypeSpec;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0007H\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\f\u0010\u0014\u001a\u00020\u0015*\u00020\u0005H\u0002J\f\u0010\u0016\u001a\u00020\u0015*\u00020\u0005H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/apollographql/apollo/compiler/codegen/kotlin/schema/ScalarBuilder;", "Lcom/apollographql/apollo/compiler/codegen/kotlin/CgFileBuilder;", "context", "Lcom/apollographql/apollo/compiler/codegen/kotlin/KotlinSchemaContext;", "scalar", "Lcom/apollographql/apollo/compiler/ir/IrScalar;", "targetTypeName", "", "<init>", "(Lcom/apollographql/apollo/compiler/codegen/kotlin/KotlinSchemaContext;Lcom/apollographql/apollo/compiler/ir/IrScalar;Ljava/lang/String;)V", "layout", "Lcom/apollographql/apollo/compiler/codegen/SchemaLayout;", "packageName", "simpleName", "prefixBuiltinScalarNames", "name", "prepare", "", "build", "Lcom/apollographql/apollo/compiler/codegen/kotlin/CgFile;", "typeSpec", "Lcom/squareup/kotlinpoet/TypeSpec;", "companionTypeSpec", "apollo-compiler"})
public final class ScalarBuilder
implements CgFileBuilder {
    @NotNull
    private final KotlinSchemaContext context;
    @NotNull
    private final IrScalar scalar;
    @Nullable
    private final String targetTypeName;
    @NotNull
    private final SchemaLayout layout;
    @NotNull
    private final String packageName;
    @NotNull
    private final String simpleName;

    public ScalarBuilder(@NotNull KotlinSchemaContext context, @NotNull IrScalar scalar, @Nullable String targetTypeName) {
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(scalar, "scalar");
        this.context = context;
        this.scalar = scalar;
        this.targetTypeName = targetTypeName;
        this.layout = this.context.getLayout();
        this.packageName = LayoutImplKt.typePackageName(this.layout);
        this.simpleName = this.prefixBuiltinScalarNames(this.layout.schemaTypeName(this.scalar.getName()));
    }

    private final String prefixBuiltinScalarNames(String name) {
        String[] stringArray = new String[]{"String", "Boolean", "Int", "Float", "ID"};
        if (ArraysKt.contains(stringArray, name)) {
            return "GraphQL" + name;
        }
        return name;
    }

    @Override
    public void prepare() {
        String[] stringArray = new String[]{this.simpleName};
        this.context.getResolver().registerSchemaType(this.scalar.getName(), new ClassName(this.packageName, stringArray));
    }

    @Override
    @NotNull
    public CgFile build() {
        String string = this.packageName;
        String string2 = this.simpleName;
        List<TypeSpec> list = CollectionsKt.listOf(this.typeSpec(this.scalar));
        return new CgFile(string, list, null, null, string2, null, 44, null);
    }

    private final TypeSpec typeSpec(IrScalar $this$typeSpec) {
        return KDocKt.maybeAddDeprecation(KDocKt.maybeAddDescription(TypeSpec.Companion.classBuilder(this.simpleName), $this$typeSpec.getDescription()), $this$typeSpec.getDeprecationReason()).addType(this.companionTypeSpec($this$typeSpec)).build();
    }

    private final TypeSpec companionTypeSpec(IrScalar $this$companionTypeSpec) {
        return TypeSpec.Companion.companionObjectBuilder$default(TypeSpec.Companion, null, 1, null).addProperty(TypesBuilderKt.typePropertySpec($this$companionTypeSpec, this.targetTypeName)).build();
    }
}

