/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.gradle.internal;

import com.apollographql.apollo.gradle.api.Service;
import com.apollographql.apollo.gradle.internal.AndroidPluginFacadeKt;
import com.apollographql.apollo.gradle.internal.JavaProjectKt;
import com.apollographql.apollo.gradle.internal.KotlinProjectKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.Directory;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.plugin.KotlinSourceSet;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0019\u001a\u00020\u0011H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001a"}, d2={"Lcom/apollographql/apollo/gradle/internal/DefaultDirectoryConnection;", "Lcom/apollographql/apollo/gradle/api/Service$DirectoryConnection;", "project", "Lorg/gradle/api/Project;", "task", "Lorg/gradle/api/tasks/TaskProvider;", "Lorg/gradle/api/Task;", "outputDir", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/Directory;", "<init>", "(Lorg/gradle/api/Project;Lorg/gradle/api/tasks/TaskProvider;Lorg/gradle/api/provider/Provider;)V", "getTask", "()Lorg/gradle/api/tasks/TaskProvider;", "getOutputDir", "()Lorg/gradle/api/provider/Provider;", "connectToKotlinSourceSet", "", "name", "", "connectToJavaSourceSet", "connectToAndroidVariant", "variant", "", "connectToAndroidSourceSet", "connectToAllAndroidVariants", "apollo-gradle-plugin-external"})
public final class DefaultDirectoryConnection
implements Service.DirectoryConnection {
    @NotNull
    private final Project project;
    @NotNull
    private final TaskProvider<? extends Task> task;
    @NotNull
    private final Provider<Directory> outputDir;

    public DefaultDirectoryConnection(@NotNull Project project, @NotNull TaskProvider<? extends Task> task, @NotNull Provider<Directory> outputDir) {
        Intrinsics.checkNotNullParameter(project, "project");
        Intrinsics.checkNotNullParameter(task, "task");
        Intrinsics.checkNotNullParameter(outputDir, "outputDir");
        this.project = project;
        this.task = task;
        this.outputDir = outputDir;
    }

    @Override
    @NotNull
    public TaskProvider<? extends Task> getTask() {
        return this.task;
    }

    @Override
    @NotNull
    public Provider<Directory> getOutputDir() {
        return this.outputDir;
    }

    @Override
    public void connectToKotlinSourceSet(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        ((KotlinSourceSet)KotlinProjectKt.getKotlinProjectExtensionOrThrow(this.project).getSourceSets().getByName(name)).getKotlin().srcDir(this.getOutputDir());
    }

    @Override
    public void connectToJavaSourceSet(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        ((SourceSet)JavaProjectKt.getJavaExtensionOrThrow(this.project).getSourceSets().getByName(name)).getJava().srcDir(this.getOutputDir());
    }

    @Override
    public void connectToAndroidVariant(@NotNull Object variant) {
        Intrinsics.checkNotNullParameter(variant, "variant");
        AndroidPluginFacadeKt.connectToAndroidVariant(this.project, variant, this.getOutputDir(), this.getTask());
    }

    @Override
    public void connectToAndroidSourceSet(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        AndroidPluginFacadeKt.connectToAndroidSourceSet(this.project, name, this.getOutputDir(), this.getTask());
    }

    @Override
    public void connectToAllAndroidVariants() {
        AndroidPluginFacadeKt.connectToAllAndroidVariants(this.project, this.getOutputDir(), this.getTask());
    }
}

