/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.network.websocket;

import com.apollographql.apollo.api.ApolloRequest;
import com.apollographql.apollo.api.ApolloResponse;
import com.apollographql.apollo.api.CustomScalarAdapters;
import com.apollographql.apollo.api.Operation;
import com.apollographql.apollo.api.Operations;
import com.apollographql.apollo.api.json.-JsonReaders;
import com.apollographql.apollo.exception.DefaultApolloException;
import com.apollographql.apollo.internal.DeferredJsonMerger;
import com.apollographql.apollo.network.websocket.SubscriptionParser;
import com.apollographql.apollo.network.websocket.WebSocketNetworkTransportKt;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0002\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0015\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J#\u0010\f\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\r2\f\u0010\u000e\u001a\b\u0018\u00010\u0010j\u0002`\u000fH\u0016\u00a2\u0006\u0002\u0010\u0011R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/apollographql/apollo/network/websocket/DefaultSubscriptionParser;", "D", "Lcom/apollographql/apollo/api/Operation$Data;", "Lcom/apollographql/apollo/network/websocket/SubscriptionParser;", "request", "Lcom/apollographql/apollo/api/ApolloRequest;", "<init>", "(Lcom/apollographql/apollo/api/ApolloRequest;)V", "deferredJsonMerger", "Lcom/apollographql/apollo/internal/DeferredJsonMerger;", "requestCustomScalarAdapters", "Lcom/apollographql/apollo/api/CustomScalarAdapters;", "parse", "Lcom/apollographql/apollo/api/ApolloResponse;", "response", "Lcom/apollographql/apollo/api/json/ApolloJsonElement;", "", "(Ljava/lang/Object;)Lcom/apollographql/apollo/api/ApolloResponse;", "apollo-runtime"})
final class DefaultSubscriptionParser<D extends Operation.Data>
implements SubscriptionParser<D> {
    @NotNull
    private final ApolloRequest<D> request;
    @NotNull
    private DeferredJsonMerger deferredJsonMerger;
    @NotNull
    private final CustomScalarAdapters requestCustomScalarAdapters;

    public DefaultSubscriptionParser(@NotNull ApolloRequest<D> request) {
        Intrinsics.checkNotNullParameter(request, "request");
        this.request = request;
        this.deferredJsonMerger = new DeferredJsonMerger();
        CustomScalarAdapters customScalarAdapters = (CustomScalarAdapters)this.request.getExecutionContext().get(CustomScalarAdapters.Key);
        if (customScalarAdapters == null) {
            customScalarAdapters = CustomScalarAdapters.Empty;
        }
        this.requestCustomScalarAdapters = customScalarAdapters;
    }

    @Override
    @Nullable
    public ApolloResponse<D> parse(@Nullable Object response2) {
        Map responseMap;
        Map map2 = responseMap = response2 instanceof Map ? (Map)response2 : null;
        if (responseMap == null) {
            return new ApolloResponse.Builder<D>(this.request.getOperation(), this.request.getRequestUuid()).exception(new DefaultApolloException("Invalid payload", null, 2, null)).build();
        }
        Pair<Map, Object> pair = WebSocketNetworkTransportKt.access$isDeferred(responseMap) ? TuplesKt.to(this.deferredJsonMerger.merge(responseMap), this.deferredJsonMerger.getMergedFragmentIds()) : TuplesKt.to(responseMap, null);
        Map payload = pair.component1();
        Set mergedFragmentIds = pair.component2();
        ApolloResponse<D> apolloResponse = Operations.toApolloResponse(-JsonReaders.jsonReader(payload), this.request.getOperation(), this.request.getRequestUuid(), this.requestCustomScalarAdapters, mergedFragmentIds);
        if (!this.deferredJsonMerger.getHasNext()) {
            this.deferredJsonMerger.reset();
        }
        if (this.deferredJsonMerger.isEmptyPayload()) {
            return null;
        }
        return apolloResponse;
    }
}

