/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.network.websocket.internal;

import com.apollographql.apollo.api.ApolloRequest;
import com.apollographql.apollo.api.Operation;
import com.apollographql.apollo.api.http.HttpHeader;
import com.apollographql.apollo.exception.ApolloException;
import com.apollographql.apollo.exception.ApolloNetworkException;
import com.apollographql.apollo.exception.ApolloWebSocketClosedException;
import com.apollographql.apollo.exception.DefaultApolloException;
import com.apollographql.apollo.exception.SubscriptionConnectionException;
import com.apollographql.apollo.network.websocket.ClientMessage;
import com.apollographql.apollo.network.websocket.CompleteServerMessage;
import com.apollographql.apollo.network.websocket.ConnectionAckServerMessage;
import com.apollographql.apollo.network.websocket.ConnectionErrorServerMessage;
import com.apollographql.apollo.network.websocket.ConnectionKeepAliveServerMessage;
import com.apollographql.apollo.network.websocket.OperationErrorServerMessage;
import com.apollographql.apollo.network.websocket.ParseErrorServerMessage;
import com.apollographql.apollo.network.websocket.PingServerMessage;
import com.apollographql.apollo.network.websocket.PongServerMessage;
import com.apollographql.apollo.network.websocket.ResponseServerMessage;
import com.apollographql.apollo.network.websocket.ServerMessage;
import com.apollographql.apollo.network.websocket.WebSocket;
import com.apollographql.apollo.network.websocket.WebSocketEngine;
import com.apollographql.apollo.network.websocket.WebSocketListener;
import com.apollographql.apollo.network.websocket.WsProtocol;
import com.apollographql.apollo.network.websocket.internal.OperationListener;
import com.apollographql.apollo.network.websocket.internal.SocketState;
import com.apollographql.apollo.network.websocket.internal.SubscribableWebSocketKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlin.time.TimeMark;
import kotlin.time.TimeSource;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001BE\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0004\b\u0010\u0010\u0011J)\u0010)\u001a\u00020-2\b\u0010.\u001a\u0004\u0018\u00010\u001b2\b\u0010/\u001a\u0004\u0018\u0001002\b\u00101\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u00102J\b\u00103\u001a\u00020-H\u0016J\u0010\u00104\u001a\u00020-2\u0006\u00105\u001a\u00020\u0005H\u0016J\u0010\u00104\u001a\u00020-2\u0006\u00106\u001a\u000207H\u0016J\u0010\u00108\u001a\u00020-2\u0006\u0010.\u001a\u00020\u001bH\u0016J!\u00109\u001a\u00020-2\b\u0010/\u001a\u0004\u0018\u0001002\b\u00101\u001a\u0004\u0018\u00010\u0005H\u0016\u00a2\u0006\u0002\u0010:J&\u0010;\u001a\u00020-\"\b\b\u0000\u0010<*\u00020=2\f\u0010>\u001a\b\u0012\u0004\u0012\u0002H<0!2\u0006\u0010?\u001a\u00020\u001eJ\u001e\u0010@\u001a\u00020-\"\b\b\u0000\u0010<*\u00020=2\f\u0010>\u001a\b\u0012\u0004\u0012\u0002H<0!J\u0006\u0010A\u001a\u00020-R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u001e0\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u001f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030!0 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\"\u001a\u0004\u0018\u00010#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020%X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010&\u001a\u0004\u0018\u00010#8F\u00a2\u0006\u0006\u001a\u0004\b'\u0010(R\u0011\u0010)\u001a\u00020*8F\u00a2\u0006\u0006\u001a\u0004\b+\u0010,\u00a8\u0006B"}, d2={"Lcom/apollographql/apollo/network/websocket/internal/SubscribableWebSocket;", "Lcom/apollographql/apollo/network/websocket/WebSocketListener;", "webSocketEngine", "Lcom/apollographql/apollo/network/websocket/WebSocketEngine;", "serverUrl", "", "httpHeaders", "", "Lcom/apollographql/apollo/api/http/HttpHeader;", "dispatcher", "Lkotlinx/coroutines/CoroutineDispatcher;", "wsProtocol", "Lcom/apollographql/apollo/network/websocket/WsProtocol;", "pingIntervalMillis", "", "connectionAcknowledgeTimeoutMillis", "<init>", "(Lcom/apollographql/apollo/network/websocket/WebSocketEngine;Ljava/lang/String;Ljava/util/List;Lkotlinx/coroutines/CoroutineDispatcher;Lcom/apollographql/apollo/network/websocket/WsProtocol;JJ)V", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "ackTimeoutJob", "Lkotlinx/coroutines/Job;", "state", "Lcom/apollographql/apollo/network/websocket/internal/SocketState;", "shutdownCause", "Lcom/apollographql/apollo/exception/ApolloException;", "activeListeners", "", "Lcom/apollographql/apollo/network/websocket/internal/OperationListener;", "pending", "", "Lcom/apollographql/apollo/api/ApolloRequest;", "_lastActiveMark", "Lkotlin/time/TimeMark;", "webSocket", "Lcom/apollographql/apollo/network/websocket/WebSocket;", "lastActiveMark", "getLastActiveMark", "()Lkotlin/time/TimeMark;", "shutdown", "", "getShutdown", "()Z", "", "cause", "code", "", "reason", "(Lcom/apollographql/apollo/exception/ApolloException;Ljava/lang/Integer;Ljava/lang/String;)V", "onOpen", "onMessage", "text", "data", "", "onError", "onClosed", "(Ljava/lang/Integer;Ljava/lang/String;)V", "startOperation", "D", "Lcom/apollographql/apollo/api/Operation$Data;", "request", "listener", "stopOperation", "markActive", "apollo-runtime"})
@SourceDebugExtension(value={"SMAP\nSubscribableWebSocket.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SubscribableWebSocket.kt\ncom/apollographql/apollo/network/websocket/internal/SubscribableWebSocket\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,282:1\n1755#2,3:283\n1863#2,2:286\n1#3:288\n*S KotlinDebug\n*F\n+ 1 SubscribableWebSocket.kt\ncom/apollographql/apollo/network/websocket/internal/SubscribableWebSocket\n*L\n71#1:283,3\n107#1:286,2\n*E\n"})
public final class SubscribableWebSocket
implements WebSocketListener {
    @NotNull
    private final CoroutineDispatcher dispatcher;
    @NotNull
    private final WsProtocol wsProtocol;
    private final long pingIntervalMillis;
    private final long connectionAcknowledgeTimeoutMillis;
    @NotNull
    private ReentrantLock lock;
    @NotNull
    private final CoroutineScope scope;
    @Nullable
    private Job ackTimeoutJob;
    @NotNull
    private SocketState state;
    @Nullable
    private ApolloException shutdownCause;
    @NotNull
    private Map<String, OperationListener> activeListeners;
    @NotNull
    private List<ApolloRequest<?>> pending;
    @Nullable
    private TimeMark _lastActiveMark;
    @NotNull
    private WebSocket webSocket;

    public SubscribableWebSocket(@NotNull WebSocketEngine webSocketEngine, @NotNull String serverUrl2, @NotNull List<HttpHeader> httpHeaders, @NotNull CoroutineDispatcher dispatcher, @NotNull WsProtocol wsProtocol, long pingIntervalMillis, long connectionAcknowledgeTimeoutMillis) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter(webSocketEngine, "webSocketEngine");
            Intrinsics.checkNotNullParameter(serverUrl2, "serverUrl");
            Intrinsics.checkNotNullParameter(httpHeaders, "httpHeaders");
            Intrinsics.checkNotNullParameter(dispatcher, "dispatcher");
            Intrinsics.checkNotNullParameter(wsProtocol, "wsProtocol");
            this.dispatcher = dispatcher;
            this.wsProtocol = wsProtocol;
            this.pingIntervalMillis = pingIntervalMillis;
            this.connectionAcknowledgeTimeoutMillis = connectionAcknowledgeTimeoutMillis;
            this.lock = new ReentrantLock();
            this.scope = CoroutineScopeKt.CoroutineScope(this.dispatcher);
            this.state = SocketState.AwaitOpen;
            this.activeListeners = new LinkedHashMap();
            this.pending = new ArrayList();
            Iterable $this$any$iv = httpHeaders;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    HttpHeader it = (HttpHeader)element$iv;
                    boolean bl2 = false;
                    String string = it.getName().toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
                    if (!Intrinsics.areEqual(string, "sec-websocket-protocol")) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        List<HttpHeader> headers = bl ? httpHeaders : CollectionsKt.plus((Collection)httpHeaders, new HttpHeader("Sec-WebSocket-Protocol", this.wsProtocol.getName()));
        this.webSocket = webSocketEngine.newWebSocket(serverUrl2, headers, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final TimeMark getLastActiveMark() {
        TimeMark timeMark;
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            boolean bl = false;
            timeMark = this._lastActiveMark;
        }
        finally {
            reentrantLock.unlock();
        }
        return timeMark;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean getShutdown() {
        boolean bl;
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            boolean bl2 = false;
            bl = this.state == SocketState.ShutDown;
        }
        finally {
            reentrantLock.unlock();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void shutdown(@Nullable ApolloException cause, @Nullable Integer code, @Nullable String reason) {
        List listeners = new ArrayList();
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            boolean bl = false;
            if (this.state == SocketState.ShutDown) {
                return;
            }
            CoroutineScopeKt.cancel$default(this.scope, null, 1, null);
            this.state = SocketState.ShutDown;
            this.shutdownCause = cause;
            listeners.addAll(this.activeListeners.values());
            this.activeListeners.clear();
            Unit $i$a$-withLock-SubscribableWebSocket$shutdown$3 = Unit.INSTANCE;
        }
        finally {
            reentrantLock.unlock();
        }
        if (code != null && reason != null) {
            this.webSocket.close(code, reason);
        }
        Iterable $this$forEach$iv = listeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            OperationListener it = (OperationListener)element$iv;
            boolean bl = false;
            if (cause == null) {
                it.onComplete();
                continue;
            }
            it.onTransportError(cause);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onOpen() {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            boolean bl = false;
            if (WhenMappings.$EnumSwitchMapping$0[this.state.ordinal()] == 1) {
                BuildersKt.launch$default(this.scope, this.dispatcher, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                    Object L$0;
                    int label;
                    final /* synthetic */ SubscribableWebSocket this$0;
                    {
                        this.this$0 = $receiver;
                        super(2, $completion);
                    }

                    /*
                     * Unable to fully structure code
                     */
                    public final Object invokeSuspend(Object var1_1) {
                        var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure(var1_1);
                                var2_3 = SubscribableWebSocket.access$getWebSocket$p(this.this$0);
                                this.L$0 = var2_3;
                                this.label = 1;
                                v0 = SubscribableWebSocket.access$getWsProtocol$p(this.this$0).connectionInit(this);
                                if (v0 == var3_2) {
                                    return var3_2;
                                }
                                ** GOTO lbl16
                            }
                            case 1: {
                                var2_3 = (WebSocket)this.L$0;
                                ResultKt.throwOnFailure($result);
                                v0 = $result;
lbl16:
                                // 2 sources

                                SubscribableWebSocketKt.access$send(var2_3, (ClientMessage)v0);
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }, 2, null);
                this.ackTimeoutJob = BuildersKt.launch$default(this.scope, this.dispatcher, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                    int label;
                    final /* synthetic */ SubscribableWebSocket this$0;
                    {
                        this.this$0 = $receiver;
                        super(2, $completion);
                    }

                    /*
                     * Unable to fully structure code
                     */
                    public final Object invokeSuspend(Object var1_1) {
                        var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure(var1_1);
                                this.label = 1;
                                v0 = DelayKt.delay(SubscribableWebSocket.access$getConnectionAcknowledgeTimeoutMillis$p(this.this$0), this);
                                if (v0 == var2_2) {
                                    return var2_2;
                                }
                                ** GOTO lbl13
                            }
                            case 1: {
                                ResultKt.throwOnFailure($result);
                                v0 = $result;
lbl13:
                                // 2 sources

                                this.this$0.shutdown(new ApolloNetworkException("Timeout while waiting for connection_ack", (Object)null, 2, null), Boxing.boxInt(1001), "Timeout while waiting for connection_ack");
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }, 2, null);
                this.state = SocketState.AwaitAck;
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onMessage(@NotNull String text) {
        Intrinsics.checkNotNullParameter(text, "text");
        ServerMessage message = this.wsProtocol.parseServerMessage(text);
        if (Intrinsics.areEqual(message, ConnectionAckServerMessage.INSTANCE)) {
            Job job = this.ackTimeoutJob;
            if (job != null) {
                Job.DefaultImpls.cancel$default(job, null, 1, null);
            }
            this.ackTimeoutJob = null;
            ReentrantLock reentrantLock = this.lock;
            reentrantLock.lock();
            try {
                boolean bl = false;
                if (this.state != SocketState.AwaitAck) {
                    return;
                }
                this.state = SocketState.Connected;
                if (this.pingIntervalMillis > 0L) {
                    BuildersKt.launch$default(this.scope, null, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                        int label;
                        final /* synthetic */ SubscribableWebSocket this$0;
                        {
                            this.this$0 = $receiver;
                            super(2, $completion);
                        }

                        /*
                         * Unable to fully structure code
                         */
                        public final Object invokeSuspend(Object var1_1) {
                            var6_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure(var1_1);
lbl6:
                                    // 3 sources

                                    while (true) {
                                        this.label = 1;
                                        v0 = DelayKt.delay(SubscribableWebSocket.access$getPingIntervalMillis$p(this.this$0), this);
                                        if (v0 == var6_2) {
                                            return var6_2;
                                        }
                                        ** GOTO lbl15
                                        break;
                                    }
                                }
                                case 1: {
                                    ResultKt.throwOnFailure($result);
                                    v0 = $result;
lbl15:
                                    // 2 sources

                                    if (SubscribableWebSocket.access$getWsProtocol$p(this.this$0).ping() == null) ** GOTO lbl21
                                    var3_4 = this.this$0;
                                    it = var2_3;
                                    $i$a$-let-SubscribableWebSocket$onMessage$1$1$1 = false;
                                    SubscribableWebSocketKt.access$send(SubscribableWebSocket.access$getWebSocket$p(var3_4), it);
                                    ** GOTO lbl6
lbl21:
                                    // 1 sources

                                    ** continue;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                            return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                        }

                        public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }, 3, null);
                }
                Job job2 = BuildersKt.launch$default(this.scope, null, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                    Object L$0;
                    Object L$1;
                    Object L$2;
                    int label;
                    final /* synthetic */ SubscribableWebSocket this$0;
                    {
                        this.this$0 = $receiver;
                        super(2, $completion);
                    }

                    /*
                     * Unable to fully structure code
                     */
                    public final Object invokeSuspend(Object var1_1) {
                        var10_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure(var1_1);
                                var2_3 = SubscribableWebSocket.access$getPending$p(this.this$0);
                                var3_4 = this.this$0;
                                $i$f$forEach = false;
                                var5_6 = $this$forEach$iv.iterator();
lbl9:
                                // 2 sources

                                while (var5_6.hasNext()) {
                                    element$iv = var5_6.next();
                                    it = (ApolloRequest)element$iv;
                                    $i$a$-forEach-SubscribableWebSocket$onMessage$1$2$1 = false;
                                    var9_10 = SubscribableWebSocket.access$getWebSocket$p(var3_4);
                                    this.L$0 = var3_4;
                                    this.L$1 = var5_6;
                                    this.L$2 = var9_10;
                                    this.label = 1;
                                    v0 = SubscribableWebSocket.access$getWsProtocol$p(var3_4).operationStart(it, this);
                                    if (v0 == var10_2) {
                                        return var10_2;
                                    }
                                    ** GOTO lbl31
                                }
                                break;
                            }
                            case 1: {
                                $i$f$forEach = false;
                                $i$a$-forEach-SubscribableWebSocket$onMessage$1$2$1 = false;
                                var9_10 = (WebSocket)this.L$2;
                                var5_6 = (Iterator<T>)this.L$1;
                                var3_4 = (SubscribableWebSocket)this.L$0;
                                ResultKt.throwOnFailure($result);
                                v0 = $result;
lbl31:
                                // 2 sources

                                SubscribableWebSocketKt.access$send(var9_10, (ClientMessage)v0);
                                ** GOTO lbl9
                            }
                        }
                        return Unit.INSTANCE;
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }, 3, null);
            }
            finally {
                reentrantLock.unlock();
            }
        }
        if (message instanceof ConnectionErrorServerMessage) {
            this.shutdown(new SubscriptionConnectionException(((ConnectionErrorServerMessage)message).getPayload()), 1001, "Connection error");
        } else if (message instanceof ResponseServerMessage) {
            OperationListener operationListener;
            ReentrantLock reentrantLock = this.lock;
            reentrantLock.lock();
            try {
                boolean $i$a$-withLock-SubscribableWebSocket$onMessage$52 = false;
                OperationListener $i$a$-withLock-SubscribableWebSocket$onMessage$52 = this.activeListeners.get(((ResponseServerMessage)message).getId());
                operationListener = $i$a$-withLock-SubscribableWebSocket$onMessage$52;
            }
            finally {
                reentrantLock.unlock();
            }
            if (operationListener != null) {
                operationListener.onResponse(((ResponseServerMessage)message).getResponse());
            }
        } else if (message instanceof CompleteServerMessage) {
            OperationListener operationListener;
            ReentrantLock reentrantLock = this.lock;
            reentrantLock.lock();
            try {
                boolean $i$a$-withLock-SubscribableWebSocket$onMessage$62 = false;
                OperationListener $i$a$-withLock-SubscribableWebSocket$onMessage$62 = this.activeListeners.get(((CompleteServerMessage)message).getId());
                operationListener = $i$a$-withLock-SubscribableWebSocket$onMessage$62;
            }
            finally {
                reentrantLock.unlock();
            }
            if (operationListener != null) {
                operationListener.onComplete();
            }
        } else if (message instanceof OperationErrorServerMessage) {
            OperationListener operationListener;
            ReentrantLock reentrantLock = this.lock;
            reentrantLock.lock();
            try {
                boolean $i$a$-withLock-SubscribableWebSocket$onMessage$72 = false;
                OperationListener $i$a$-withLock-SubscribableWebSocket$onMessage$72 = this.activeListeners.get(((OperationErrorServerMessage)message).getId());
                operationListener = $i$a$-withLock-SubscribableWebSocket$onMessage$72;
            }
            finally {
                reentrantLock.unlock();
            }
            if (operationListener != null) {
                operationListener.onError(((OperationErrorServerMessage)message).getPayload());
            }
        } else if (message instanceof ParseErrorServerMessage) {
            System.out.println((Object)("Cannot parse message: '" + ((ParseErrorServerMessage)message).getErrorMessage() + '\''));
        } else if (Intrinsics.areEqual(message, PingServerMessage.INSTANCE)) {
            ClientMessage clientMessage = this.wsProtocol.pong();
            if (clientMessage != null) {
                ClientMessage it = clientMessage;
                boolean bl = false;
                SubscribableWebSocketKt.access$send(this.webSocket, it);
            }
        } else if (!Intrinsics.areEqual(message, PongServerMessage.INSTANCE) && !Intrinsics.areEqual(message, ConnectionKeepAliveServerMessage.INSTANCE)) {
            throw new NoWhenBranchMatchedException();
        }
    }

    @Override
    public void onMessage(@NotNull byte[] data) {
        Intrinsics.checkNotNullParameter(data, "data");
        this.onMessage(StringsKt.decodeToString(data));
    }

    @Override
    public void onError(@NotNull ApolloException cause) {
        Intrinsics.checkNotNullParameter(cause, "cause");
        this.shutdown(cause, null, null);
    }

    @Override
    public void onClosed(@Nullable Integer code, @Nullable String reason) {
        Integer n = code;
        this.shutdown(new ApolloWebSocketClosedException(n != null ? n : 1000, reason, null, 4, null), null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <D extends Operation.Data> void startOperation(@NotNull ApolloRequest<D> request, @NotNull OperationListener listener2) {
        Intrinsics.checkNotNullParameter(request, "request");
        Intrinsics.checkNotNullParameter(listener2, "listener");
        DefaultApolloException cause = null;
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            Object object;
            boolean bl = false;
            switch (WhenMappings.$EnumSwitchMapping$0[this.state.ordinal()]) {
                case 1: 
                case 2: {
                    String string = request.getRequestUuid().toString();
                    Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
                    this.activeListeners.put(string, listener2);
                    object = this.pending.add(request);
                    break;
                }
                case 3: {
                    String string = request.getRequestUuid().toString();
                    Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
                    this.activeListeners.put(string, listener2);
                    object = BuildersKt.launch$default(this.scope, null, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, request, null){
                        Object L$0;
                        int label;
                        final /* synthetic */ SubscribableWebSocket this$0;
                        final /* synthetic */ ApolloRequest<D> $request;
                        {
                            this.this$0 = $receiver;
                            this.$request = $request;
                            super(2, $completion);
                        }

                        /*
                         * Unable to fully structure code
                         */
                        public final Object invokeSuspend(Object var1_1) {
                            var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure(var1_1);
                                    var2_3 = SubscribableWebSocket.access$getWebSocket$p(this.this$0);
                                    this.L$0 = var2_3;
                                    this.label = 1;
                                    v0 = SubscribableWebSocket.access$getWsProtocol$p(this.this$0).operationStart(this.$request, this);
                                    if (v0 == var3_2) {
                                        return var3_2;
                                    }
                                    ** GOTO lbl16
                                }
                                case 1: {
                                    var2_3 = (WebSocket)this.L$0;
                                    ResultKt.throwOnFailure($result);
                                    v0 = $result;
lbl16:
                                    // 2 sources

                                    SubscribableWebSocketKt.access$send(var2_3, (ClientMessage)v0);
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                            return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                        }

                        public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }, 3, null);
                    break;
                }
                case 4: {
                    cause = new DefaultApolloException("Apollo: the WebSocket is shut down", this.shutdownCause);
                    object = Unit.INSTANCE;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            Unit unit = object;
        }
        finally {
            reentrantLock.unlock();
        }
        if (cause != null) {
            listener2.onTransportError(cause);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <D extends Operation.Data> void stopOperation(@NotNull ApolloRequest<D> request) {
        boolean bl;
        Intrinsics.checkNotNullParameter(request, "request");
        String string = request.getRequestUuid().toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        String id = string;
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            boolean bl2 = false;
            boolean ret = false;
            if (this.activeListeners.containsKey(id)) {
                this.activeListeners.remove(id);
                ret = true;
            }
            if (this.activeListeners.isEmpty()) {
                this._lastActiveMark = TimeSource.Monotonic.ValueTimeMark.box-impl(TimeSource.Monotonic.INSTANCE.markNow-z9LOYto());
            }
            bl = ret;
        }
        finally {
            reentrantLock.unlock();
        }
        boolean removed = bl;
        if (!removed) {
            return;
        }
        BuildersKt.launch$default(this.scope, null, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, request, null){
            int label;
            final /* synthetic */ SubscribableWebSocket this$0;
            final /* synthetic */ ApolloRequest<D> $request;
            {
                this.this$0 = $receiver;
                this.$request = $request;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure(object);
                        SubscribableWebSocketKt.access$send(SubscribableWebSocket.access$getWebSocket$p(this.this$0), SubscribableWebSocket.access$getWsProtocol$p(this.this$0).operationStop(this.$request));
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 3, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void markActive() {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            boolean bl = false;
            this._lastActiveMark = null;
            Unit unit = Unit.INSTANCE;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    public static final /* synthetic */ WebSocket access$getWebSocket$p(SubscribableWebSocket $this) {
        return $this.webSocket;
    }

    public static final /* synthetic */ WsProtocol access$getWsProtocol$p(SubscribableWebSocket $this) {
        return $this.wsProtocol;
    }

    public static final /* synthetic */ long access$getConnectionAcknowledgeTimeoutMillis$p(SubscribableWebSocket $this) {
        return $this.connectionAcknowledgeTimeoutMillis;
    }

    public static final /* synthetic */ long access$getPingIntervalMillis$p(SubscribableWebSocket $this) {
        return $this.pingIntervalMillis;
    }

    public static final /* synthetic */ List access$getPending$p(SubscribableWebSocket $this) {
        return $this.pending;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SocketState.values().length];
            try {
                nArray[SocketState.AwaitOpen.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SocketState.AwaitAck.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SocketState.Connected.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SocketState.ShutDown.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

