/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.network.websocket.internal;

import com.apollographql.apollo.api.http.HttpHeader;
import com.apollographql.apollo.exception.ApolloException;
import com.apollographql.apollo.network.websocket.WebSocketEngine;
import com.apollographql.apollo.network.websocket.WsProtocol;
import com.apollographql.apollo.network.websocket.internal.SubscribableWebSocket;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.Duration;
import kotlin.time.TimeMark;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001BE\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\f\u0012\u0006\u0010\u000e\u001a\u00020\f\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\fH\u0002J\u0006\u0010\u001e\u001a\u00020\u0018J\b\u0010\u001f\u001a\u00020\fH\u0002J\u0006\u0010 \u001a\u00020\u001cJ\u0010\u0010!\u001a\u00020\u001c2\b\u0010\"\u001a\u0004\u0018\u00010#R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/apollographql/apollo/network/websocket/internal/WebSocketHolder;", "", "webSocketEngine", "Lcom/apollographql/apollo/network/websocket/WebSocketEngine;", "serverUrl", "", "httpHeaders", "", "Lcom/apollographql/apollo/api/http/HttpHeader;", "wsProtocol", "Lcom/apollographql/apollo/network/websocket/WsProtocol;", "connectionAcknowledgeTimeoutMillis", "", "pingIntervalMillis", "idleTimeoutMillis", "<init>", "(Lcom/apollographql/apollo/network/websocket/WebSocketEngine;Ljava/lang/String;Ljava/util/List;Lcom/apollographql/apollo/network/websocket/WsProtocol;JJJ)V", "dispatcher", "Lkotlinx/coroutines/CoroutineDispatcher;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "idleJob", "Lkotlinx/coroutines/Job;", "subscribableWebSocket", "Lcom/apollographql/apollo/network/websocket/internal/SubscribableWebSocket;", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "triggerCleanup", "", "timeoutMillis", "acquire", "cleanupLocked", "close", "closeCurrentConnection", "reason", "Lcom/apollographql/apollo/exception/ApolloException;", "apollo-runtime"})
public final class WebSocketHolder {
    @NotNull
    private final WebSocketEngine webSocketEngine;
    @NotNull
    private final String serverUrl;
    @NotNull
    private final List<HttpHeader> httpHeaders;
    @NotNull
    private final WsProtocol wsProtocol;
    private final long connectionAcknowledgeTimeoutMillis;
    private final long pingIntervalMillis;
    private final long idleTimeoutMillis;
    @NotNull
    private final CoroutineDispatcher dispatcher;
    @NotNull
    private final CoroutineScope scope;
    @Nullable
    private Job idleJob;
    @Nullable
    private SubscribableWebSocket subscribableWebSocket;
    @NotNull
    private ReentrantLock lock;

    public WebSocketHolder(@NotNull WebSocketEngine webSocketEngine, @NotNull String serverUrl2, @NotNull List<HttpHeader> httpHeaders, @NotNull WsProtocol wsProtocol, long connectionAcknowledgeTimeoutMillis, long pingIntervalMillis, long idleTimeoutMillis) {
        Intrinsics.checkNotNullParameter(webSocketEngine, "webSocketEngine");
        Intrinsics.checkNotNullParameter(serverUrl2, "serverUrl");
        Intrinsics.checkNotNullParameter(httpHeaders, "httpHeaders");
        Intrinsics.checkNotNullParameter(wsProtocol, "wsProtocol");
        this.webSocketEngine = webSocketEngine;
        this.serverUrl = serverUrl2;
        this.httpHeaders = httpHeaders;
        this.wsProtocol = wsProtocol;
        this.connectionAcknowledgeTimeoutMillis = connectionAcknowledgeTimeoutMillis;
        this.pingIntervalMillis = pingIntervalMillis;
        this.idleTimeoutMillis = idleTimeoutMillis;
        this.dispatcher = Dispatchers.getDefault();
        this.scope = CoroutineScopeKt.CoroutineScope(this.dispatcher);
        this.lock = new ReentrantLock();
        if (!(this.idleTimeoutMillis > 0L)) {
            boolean bl = false;
            String string = "Apollo: 'idleTimeoutMillis' must be > 0";
            throw new IllegalStateException(string.toString());
        }
        this.triggerCleanup(this.idleTimeoutMillis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void triggerCleanup(long timeoutMillis) {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            boolean bl = false;
            Job job = this.idleJob;
            if (job != null) {
                Job.DefaultImpls.cancel$default(job, null, 1, null);
            }
            this.idleJob = BuildersKt.launch$default(this.scope, null, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(timeoutMillis, this, null){
                int label;
                final /* synthetic */ long $timeoutMillis;
                final /* synthetic */ WebSocketHolder this$0;
                {
                    this.$timeoutMillis = $timeoutMillis;
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Unable to fully structure code
                 */
                public final Object invokeSuspend(Object var1_1) {
                    var8_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure(var1_1);
                            this.label = 1;
                            v0 = DelayKt.delay(this.$timeoutMillis, this);
                            if (v0 == var8_2) {
                                return var8_2;
                            }
                            ** GOTO lbl13
                        }
                        case 1: {
                            ResultKt.throwOnFailure($result);
                            v0 = $result;
lbl13:
                            // 2 sources

                            var4_3 = WebSocketHolder.access$getLock$p(this.this$0);
                            var5_4 = this.this$0;
                            var4_3.lock();
                            try {
                                $i$a$-withLock-WebSocketHolder$triggerCleanup$1$1$next$1 = false;
                                var6_6 = WebSocketHolder.access$cleanupLocked(var5_4);
                            }
                            finally {
                                var4_3.unlock();
                            }
                            next = var6_6;
                            WebSocketHolder.access$triggerCleanup(this.this$0, next);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }, 3, null);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final SubscribableWebSocket acquire() {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            boolean bl = false;
            this.cleanupLocked();
            if (this.subscribableWebSocket == null) {
                this.subscribableWebSocket = new SubscribableWebSocket(this.webSocketEngine, this.serverUrl, this.httpHeaders, this.dispatcher, this.wsProtocol, this.pingIntervalMillis, this.connectionAcknowledgeTimeoutMillis);
            }
            SubscribableWebSocket subscribableWebSocket = this.subscribableWebSocket;
            Intrinsics.checkNotNull(subscribableWebSocket);
            subscribableWebSocket.markActive();
            SubscribableWebSocket subscribableWebSocket2 = this.subscribableWebSocket;
            Intrinsics.checkNotNull(subscribableWebSocket2);
            SubscribableWebSocket subscribableWebSocket3 = subscribableWebSocket2;
            return subscribableWebSocket3;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    private final long cleanupLocked() {
        if (this.subscribableWebSocket != null) {
            SubscribableWebSocket subscribableWebSocket = this.subscribableWebSocket;
            Intrinsics.checkNotNull(subscribableWebSocket);
            if (subscribableWebSocket.getShutdown()) {
                this.subscribableWebSocket = null;
                return this.idleTimeoutMillis;
            }
            SubscribableWebSocket subscribableWebSocket2 = this.subscribableWebSocket;
            Intrinsics.checkNotNull(subscribableWebSocket2);
            TimeMark lastActiveMark = subscribableWebSocket2.getLastActiveMark();
            if (lastActiveMark != null) {
                long elapsed = Duration.getInWholeMilliseconds-impl(lastActiveMark.elapsedNow-UwyO8pc());
                if (elapsed > this.idleTimeoutMillis) {
                    SubscribableWebSocket subscribableWebSocket3 = this.subscribableWebSocket;
                    Intrinsics.checkNotNull(subscribableWebSocket3);
                    subscribableWebSocket3.shutdown(null, 1001, "Idle");
                    this.subscribableWebSocket = null;
                } else {
                    return this.idleTimeoutMillis - elapsed;
                }
            }
        }
        return this.idleTimeoutMillis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void close() {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            boolean bl = false;
            CoroutineScopeKt.cancel$default(this.scope, null, 1, null);
            this.webSocketEngine.close();
            if (this.subscribableWebSocket != null) {
                SubscribableWebSocket subscribableWebSocket = this.subscribableWebSocket;
                Intrinsics.checkNotNull(subscribableWebSocket);
                subscribableWebSocket.shutdown(null, 1001, "Canceled");
                this.subscribableWebSocket = null;
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void closeCurrentConnection(@Nullable ApolloException reason) {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            boolean bl = false;
            if (this.subscribableWebSocket != null) {
                SubscribableWebSocket subscribableWebSocket = this.subscribableWebSocket;
                Intrinsics.checkNotNull(subscribableWebSocket);
                subscribableWebSocket.shutdown(reason, 1001, "Client requested closing the connection");
                this.subscribableWebSocket = null;
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    public static final /* synthetic */ ReentrantLock access$getLock$p(WebSocketHolder $this) {
        return $this.lock;
    }

    public static final /* synthetic */ void access$triggerCleanup(WebSocketHolder $this, long timeoutMillis) {
        $this.triggerCleanup(timeoutMillis);
    }

    public static final /* synthetic */ long access$cleanupLocked(WebSocketHolder $this) {
        return $this.cleanupLocked();
    }
}

