/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.coroutines.scheduling;

import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import kotlin.Metadata;
import kotlin.coroutines.CoroutineContext;
import kotlinx.coroutines.ExecutorCoroutineDispatcher;
import kotlinx.coroutines.scheduling.ExperimentalCoroutineDispatcher;
import kotlinx.coroutines.scheduling.TaskContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B'\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\u0006\u0010\n\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u0018H\u0016J\u001c\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001c2\n\u0010\u001d\u001a\u00060\u0013j\u0002`\u0014H\u0016J\u001c\u0010\u001a\u001a\u00020\u00182\n\u0010\u001d\u001a\u00060\u0013j\u0002`\u00142\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u001c\u0010 \u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001c2\n\u0010\u001d\u001a\u00060\u0013j\u0002`\u0014H\u0016J\u0014\u0010!\u001a\u00020\u00182\n\u0010\"\u001a\u00060\u0013j\u0002`\u0014H\u0016J\b\u0010#\u001a\u00020\tH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\t\u0010\u000f\u001a\u00020\u0010X\u0082\u0004R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0011\u001a\f\u0012\b\u0012\u00060\u0013j\u0002`\u00140\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006$"}, d2={"Lkotlinx/coroutines/scheduling/LimitingDispatcher;", "Lkotlinx/coroutines/ExecutorCoroutineDispatcher;", "Lkotlinx/coroutines/scheduling/TaskContext;", "Ljava/util/concurrent/Executor;", "dispatcher", "Lkotlinx/coroutines/scheduling/ExperimentalCoroutineDispatcher;", "parallelism", "", "name", "", "taskMode", "(Lkotlinx/coroutines/scheduling/ExperimentalCoroutineDispatcher;ILjava/lang/String;I)V", "executor", "getExecutor", "()Ljava/util/concurrent/Executor;", "inFlightTasks", "Lkotlinx/atomicfu/AtomicInt;", "queue", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "Ljava/lang/Runnable;", "Lkotlinx/coroutines/Runnable;", "getTaskMode", "()I", "afterTask", "", "close", "dispatch", "context", "Lkotlin/coroutines/CoroutineContext;", "block", "tailDispatch", "", "dispatchYield", "execute", "command", "toString", "kotlinx-coroutines-core"})
final class LimitingDispatcher
extends ExecutorCoroutineDispatcher
implements TaskContext,
Executor {
    @NotNull
    private final ExperimentalCoroutineDispatcher dispatcher;
    private final int parallelism;
    @Nullable
    private final String name;
    private final int taskMode;
    @NotNull
    private final ConcurrentLinkedQueue<Runnable> queue;
    private volatile /* synthetic */ int inFlightTasks$volatile;
    private static final /* synthetic */ AtomicIntegerFieldUpdater inFlightTasks$volatile$FU;

    public LimitingDispatcher(@NotNull ExperimentalCoroutineDispatcher dispatcher, int parallelism, @Nullable String name, int taskMode) {
        this.dispatcher = dispatcher;
        this.parallelism = parallelism;
        this.name = name;
        this.taskMode = taskMode;
        this.queue = new ConcurrentLinkedQueue();
    }

    @Override
    public int getTaskMode() {
        return this.taskMode;
    }

    private final /* synthetic */ int getInFlightTasks$volatile() {
        return this.inFlightTasks$volatile;
    }

    private final /* synthetic */ void setInFlightTasks$volatile(int value) {
        this.inFlightTasks$volatile = value;
    }

    @Override
    @NotNull
    public Executor getExecutor() {
        return this;
    }

    @Override
    public void execute(@NotNull Runnable command2) {
        this.dispatch(command2, false);
    }

    @Override
    public void close() {
        throw new IllegalStateException("Close cannot be invoked on LimitingBlockingDispatcher".toString());
    }

    @Override
    public void dispatch(@NotNull CoroutineContext context, @NotNull Runnable block) {
        this.dispatch(block, false);
    }

    private final void dispatch(Runnable block, boolean tailDispatch) {
        Runnable taskToSchedule = block;
        while (true) {
            int inFlight;
            if ((inFlight = LimitingDispatcher.inFlightTasks$volatile$FU.incrementAndGet(this)) <= this.parallelism) {
                this.dispatcher.dispatchWithContext$kotlinx_coroutines_core(taskToSchedule, this, tailDispatch);
                return;
            }
            this.queue.add(taskToSchedule);
            if (LimitingDispatcher.inFlightTasks$volatile$FU.decrementAndGet(this) >= this.parallelism) {
                return;
            }
            if (this.queue.poll() != null) continue;
            return;
        }
    }

    @Override
    public void dispatchYield(@NotNull CoroutineContext context, @NotNull Runnable block) {
        this.dispatch(block, true);
    }

    @Override
    @NotNull
    public String toString() {
        String string = this.name;
        if (string == null) {
            string = super.toString() + "[dispatcher = " + this.dispatcher + ']';
        }
        return string;
    }

    @Override
    public void afterTask() {
        Runnable next = this.queue.poll();
        if (next != null) {
            this.dispatcher.dispatchWithContext$kotlinx_coroutines_core(next, this, true);
            return;
        }
        LimitingDispatcher.inFlightTasks$volatile$FU.decrementAndGet(this);
        Runnable runnable2 = this.queue.poll();
        if (runnable2 == null) {
            return;
        }
        next = runnable2;
        this.dispatch(next, true);
    }

    static {
        inFlightTasks$volatile$FU = AtomicIntegerFieldUpdater.newUpdater(LimitingDispatcher.class, "inFlightTasks$volatile");
    }
}

