package com.example.myapplication;

import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import androidx.recyclerview.widget.StaggeredGridLayoutManager;

import java.util.ArrayList;
import java.util.List;

public class TestAdapter extends RecyclerView.Adapter<TestAdapter.TestViewHolder> {

    private final ArrayList<Boolean> mData;

    public TestAdapter(List<Boolean> data) {
        mData = new ArrayList<>(data);
    }

    @NonNull
    @Override
    public TestViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        return new TestViewHolder(LayoutInflater.from(parent.getContext())
                .inflate(R.layout.item, parent, false));
    }

    @Override
    public void onBindViewHolder(@NonNull TestViewHolder holder, int position) {
        boolean isFullSpan = mData.get(position);
        holder.setText(position);
        holder.setFullSpan(isFullSpan);
    }

    @Override
    public int getItemCount() {
        return mData.size();
    }

    void addItemAt(int position, boolean isFullSpan) {
        mData.add(position, isFullSpan);
        notifyItemInserted(position);
    }

    class TestViewHolder extends RecyclerView.ViewHolder {
        private final TextView mTextView;

        public TestViewHolder(@NonNull View itemView) {
            super(itemView);
            mTextView = itemView.findViewById(R.id.tvItem);
        }

        public void setText(int position) {
            mTextView.setText("Item " + position);
        }

        public void setFullSpan(boolean isFullSpan) {
            final StaggeredGridLayoutManager.LayoutParams layoutParams =
                    new StaggeredGridLayoutManager.LayoutParams(ViewGroup.LayoutParams.WRAP_CONTENT, ViewGroup.LayoutParams.WRAP_CONTENT);
            layoutParams.setFullSpan(isFullSpan);
            itemView.setLayoutParams(layoutParams);
        }
    }
}
