package de.worldiety.crashtest;

import android.support.v7.app.AppCompatActivity;
import android.os.Bundle;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class MainActivity extends AppCompatActivity {

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Button crashMe = new Button(this);
        crashMe.setText("action");
        setContentView(crashMe);
        crashMe.setOnClickListener(new OnClickListener() {
            @Override
            public void onClick(View v) {
                debugMe();
            }
        });
    }

    private void debugMe() {
        ExecutorService exec = Executors.newFixedThreadPool(128);
        List<Future<Integer>> res = new ArrayList<>();
        for (int i = 0; i < 10000; i++) {
            final int num = i;
            res.add(exec.submit(new Callable<Integer>() {
                @Override
                public Integer call() throws Exception {
                    if (num % 2 != 0) {
                        throw new RuntimeException("uneven");
                    }
                    return num;
                }
            }));
        }
        long sum = 0;
        for (Future<Integer> f : res) {
            try {
                sum += f.get();
            } catch (Exception e) {
//                throw new RuntimeException(e);
            }
        }
        System.out.println("done: " + sum);
    }


}
