/*
 * Decompiled with CFR 0.152.
 */
package android.support.v7.widget;

import android.content.Context;
import android.content.ContextWrapper;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.support.v7.widget.ResourcesWrapper;
import android.support.v7.widget.TintManager;

class TintContextWrapper
extends ContextWrapper {
    private Resources mResources;

    public static Context wrap(Context context) {
        if (!(context instanceof TintContextWrapper)) {
            context = new TintContextWrapper((Context)context);
        }
        return context;
    }

    private TintContextWrapper(Context base) {
        super(base);
    }

    public Resources getResources() {
        if (this.mResources == null) {
            this.mResources = new TintResources(super.getResources(), TintManager.get((Context)this));
        }
        return this.mResources;
    }

    static class TintResources
    extends ResourcesWrapper {
        private final TintManager mTintManager;

        public TintResources(Resources resources, TintManager tintManager) {
            super(resources);
            this.mTintManager = tintManager;
        }

        @Override
        public Drawable getDrawable(int id2) throws Resources.NotFoundException {
            Drawable d = super.getDrawable(id2);
            if (d != null) {
                this.mTintManager.tintDrawableUsingColorFilter(id2, d);
            }
            return d;
        }
    }
}

